/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor.elements;

import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.metadataeditor.elements.AdvancedControlElement;
import info.textgrid.lab.core.metadataeditor.elements.IControl;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableComposite;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableItemsGroup;
import info.textgrid.lab.core.metadataeditor.elements.NotImplementedException;
import info.textgrid.lab.core.metadataeditor.elements.RepeatControlElement;
import info.textgrid.lab.core.metadataeditor.utils.OMUtil;
import info.textgrid.lab.core.model.TextGridObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jaxen.JaxenException;

public class RepeatItemsGroup
implements IRepresentableItemsGroup {
    private LinkedList<AdvancedControlElement> advancedControls = new LinkedList();
    private String nameOfTheFirstElement = null;
    private Button remove_btn = null;
    private RepeatControlElement parent = null;

    public RepeatItemsGroup(RepeatControlElement parent) {
        this.parent = parent;
    }

    void addControl(AdvancedControlElement e) {
        this.advancedControls.addLast(e);
        e.setItemsGroup(this);
    }

    void addRemoveButton(Button b) {
        this.remove_btn = b;
    }

    void activateRemoveButton(boolean active) {
        if (this.remove_btn != null && !this.remove_btn.isDisposed()) {
            this.remove_btn.setEnabled(active);
        }
    }

    @Override
    public void clear() {
        for (AdvancedControlElement e : this.advancedControls) {
            e.clear();
        }
    }

    private void setNameOfTheFirstElement() {
        for (AdvancedControlElement e : this.advancedControls) {
            if (!(e.getSWTControl() instanceof Text) && !(e.getSWTControl() instanceof Combo) && !(e.getSWTControl() instanceof org.eclipse.swt.widgets.List)) continue;
            this.nameOfTheFirstElement = e.getName();
            break;
        }
    }

    public LinkedList<AdvancedControlElement> getAdvancedControls() {
        return this.advancedControls;
    }

    public LinkedList<AdvancedControlElement> getAdvancedControlsByRef(String refId) {
        LinkedList<AdvancedControlElement> controls = new LinkedList<AdvancedControlElement>();
        for (AdvancedControlElement ad : this.advancedControls) {
            if (!ad.getRefId().equals(refId)) continue;
            controls.add(ad);
        }
        return controls;
    }

    @Override
    public Control getFirstControlByName(String name) {
        for (AdvancedControlElement e : this.advancedControls) {
            if (!e.getName().equals(name)) continue;
            return e.getSWTControl();
        }
        return null;
    }

    String getIdByRefId(String refId) {
        for (AdvancedControlElement e : this.advancedControls) {
            if (!e.getRefId().equals(refId)) continue;
            return e.getId();
        }
        return refId;
    }

    private AdvancedControlElement getAdvancedControlElementById(String id) {
        for (AdvancedControlElement e : this.advancedControls) {
            if (!e.getId().equals(id) && !e.getRefId().equals(id)) continue;
            return e;
        }
        return null;
    }

    void createOMElements(OMFactory omFactory, OMElement parent, OMNamespace ns) {
        for (AdvancedControlElement e : this.advancedControls) {
            if (e.getRef() != null) {
                AdvancedControlElement ac = this.getAdvancedControlElementById(e.getRef());
                if (ac == null) continue;
                e.createOMElement(omFactory, ac.getOMElement(), ns, true);
                continue;
            }
            e.createOMElement(omFactory, parent, ns, false);
        }
    }

    boolean setOMElement(OMElement root, RepeatControlElement repE, boolean tg) {
        boolean found = false;
        if (this.nameOfTheFirstElement == null) {
            this.setNameOfTheFirstElement();
        }
        OMElement elem = null;
        List elems = null;
        try {
            elems = tg ? OMUtil.getElementListWithName(this.nameOfTheFirstElement, root, "http://textgrid.info/namespaces/metadata/core/2010", "tg") : OMUtil.getElementListWithName(this.nameOfTheFirstElement, root, TextGridObject.CUSTOM_NAMESPACE, "cns");
        }
        catch (JaxenException e) {
            Activator.handleError(e);
            return false;
        }
        int count = elems.size();
        for (Object o : elems) {
            elem = (OMElement)o;
            if (elem == null) continue;
            for (AdvancedControlElement e : repE.getAllGroups().getLast().advancedControls) {
                if (!e.getName().equals(elem.getLocalName())) continue;
                e.addContentToControl(elem.getText().trim());
                found = true;
                break;
            }
            Iterator attrs = elem.getAllAttributes();
            block4: while (attrs.hasNext()) {
                OMAttribute attr = (OMAttribute)attrs.next();
                for (AdvancedControlElement e : repE.getAllGroups().getLast().advancedControls) {
                    if (!e.getName().equals(attr.getLocalName())) continue;
                    e.addContentToControl(attr.getAttributeValue().trim());
                    found = true;
                    continue block4;
                }
            }
            if (--count <= 0) continue;
            repE.addControlsGroup();
        }
        return found;
    }

    @Override
    public void dispose() {
        while (!this.advancedControls.isEmpty()) {
            AdvancedControlElement e = this.advancedControls.getLast();
            e.dispose();
            this.advancedControls.removeLast();
        }
        this.remove_btn.dispose();
    }

    @Override
    public boolean validate() {
        boolean valid = true;
        for (AdvancedControlElement adv : this.getAdvancedControls()) {
            valid &= adv.validate();
        }
        return valid;
    }

    @Override
    public void createOMElement(OMFactory omFactory, OMElement parent, OMNamespace ns, boolean asAttribute) {
        throw new NotImplementedException();
    }

    @Override
    public boolean setOMElement(OMElement root, boolean tg) {
        throw new NotImplementedException();
    }

    @Override
    public String getId() {
        throw new NotImplementedException();
    }

    @Override
    public List<Control> getSWTControls() {
        LinkedList<Control> l = new LinkedList<Control>();
        for (AdvancedControlElement e : this.advancedControls) {
            l.add(e.getSWTControl());
        }
        l.add((Control)this.remove_btn);
        return l;
    }

    @Override
    public IRepresentableComposite getUnit() {
        return this;
    }

    @Override
    public List<IControl> getControls() {
        throw new NotImplementedException();
    }

    @Override
    public void setExpanded(boolean expand) {
        this.parent.setExpanded(expand);
    }

    @Override
    public boolean isExpanded() {
        return this.parent.isExpanded();
    }
}

