/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wadlto;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.CommandInterfaceUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolRunner;
import org.apache.cxf.tools.wadlto.jaxrs.JAXRSContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WADLToJava {
    private String[] args;

    public WADLToJava() {
        this.args = new String[0];
    }

    public WADLToJava(String[] pargs) {
        this.args = pargs;
    }

    private boolean isExitOnFinish() {
        String exit = System.getProperty("exitOnFinish");
        if (StringUtils.isEmpty(exit)) {
            return false;
        }
        return "YES".equalsIgnoreCase(exit) || "TRUE".equalsIgnoreCase(exit);
    }

    public void run(ToolContext context) throws Exception {
        this.run(context, null);
    }

    public void run(ToolContext context, OutputStream os) throws Exception {
        Class<JAXRSContainer> containerClass = JAXRSContainer.class;
        InputStream toolspecStream = WADLToJava.getResourceAsStream(containerClass, "jaxrs-toolspec.xml");
        ToolRunner.runTool(containerClass, toolspecStream, false, this.args, this.isExitOnFinish(), context, os);
    }

    protected boolean isVerbose() {
        return this.isSet(new String[]{"-V", "-verbose"});
    }

    private boolean isSet(String[] keys) {
        if (this.args == null) {
            return false;
        }
        List<String> pargs = Arrays.asList(this.args);
        for (String key : keys) {
            if (!pargs.contains(key)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] pargs) {
        WADLToJava w2j;
        block7: {
            CommandInterfaceUtils.commandCommonMain();
            w2j = new WADLToJava(pargs);
            try {
                w2j.run(new ToolContext());
            }
            catch (ToolException ex) {
                System.err.println();
                System.err.println("WADLToJava Error: " + ex.getMessage());
                System.err.println();
                if (w2j.isVerbose()) {
                    ex.printStackTrace();
                }
                if (w2j.isExitOnFinish()) {
                    System.exit(1);
                }
            }
            catch (Exception ex) {
                System.err.println("WADLToJava Error: " + ex.getMessage());
                System.err.println();
                if (w2j.isVerbose()) {
                    ex.printStackTrace();
                }
                if (!w2j.isExitOnFinish()) break block7;
                System.exit(1);
            }
        }
        if (w2j.isExitOnFinish()) {
            System.exit(0);
        }
    }

    private static InputStream getResourceAsStream(Class<?> clz, String file) {
        return clz.getResourceAsStream(file);
    }
}

