/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.browserfix;

import info.textgrid.lab.core.browserfix.BrowserStatusHandler;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;

public class BrowserFixPlugin
implements IStartup {
    private static final String XULRUNNER_PROPERTY = "org.eclipse.swt.browser.XULRunnerPath";
    private static final String PLUGIN_ID = "info.textgrid.lab.core.browserfix";

    public boolean createMozillaEclipseDirectory() {
        if ("win32".equals(Platform.getOS())) {
            File home;
            File mozilla;
            File eclipse;
            String winAppVar = System.getenv("APPDATA");
            if (winAppVar != null && !(eclipse = new File(mozilla = new File(home = new File(winAppVar), "Mozilla"), "eclipse")).exists()) {
                return eclipse.mkdirs();
            }
        } else if ("macosx".equals(Platform.getOS())) {
            String homeVar = System.getenv("HOME");
            if (homeVar != null) {
                File mozilla;
                File eclipse2;
                File home = new File(homeVar);
                File lib = new File(home, "Library");
                File eclipse1 = new File(lib, "eclipse");
                boolean e1 = true;
                boolean e2 = true;
                if (!eclipse1.exists()) {
                    e1 = eclipse1.mkdirs();
                }
                if (!(eclipse2 = new File(mozilla = new File(lib, "Mozilla"), "eclipse")).exists()) {
                    e2 = eclipse2.mkdirs();
                }
                return e1 && e2;
            }
        } else {
            File home;
            File mozilla;
            File eclipse;
            String homeVar = System.getenv("HOME");
            if (homeVar != null && !(eclipse = new File(mozilla = new File(home = new File(homeVar), ".mozilla"), "eclipse")).exists()) {
                return eclipse.mkdirs();
            }
        }
        return false;
    }

    private static Bundle findBundle(String baseName) {
        StringBuilder bundleName = new StringBuilder(baseName);
        Bundle bundle = Platform.getBundle((String)bundleName.toString());
        if (bundle == null) {
            bundleName.append(".").append(Platform.getWS());
            bundle = Platform.getBundle((String)bundleName.toString());
        }
        if (bundle == null) {
            bundleName.append(".").append(Platform.getOS());
            bundle = Platform.getBundle((String)bundleName.toString());
        }
        if (bundle == null) {
            bundleName.append(".").append(Platform.getOSArch());
            bundle = Platform.getBundle((String)bundleName.toString());
        }
        return bundle;
    }

    public void setXulRunnerPath() {
        Bundle xulRunnerPlugin = BrowserFixPlugin.findBundle("org.mozilla.xulrunner");
        URL rawXulDirURL = null;
        if (xulRunnerPlugin != null) {
            try {
                rawXulDirURL = FileLocator.find((Bundle)xulRunnerPlugin, (IPath)new Path("xulrunner"), null);
                URL resolvedXulURL = FileLocator.resolve((URL)rawXulDirURL);
                if ("file".equals(resolvedXulURL.getProtocol())) {
                    File xulrunner = new File(resolvedXulURL.getPath());
                    String xulRunnerPath = xulrunner.getAbsolutePath();
                    System.setProperty(XULRUNNER_PROPERTY, xulRunnerPath);
                } else {
                    StatusManager.getManager().handle((IStatus)new Status(4, PLUGIN_ID, "The xulrunner is installed under some strange non-file URL: " + resolvedXulURL.toString()));
                }
            }
            catch (IOException e) {
                StatusManager.getManager().handle((IStatus)new Status(2, PLUGIN_ID, "Could not extract xulrunner path.", (Throwable)e));
            }
        }
        String property = System.getProperty(XULRUNNER_PROPERTY);
        StatusManager.getManager().handle((IStatus)new Status(1, PLUGIN_ID, MessageFormat.format("The XULRunnerPath property is now {0} (from XUL dir {1})", property, rawXulDirURL)));
    }

    public void earlyStartup() {
        this.createMozillaEclipseDirectory();
        this.setXulRunnerPath();
        BrowserStatusHandler listener = new BrowserStatusHandler();
        StatusManager.getManager().addListener((StatusManager.INotificationListener)listener);
    }
}

