/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.internal.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.IResolutionErrorReportingPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.SelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.UpdateWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.WizardWithLicenses;
import org.eclipse.equinox.internal.p2.ui.model.AvailableUpdateElement;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.Update;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateWizard
extends WizardWithLicenses {
    IInstallableUnit[] iusToReplace;
    boolean skipSelectionsPage = false;
    IUElementListRoot firstPageRoot;
    Update[] initialSelections;

    public static Collection<IInstallableUnit> getIUsToReplace(Object[] elements) {
        HashSet<IInstallableUnit> iusToReplace = new HashSet<IInstallableUnit>();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof AvailableUpdateElement) {
                iusToReplace.add(((AvailableUpdateElement)elements[i]).getIUToBeUpdated());
            }
            ++i;
        }
        return iusToReplace;
    }

    public static IInstallableUnit[] getReplacementIUs(Object[] elements) {
        HashSet<IInstallableUnit> replacements = new HashSet<IInstallableUnit>();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof AvailableUpdateElement) {
                replacements.add(((AvailableUpdateElement)elements[i]).getIU());
            }
            ++i;
        }
        return replacements.toArray(new IInstallableUnit[replacements.size()]);
    }

    public static Update[] makeUpdatesFromElements(Object[] elements) {
        HashSet<Update> updates = new HashSet<Update>();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof AvailableUpdateElement) {
                updates.add(((AvailableUpdateElement)elements[i]).getUpdate());
            }
            ++i;
        }
        return updates.toArray(new Update[updates.size()]);
    }

    public UpdateWizard(ProvisioningUI ui, UpdateOperation operation, Object[] initialSelections, LoadMetadataRepositoryJob preloadJob) {
        super(ui, (ProfileChangeOperation)operation, initialSelections, preloadJob);
        this.initialSelections = (Update[])initialSelections;
        Assert.isLegal((boolean)operation.hasResolved(), (String)"Cannot create an update wizard on an unresolved operation");
        this.setWindowTitle(ProvUIMessages.UpdateAction_UpdatesAvailableTitle);
        this.setDefaultPageImageDescriptor(ProvUIImages.getImageDescriptor("wizban/update_wiz.gif"));
    }

    private boolean isLocked(IProfile profile, IInstallableUnit iuToBeUpdated) {
        return Boolean.valueOf(profile.getInstallableUnitProperty(iuToBeUpdated, "org.eclipse.equinox.p2.type.lock"));
    }

    public void deselectLockedIUs() {
        IProfileRegistry profileRegistry = (IProfileRegistry)this.ui.getSession().getProvisioningAgent().getService(IProfileRegistry.SERVICE_NAME);
        IProfile profile = profileRegistry.getProfile(this.ui.getProfileId());
        ArrayList<Update> newSelection = new ArrayList<Update>(this.initialSelections.length);
        int i = 0;
        while (i < this.initialSelections.length) {
            if (!this.isLocked(profile, this.initialSelections[i].toUpdate)) {
                newSelection.add(this.initialSelections[i]);
            }
            ++i;
        }
        ((UpdateOperation)this.operation).setSelectedUpdates(newSelection.toArray(new Update[newSelection.size()]));
        this.recomputePlan((IRunnableContext)this.getContainer());
    }

    @Override
    protected ISelectableIUsPage createMainPage(IUElementListRoot input, Object[] selections) {
        this.mainPage = new SelectableIUsPage(this.ui, this, this.getAllPossibleUpdatesRoot(), selections);
        this.mainPage.setTitle(ProvUIMessages.UpdateAction_UpdatesAvailableTitle);
        this.mainPage.setDescription(ProvUIMessages.UpdateAction_UpdatesAvailableMessage);
        ((SelectableIUsPage)this.mainPage).updateStatus(this.getAllPossibleUpdatesRoot(), this.operation);
        return this.mainPage;
    }

    @Override
    protected ResolutionResultsWizardPage createResolutionPage() {
        return new UpdateWizardPage(this.ui, (ProvisioningOperationWizard)this, this.root, (UpdateOperation)this.operation);
    }

    @Override
    protected void initializeResolutionModelElements(Object[] selectedElements) {
        this.root = new IUElementListRoot();
        ArrayList<AvailableUpdateElement> list = new ArrayList<AvailableUpdateElement>(selectedElements.length);
        ArrayList<AvailableUpdateElement> selected = new ArrayList<AvailableUpdateElement>(selectedElements.length);
        int i = 0;
        while (i < selectedElements.length) {
            AvailableUpdateElement newElement;
            if (selectedElements[i] instanceof AvailableUpdateElement) {
                AvailableUpdateElement element = (AvailableUpdateElement)selectedElements[i];
                newElement = new AvailableUpdateElement(this.root, element.getIU(), element.getIUToBeUpdated(), this.getProfileId(), this.shouldShowProvisioningPlanChildren());
                list.add(newElement);
                selected.add(newElement);
            } else if (selectedElements[i] instanceof Update) {
                Update update = (Update)selectedElements[i];
                newElement = new AvailableUpdateElement(this.root, update.replacement, update.toUpdate, this.getProfileId(), this.shouldShowProvisioningPlanChildren());
                list.add(newElement);
                selected.add(newElement);
            }
            ++i;
        }
        this.root.setChildren(list.toArray());
        this.planSelections = selected.toArray();
    }

    @Override
    protected IResolutionErrorReportingPage createErrorReportingPage() {
        return (SelectableIUsPage)this.mainPage;
    }

    public void setSkipSelectionsPage(boolean skipSelectionsPage) {
        this.skipSelectionsPage = skipSelectionsPage;
    }

    public IWizardPage getStartingPage() {
        IWizardPage page;
        if (this.skipSelectionsPage && (page = this.getNextPage(this.mainPage)) != null) {
            return page;
        }
        return this.mainPage;
    }

    @Override
    protected ProfileChangeOperation getProfileChangeOperation(Object[] elements) {
        if (this.operation == null) {
            this.operation = new UpdateOperation(this.ui.getSession(), UpdateWizard.getIUsToReplace(elements));
            this.operation.setProfileId(this.getProfileId());
        } else {
            ((UpdateOperation)this.operation).setSelectedUpdates(UpdateWizard.makeUpdatesFromElements(elements));
        }
        return this.operation;
    }

    private IUElementListRoot getAllPossibleUpdatesRoot() {
        if (this.firstPageRoot == null) {
            this.firstPageRoot = new IUElementListRoot();
            if (this.operation != null && this.operation instanceof UpdateOperation) {
                Update[] updates = this.getPolicy().getShowLatestVersionsOnly() ? ((UpdateOperation)this.operation).getSelectedUpdates() : ((UpdateOperation)this.operation).getPossibleUpdates();
                ArrayList<AvailableUpdateElement> allPossible = new ArrayList<AvailableUpdateElement>(updates.length);
                int i = 0;
                while (i < updates.length) {
                    AvailableUpdateElement newElement = new AvailableUpdateElement(this.firstPageRoot, updates[i].replacement, updates[i].toUpdate, this.getProfileId(), this.shouldShowProvisioningPlanChildren());
                    allPossible.add(newElement);
                    ++i;
                }
                this.firstPageRoot.setChildren(allPossible.toArray());
            }
        }
        return this.firstPageRoot;
    }
}

