/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQueryFunctionLibrary
implements FunctionLibrary,
XQueryFunctionBinder {
    private Configuration config;
    private HashMap<String, XQueryFunction> functions = new HashMap(20);

    public XQueryFunctionLibrary(Configuration config) {
        this.config = config;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void declareFunction(XQueryFunction function) throws XPathException {
        String keyObj = function.getIdentificationKey();
        XQueryFunction existing = this.functions.get(keyObj);
        if (existing != null) {
            XPathException err = new XPathException("Duplicate definition of function " + function.getDisplayName() + " (see line " + existing.getLineNumber() + " in " + existing.getSystemId() + ')');
            err.setErrorCode("XQST0034");
            err.setIsStaticError(true);
            err.setLocator(function);
            throw err;
        }
        this.functions.put(keyObj, function);
    }

    @Override
    public SequenceType[] getFunctionSignature(StructuredQName functionName, int arity) {
        if (arity == -1) {
            for (int i = 0; i < 20; ++i) {
                SequenceType[] sig = this.getFunctionSignature(functionName, i);
                if (sig == null) continue;
                return sig;
            }
            return null;
        }
        XQueryFunction fn = this.functions.get(XQueryFunction.getIdentificationKey(functionName, arity));
        if (fn != null) {
            SequenceType[] sig = new SequenceType[arity + 1];
            sig[0] = fn.getResultType();
            System.arraycopy(fn.getArgumentTypes(), 0, sig, 1, arity);
            return sig;
        }
        return null;
    }

    @Override
    public Expression bind(StructuredQName functionName, Expression[] arguments, StaticContext env, Container container) throws XPathException {
        String functionKey = XQueryFunction.getIdentificationKey(functionName, arguments.length);
        XQueryFunction fd = this.functions.get(functionKey);
        if (fd != null) {
            if (fd.isPrivate() && fd.getStaticContext() != env) {
                throw new XPathException("Cannot call the private function " + functionName.getDisplayName() + " from outside its module", "XPST0017");
            }
            UserFunctionCall ufc = new UserFunctionCall();
            ufc.setFunctionName(fd.getFunctionName());
            ufc.setArguments(arguments);
            ufc.setStaticType(fd.getResultType());
            UserFunction fn = fd.getUserFunction();
            if (fn == null) {
                fd.registerReference(ufc);
            } else {
                ufc.setFunction(fn);
                ExpressionVisitor visitor = ExpressionVisitor.make(fd.getStaticContext(), fd.getExecutable());
                ufc.checkFunctionCall(fn, visitor);
            }
            return ufc;
        }
        return null;
    }

    @Override
    public XQueryFunction getDeclaration(StructuredQName functionName, Expression[] staticArgs) {
        String functionKey = XQueryFunction.getIdentificationKey(functionName, staticArgs.length);
        return this.functions.get(functionKey);
    }

    public XQueryFunction getDeclarationByKey(String functionKey) {
        return this.functions.get(functionKey);
    }

    public Iterator<XQueryFunction> getFunctionDefinitions() {
        return this.functions.values().iterator();
    }

    protected void fixupGlobalFunctions(QueryModule env) throws XPathException {
        ExpressionVisitor visitor = ExpressionVisitor.make(env, env.getExecutable());
        for (XQueryFunction fn : this.functions.values()) {
            fn.compile();
        }
        for (XQueryFunction fn : this.functions.values()) {
            visitor.setExecutable(fn.getExecutable());
            fn.checkReferences(visitor);
        }
    }

    protected void optimizeGlobalFunctions() throws XPathException {
        for (XQueryFunction fn : this.functions.values()) {
            fn.optimize();
        }
    }

    public void explainGlobalFunctions(ExpressionPresenter out) {
        for (XQueryFunction fn : this.functions.values()) {
            fn.explain(out);
        }
    }

    public UserFunction getUserDefinedFunction(String uri, String localName, int arity) {
        String functionKey = XQueryFunction.getIdentificationKey(uri, localName, arity);
        XQueryFunction fd = this.functions.get(functionKey);
        if (fd == null) {
            return null;
        }
        return fd.getUserFunction();
    }

    @Override
    public FunctionLibrary copy() {
        XQueryFunctionLibrary qfl = new XQueryFunctionLibrary(this.config);
        qfl.functions = new HashMap<String, XQueryFunction>(this.functions);
        return qfl;
    }
}

