/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.dialogs;

import info.textgrid.lab.core.browserfix.TextGridLabBrowser;
import info.textgrid.lab.core.metadataeditor.MetaDataSection;
import info.textgrid.lab.core.metadataeditor.ScrolledPageArea;
import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.utils.ProjectCombo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

@Deprecated
public class ImportWizard
extends Wizard {
    private static final String META_SUFFIX = ".meta";
    private static final String fgStyleSheet = "/* Font definitions */\nbody, h1, h2, h3, h4, h5, h6, p, table, td, caption, th, ul, ol, dl, li, dd, dt {font-family: sans-serif; font-size: 9pt }\npre\t\t\t\t{ font-family: monospace; font-size: 9pt }\n\n/* Margins */\nbody\t     { overflow: auto; margin-top: 0; margin-bottom: 4; margin-left: 3; margin-right: 0 }\nh1           { margin-top: 5; margin-bottom: 1 }\t\nh2           { margin-top: 25; margin-bottom: 3 }\nh3           { margin-top: 20; margin-bottom: 3 }\nh4           { margin-top: 20; margin-bottom: 3 }\nh5           { margin-top: 0; margin-bottom: 0 }\np            { margin-top: 10px; margin-bottom: 10px }\npre\t         { margin-left: 6 }\nul\t         { margin-top: 0; margin-bottom: 10 }\nli\t         { margin-top: 0; margin-bottom: 0 } \nli p\t     { margin-top: 0; margin-bottom: 0 } \nol\t         { margin-top: 0; margin-bottom: 10 }\ndl\t         { margin-top: 0; margin-bottom: 10 }\ndt\t         { margin-top: 0; margin-bottom: 0; font-weight: bold }\ndd\t         { margin-top: 0; margin-bottom: 0 }\n\n/* Styles and colors */\na:link\t     { color: #0000FF }\na:hover\t     { color: #000080 }\na:visited    { text-decoration: underline }\nh4           { font-style: italic }\nstrong\t     { font-weight: bold }\nem\t         { font-style: italic }\nvar\t         { font-style: italic }\nth\t         { font-weight: bold }\n";
    protected String introHtml = "<html><head><title>Importing Files</title><style type=\"text/css\">/* Font definitions */\nbody, h1, h2, h3, h4, h5, h6, p, table, td, caption, th, ul, ol, dl, li, dd, dt {font-family: sans-serif; font-size: 9pt }\npre\t\t\t\t{ font-family: monospace; font-size: 9pt }\n\n/* Margins */\nbody\t     { overflow: auto; margin-top: 0; margin-bottom: 4; margin-left: 3; margin-right: 0 }\nh1           { margin-top: 5; margin-bottom: 1 }\t\nh2           { margin-top: 25; margin-bottom: 3 }\nh3           { margin-top: 20; margin-bottom: 3 }\nh4           { margin-top: 20; margin-bottom: 3 }\nh5           { margin-top: 0; margin-bottom: 0 }\np            { margin-top: 10px; margin-bottom: 10px }\npre\t         { margin-left: 6 }\nul\t         { margin-top: 0; margin-bottom: 10 }\nli\t         { margin-top: 0; margin-bottom: 0 } \nli p\t     { margin-top: 0; margin-bottom: 0 } \nol\t         { margin-top: 0; margin-bottom: 10 }\ndl\t         { margin-top: 0; margin-bottom: 10 }\ndt\t         { margin-top: 0; margin-bottom: 0; font-weight: bold }\ndd\t         { margin-top: 0; margin-bottom: 0 }\n\n/* Styles and colors */\na:link\t     { color: #0000FF }\na:hover\t     { color: #000080 }\na:visited    { text-decoration: underline }\nh4           { font-style: italic }\nstrong\t     { font-weight: bold }\nem\t         { font-style: italic }\nvar\t         { font-style: italic }\nth\t         { font-weight: bold }\n</style></head><body><p>This wizard is intended to import a small set of files from your local filesystem to a single project in the TextGrid repository. To import,</p><ol><li>select the files to import using the Add button</li><li>select the target project below</li><li>on the next page, enter the neccessary metadata for each file</li><li>click <em>Finish</em> to actually perform the insert.</li></ol><p>To import larger sets of data, please <a href=\"mailto:info@textgrid.de\">contact the TextGrid team</a>.";
    SortedSet<File> fileSet = new TreeSet<File>();
    Map<File, TextGridObject> objectMap = new HashMap<File, TextGridObject>();
    TextGridProject project = null;
    private boolean useMetaFiles = true;
    private SelectImportFilesPage filesPage;
    private EnterMetadataPage metadataPage;

    public ImportWizard(ISelection currentSelection) {
        if (currentSelection instanceof IStructuredSelection) {
            TextGridObject object;
            Object selected = ((IStructuredSelection)currentSelection).getFirstElement();
            TextGridProject project = (TextGridProject)AdapterUtils.getAdapter((Object)selected, TextGridProject.class);
            if (project == null && (object = (TextGridObject)AdapterUtils.getAdapter((Object)selected, TextGridObject.class)) != null) {
                try {
                    project = object.getProjectInstance();
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "info.textgrid.lab.ui.core");
                }
            }
            this.project = project;
        }
    }

    public void addPages() {
        super.addPages();
        this.filesPage = new SelectImportFilesPage("selectImportFiles");
        this.metadataPage = new EnterMetadataPage("enterMetadata");
        this.addPage((IWizardPage)this.filesPage);
        this.addPage((IWizardPage)this.metadataPage);
        this.setWindowTitle("Import files to the TextGridRep");
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        if (this.metadataPage == null) {
            return false;
        }
        IRunnableWithProgress importRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(ImportWizard.this.fileSet.size() * 100));
                LinkedList<Object> failures = new LinkedList<Object>();
                for (File localFile : ImportWizard.this.fileSet) {
                    if (progress.isCanceled()) {
                        throw new InterruptedException();
                    }
                    progress.subTask(NLS.bind((String)"Importing {0} ...", (Object)localFile));
                    TextGridObject object = ImportWizard.this.objectMap.get(localFile);
                    if (object == null || !object.isSubmittable()) {
                        failures.add(new Status(2, "info.textgrid.lab.ui.core", NLS.bind((String)"Skipped {0} due to incomplete metadata.", (Object)localFile)));
                        continue;
                    }
                    IFile gridFile = (IFile)AdapterUtils.getAdapter((Object)object, IFile.class);
                    try {
                        gridFile.setContents((InputStream)new FileInputStream(localFile), 1, (IProgressMonitor)progress.newChild(100));
                    }
                    catch (FileNotFoundException e) {
                        failures.add(new Status(4, "info.textgrid.lab.ui.core", NLS.bind((String)"Local file {0} was not found.", (Object)localFile), (Throwable)e));
                    }
                    catch (CoreException e) {
                        failures.add(new MultiStatus("info.textgrid.lab.ui.core", 0, new IStatus[]{e.getStatus()}, NLS.bind((String)"Failed to import {0}: {1}", (Object)localFile, (Object)e.getLocalizedMessage()), (Throwable)e));
                    }
                }
                if (!failures.isEmpty()) {
                    MultiStatus result = new MultiStatus("info.textgrid.lab.ui.core", 0, failures.toArray(new IStatus[0]), NLS.bind((String)"{0} of {1} files could not be imported. See the details for the individual reasons.", (Object)failures.size(), (Object)ImportWizard.this.fileSet.size()), null);
                    Activator.getDefault().getLog().log((IStatus)result);
                    throw new InvocationTargetException(new CoreException((IStatus)result));
                }
            }
        };
        try {
            this.getContainer().run(true, true, importRunnable);
            return true;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"Some files could not be imported.", null, (IStatus)((CoreException)e.getCause()).getStatus());
                return true;
            }
            Activator.handleError(e.getCause(), "An {0} occurred while importing files to the TextGridRep: {1}.\nThis comes somewhat unexpected, please file a bug report.", e.getCause(), e.getLocalizedMessage());
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    private TextGridObject prepareObject(File file) {
        String fileName = file.getName();
        int i = fileName.lastIndexOf(46);
        TGContentType contentType = null;
        if (i != -1) {
            contentType = TGContentType.findByExtension((String)fileName.substring(i + 1));
        }
        if (contentType == null) {
            contentType = TGContentType.findMatchingContentType((String)fileName.substring(i + 1));
        }
        if (contentType == null) {
            contentType = TGContentType.getContentType((String)"unknown/unknown");
        }
        TextGridObject object = TextGridObject.getNewObjectInstance((TextGridProject)this.project, (TGContentType)contentType);
        if (this.useMetaFiles) {
            File metaFile = new File(file.getParent(), String.valueOf(file.getName()) + META_SUFFIX);
            if (!metaFile.canRead()) {
                metaFile = new File(file.getParent(), "." + file.getName() + META_SUFFIX);
            }
            if (metaFile.canRead()) {
                try {
                    object.loadMetadata((InputStream)new FileInputStream(metaFile));
                    this.objectMap.put(file, object);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        return object;
    }

    public static void showWizard(Shell activeShell, ISelection currentSelection) {
        WizardDialog dialog = new WizardDialog(activeShell, (IWizard)new ImportWizard(currentSelection));
        dialog.open();
    }

    public class EnterMetadataPage
    extends WizardPage {
        private Composite mdPageComposite;
        private TableViewer filesViewer;
        private MetaDataSection metaDataSection;
        private Group metadataGroup;
        private Group fileViewerGroup;
        private ComboViewer contentTypeViewer;
        private ScrolledPageArea mdPageArea;
        private ScrolledForm mdPageScrolledForm;
        private File file;
        private TextGridObject object;
        private FocusAdapter focusListener;
        private KeyAdapter keyListener;
        private TableViewerColumn viewerColumn;

        public void validatePage() {
            StringBuilder message = new StringBuilder();
            int type = 0;
            if (this.file != null && this.object != null) {
                try {
                    TGContentType contentType = (TGContentType)AdapterUtils.getAdapter((Object)((IStructuredSelection)this.contentTypeViewer.getSelection()).getFirstElement(), TGContentType.class);
                    if (contentType != null && contentType != this.object.getContentType(true)) {
                        this.object.setContentType(contentType);
                    }
                    this.metaDataSection.updateTextGridObject();
                }
                catch (CoreException e) {
                    Activator.handleError(e, "An error occured while updating the metadata for {0}: {1}", this.object, e.getStatus());
                }
                if (this.object.isSubmittable()) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                } else {
                    message.append(NLS.bind((String)"You need to complete {0}'s metadata before it can be imported. ", (Object)this.file));
                    type = 3;
                }
                this.filesViewer.refresh((Object)this.file);
            }
            int checked = this.getSubmittedObjects();
            int all = this.filesViewer.getTable().getItemCount();
            if (checked == 0) {
                type = 3;
                message.append("No files have valid metadata.");
                this.setPageComplete(false);
            } else if (checked < all) {
                if (type != 3) {
                    type = 2;
                }
                message.append("If you click finish now, only those files that have complete metadata (checked) will be imported. ");
            } else {
                type = 1;
                message.append(NLS.bind((String)"Click Finish to import the files into the project {0} ", (Object)ImportWizard.this.project));
                this.setPageComplete(true);
            }
            if (type == 3) {
                this.setErrorMessage(message.toString());
            } else {
                this.setMessage(message.toString(), type);
                this.setErrorMessage(null);
            }
        }

        protected EnterMetadataPage(String pageName) {
            super(pageName);
            this.mdPageArea = null;
            this.mdPageScrolledForm = null;
            this.file = null;
        }

        protected void addGlobalListeners(Control target, FocusListener focusListener, KeyListener keyListener) {
            target.addFocusListener(focusListener);
            target.addKeyListener(keyListener);
            if (target instanceof Composite) {
                Composite composite = (Composite)target;
                Control[] controlArray = composite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    this.addGlobalListeners(child, focusListener, keyListener);
                    ++n2;
                }
            }
        }

        public void createControl(Composite parent) {
            this.mdPageArea = new ScrolledPageArea(parent);
            this.mdPageComposite = this.mdPageArea.getPageAreaComposite();
            this.mdPageScrolledForm = this.mdPageArea.getPageAreaScrolledForm();
            this.setControl((Control)this.mdPageComposite);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.mdPageComposite);
            this.fileViewerGroup = new Group(this.mdPageComposite, 0);
            this.fileViewerGroup.setLayoutData((Object)new GridData(0, 4, false, false));
            this.fileViewerGroup.setLayout((Layout)new GridLayout(1, false));
            this.fileViewerGroup.setText("Metadata complete");
            final Table filesTable = new Table((Composite)this.fileViewerGroup, 776);
            this.filesViewer = new TableViewer(filesTable);
            this.filesViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.viewerColumn = new TableViewerColumn(this.filesViewer, 0);
            this.viewerColumn.getColumn().setWidth(400);
            GridData data = GridDataFactory.fillDefaults().grab(false, true).create();
            this.filesViewer.getControl().setLayoutData((Object)data);
            FileListListener fileListListener = new FileListListener();
            this.filesViewer.addSelectionChangedListener((ISelectionChangedListener)fileListListener);
            this.filesViewer.setLabelProvider((IBaseLabelProvider)new ImportLabelProvider());
            this.filesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.filesViewer.setInput((Object)ImportWizard.this.fileSet.toArray());
            this.metadataGroup = new Group(this.mdPageComposite, 0);
            this.metadataGroup.setText("Metadata for the selected file");
            GridLayoutFactory.fillDefaults().applyTo((Composite)this.metadataGroup);
            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.metadataGroup);
            Composite contentTypeArea = new Composite((Composite)this.metadataGroup, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(contentTypeArea);
            Label contentTypeLabel = new Label(contentTypeArea, 0);
            contentTypeLabel.setText("Content Type:");
            this.contentTypeViewer = new ComboViewer(contentTypeArea, 8);
            this.contentTypeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    if (element instanceof TGContentType) {
                        TGContentType contentType = (TGContentType)element;
                        return contentType.getImage(false);
                    }
                    return super.getImage(element);
                }
            });
            this.contentTypeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.contentTypeViewer.setInput((Object)TGContentType.getContentTypes((boolean)true));
            this.metaDataSection = new MetaDataSection((Composite)this.metadataGroup, this.mdPageScrolledForm, null);
            this.focusListener = new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    EnterMetadataPage.this.validatePage();
                }
            };
            this.keyListener = new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    int selectionIndex = filesTable.getSelectionIndex();
                    if (e.keyCode == 0x1000005) {
                        if (selectionIndex > 0) {
                            EnterMetadataPage.this.filesViewer.setSelection((ISelection)new StructuredSelection(EnterMetadataPage.this.filesViewer.getElementAt(selectionIndex - 1)));
                            e.doit = false;
                        }
                    } else if (e.keyCode == 0x1000006 && selectionIndex < filesTable.getSelectionCount()) {
                        EnterMetadataPage.this.filesViewer.setSelection((ISelection)new StructuredSelection(EnterMetadataPage.this.filesViewer.getElementAt(selectionIndex + 1)));
                        e.doit = false;
                    }
                }
            };
            this.addGlobalListeners((Control)this.mdPageComposite, (FocusListener)this.focusListener, (KeyListener)this.keyListener);
            this.validatePage();
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.filesViewer.setInput((Object)ImportWizard.this.fileSet.toArray());
                this.setTitle("Metadata");
                this.setMessage("Please enter the metadata for each file to import.");
                super.setVisible(visible);
                this.prepareMetadata();
                if (this.filesViewer.getSelection().isEmpty() && !ImportWizard.this.fileSet.isEmpty()) {
                    this.filesViewer.setSelection((ISelection)new StructuredSelection((Object)ImportWizard.this.fileSet.first()));
                }
            }
        }

        private void prepareMetadata() {
            try {
                this.getContainer().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Preparing metadata", (int)(10 * ((EnterMetadataPage)EnterMetadataPage.this).ImportWizard.this.fileSet.size()));
                        for (File file : ((EnterMetadataPage)EnterMetadataPage.this).ImportWizard.this.fileSet) {
                            if (!((EnterMetadataPage)EnterMetadataPage.this).ImportWizard.this.objectMap.containsKey(file)) {
                                TextGridObject object = ImportWizard.this.prepareObject(file);
                                ((EnterMetadataPage)EnterMetadataPage.this).ImportWizard.this.objectMap.put(file, object);
                                UIJob validateJob = new UIJob("Setting checked status"){

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        EnterMetadataPage.this.filesViewer.refresh();
                                        return Status.OK_STATUS;
                                    }
                                };
                                validateJob.setSystem(true);
                                validateJob.schedule();
                            }
                            progress.worked(10);
                        }
                        new UIJob("Validating Page"){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                EnterMetadataPage.this.validatePage();
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                });
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public int getSubmittedObjects() {
            int counter = 0;
            for (Map.Entry<File, TextGridObject> e : ImportWizard.this.objectMap.entrySet()) {
                if (!e.getValue().isSubmittable()) continue;
                ++counter;
            }
            return counter;
        }

        protected class FileListListener
        implements ISelectionChangedListener,
        ICheckStateListener {
            protected FileListListener() {
            }

            public void selectionChanged(SelectionChangedEvent event) {
                File newFile = (File)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (newFile != EnterMetadataPage.this.file && EnterMetadataPage.this.object != null) {
                    EnterMetadataPage.this.metaDataSection.updateTextGridObject();
                }
                EnterMetadataPage.this.file = newFile;
                if (EnterMetadataPage.this.file != null) {
                    EnterMetadataPage.this.object = ((EnterMetadataPage)EnterMetadataPage.this).ImportWizard.this.objectMap.get(EnterMetadataPage.this.file);
                    if (EnterMetadataPage.this.object == null) {
                        EnterMetadataPage.this.object = ImportWizard.this.prepareObject(EnterMetadataPage.this.file);
                        ((EnterMetadataPage)EnterMetadataPage.this).ImportWizard.this.objectMap.put(EnterMetadataPage.this.file, EnterMetadataPage.this.object);
                    }
                    try {
                        TGContentType contentType = EnterMetadataPage.this.object.getContentType(false);
                        if (contentType != null) {
                            EnterMetadataPage.this.contentTypeViewer.setSelection((ISelection)new StructuredSelection((Object)contentType), true);
                        }
                        EnterMetadataPage.this.metaDataSection.setNewTGObject(EnterMetadataPage.this.object, !EnterMetadataPage.this.metaDataSection.isProjectFileLoaded());
                        EnterMetadataPage.this.metadataGroup.setText(NLS.bind((String)"Metadata for {0}", (Object)EnterMetadataPage.this.file));
                        EnterMetadataPage.this.addGlobalListeners((Control)EnterMetadataPage.this.metadataGroup, (FocusListener)EnterMetadataPage.this.focusListener, (KeyListener)EnterMetadataPage.this.keyListener);
                    }
                    catch (CoreException e) {
                        Activator.handleProblem(2, "Could not initialize object. This is probably a bug.", e);
                    }
                }
            }

            public void checkStateChanged(CheckStateChangedEvent event) {
                TextGridObject textGridObject = ((EnterMetadataPage)EnterMetadataPage.this).ImportWizard.this.objectMap.get(event.getElement());
                if (textGridObject == null) {
                    return;
                }
                if (textGridObject.isSubmittable() != event.getChecked()) {
                    ICheckable checkable = event.getCheckable();
                    if (checkable == null) {
                        return;
                    }
                    checkable.setChecked(event.getElement(), !event.getChecked());
                    EnterMetadataPage.this.filesViewer.refresh(event.getElement());
                }
            }
        }

        public class ImportLabelProvider
        extends LabelProvider
        implements ILightweightLabelDecorator {
            public void decorate(Object element, IDecoration decoration) {
                TextGridObject object;
                if (element instanceof File && (object = ((EnterMetadataPage)EnterMetadataPage.this).ImportWizard.this.objectMap.get(element)) != null && !object.isSubmittable()) {
                    decoration.addSuffix("incomplete");
                }
            }

            public Image getImage(Object element) {
                TextGridObject tgo = ((EnterMetadataPage)EnterMetadataPage.this).ImportWizard.this.objectMap.get(element);
                if (tgo == null) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                }
                if (tgo.isSubmittable()) {
                    Activator plugin = Activator.getDefault();
                    ImageRegistry imageRegistry = plugin.getImageRegistry();
                    return imageRegistry.get("complete");
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
        }
    }

    public class SelectImportFilesPage
    extends WizardPage {
        private Composite dialogArea;
        private ListViewer fileListViewer;
        private Button removeButton;
        private Button addButton;
        private ProjectCombo projectViewer;
        private Button useMetaFilesButton;

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.setTitle("Select files");
            this.setMessage("Select some local files to import and the target project.");
        }

        protected SelectImportFilesPage(String pageName) {
            super(pageName);
        }

        public void createControl(Composite parent) {
            this.dialogArea = new Composite(parent, 0);
            this.setControl((Control)this.dialogArea);
            GridLayoutFactory.fillDefaults().applyTo(this.dialogArea);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.dialogArea);
            this.createIntroduction();
            this.createFileList();
            this.createMetadataButton();
            this.createTargetProjectGroup();
            this.validatePage();
        }

        private void createIntroduction() {
            Browser intro = TextGridLabBrowser.createBrowser((Composite)this.dialogArea);
            intro.setText(ImportWizard.this.introHtml);
            GridDataFactory.fillDefaults().grab(true, false).hint(300, 150).applyTo((Control)intro);
            intro.pack();
        }

        private void createFileList() {
            Composite listButtons = new Composite(this.dialogArea, 0);
            this.addButton = new Button(listButtons, 8);
            this.addButton.setText("&Add files to import ...");
            this.removeButton = new Button(listButtons, 8);
            this.removeButton.setText("&Remove from file list");
            GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(listButtons);
            this.fileListViewer = new ListViewer(this.dialogArea, 770);
            GridDataFactory.fillDefaults().grab(true, true).applyTo(this.fileListViewer.getControl());
            this.fileListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.fileListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog fileDialog = new FileDialog(SelectImportFilesPage.this.getShell(), 4098);
                    fileDialog.setText("Import Files");
                    if (fileDialog.open() != null) {
                        File dir = new File(fileDialog.getFilterPath()).getAbsoluteFile();
                        String[] stringArray = fileDialog.getFileNames();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String fileName = stringArray[n2];
                            File file = new File(dir, fileName);
                            ((SelectImportFilesPage)SelectImportFilesPage.this).ImportWizard.this.fileSet.add(file);
                            ++n2;
                        }
                    }
                    SelectImportFilesPage.this.fileListViewer.setInput((Object)((SelectImportFilesPage)SelectImportFilesPage.this).ImportWizard.this.fileSet.toArray());
                    SelectImportFilesPage.this.validatePage();
                }
            });
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)SelectImportFilesPage.this.fileListViewer.getSelection();
                    for (File file : selection) {
                        ((SelectImportFilesPage)SelectImportFilesPage.this).ImportWizard.this.fileSet.remove(file);
                    }
                    SelectImportFilesPage.this.fileListViewer.setInput((Object)((SelectImportFilesPage)SelectImportFilesPage.this).ImportWizard.this.fileSet.toArray());
                    SelectImportFilesPage.this.validatePage();
                }
            });
            this.fileListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SelectImportFilesPage.this.removeButton.setEnabled(!event.getSelection().isEmpty());
                    SelectImportFilesPage.this.validatePage();
                }
            });
        }

        private void createMetadataButton() {
            this.useMetaFilesButton = new Button(this.dialogArea, 32);
            this.useMetaFilesButton.setLayoutData((Object)new GridData(4, 4, true, false));
            this.useMetaFilesButton.setText("Read .meta files for &metadata if available");
            this.useMetaFilesButton.setToolTipText("If checked, the import wizard will load descriptive metadata from a file named foo.meta or .foo.meta for each file foo, if such a file exists. The file must conform to the TextGrid metadata schema.");
            this.useMetaFilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ImportWizard.this.useMetaFiles = SelectImportFilesPage.this.useMetaFilesButton.getSelection();
                }
            });
            this.useMetaFilesButton.setSelection(true);
        }

        private void createTargetProjectGroup() {
            new Label(this.dialogArea, 0).setText("Target &project:");
            this.projectViewer = new ProjectCombo(this.dialogArea, TextGridProjectRoot.LEVELS.EDITOR);
            this.projectViewer.setProject(ImportWizard.this.project);
            GridDataFactory.fillDefaults().grab(true, false).applyTo(this.projectViewer.getControl());
            this.projectViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ((SelectImportFilesPage)SelectImportFilesPage.this).ImportWizard.this.project = (TextGridProject)((IStructuredSelection)event.getSelection()).getFirstElement();
                    SelectImportFilesPage.this.validatePage();
                }
            });
        }

        protected void validatePage() {
            StringBuilder error = new StringBuilder();
            boolean complete = true;
            if (this.fileListViewer.getList().getItemCount() < 1) {
                error.append("Use the Add button to select some files to import. ");
                this.removeButton.setEnabled(false);
                complete = false;
            }
            if (ImportWizard.this.project == null) {
                error.append("Select a project to import your files into. ");
                complete = false;
            }
            if (error.length() > 0) {
                this.setErrorMessage(error.toString());
            } else {
                this.setErrorMessage(null);
            }
            this.setPageComplete(complete);
        }
    }
}

