/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.dialogs;

import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.dialogs.INewObjectPreparator;
import info.textgrid.lab.ui.core.dialogs.ITextGridWizard;
import info.textgrid.lab.ui.core.dialogs.ITextGridWizardPage;
import info.textgrid.lab.ui.core.dialogs.Messages;
import info.textgrid.lab.ui.core.dialogs.MetadataPage;
import info.textgrid.lab.ui.core.dialogs.NewTGOPage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class NewObjectWizard
extends Wizard
implements ITextGridWizard,
IPageChangingListener {
    private TextGridProject currentProject = null;
    private TGContentType currentContentType = null;
    private TextGridObject textGridObject = null;
    private NewTGOPage newTGOPage;
    private MetadataPage metadataPage;
    private WizardDialog dialog;
    private TypeSpecificAspects typeSpecificAspects = null;

    public void addPages() {
        super.addPages();
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.NewObjectWizard_WindowTitle);
        this.newTGOPage = new NewTGOPage(this.currentProject, this.currentContentType);
        this.newTGOPage.init(this, null);
        this.addPage(this.newTGOPage);
        this.metadataPage = new MetadataPage(Messages.NewObjectWizard_PageTitle);
        this.metadataPage.init(this, null);
        this.addPage(this.metadataPage);
        IWizardContainer container = this.getContainer();
        if (container instanceof WizardDialog) {
            this.dialog = (WizardDialog)container;
            this.dialog.addPageChangingListener((IPageChangingListener)this);
        }
    }

    public boolean defaultPerformFinish() {
        return this.defaultPerformFinish("info.textgrid.lab.welcome.XMLEditorPerspective");
    }

    public boolean defaultPerformFinish(String perspectiveID) {
        block9: {
            if (this.getTextGridObject() == null) {
                return false;
            }
            IFile file = (IFile)this.getTextGridObject().getAdapter(IFile.class);
            try {
                if (file != null) {
                    IDocumentProvider documentProvider;
                    IDocument document;
                    FileEditorInput input;
                    IContentDescription contentDescription;
                    IContentType eclipseContentType = this.getTextGridObject().getContentType(false).getEclipseContentType();
                    IEditorDescriptor editor = null;
                    IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
                    if (eclipseContentType != null) {
                        editor = editorRegistry.getDefaultEditor(file.getName(), eclipseContentType);
                    }
                    if (editor == null && (contentDescription = file.getContentDescription()) != null) {
                        editor = editorRegistry.getDefaultEditor(file.getName(), contentDescription.getContentType());
                    }
                    if (editor == null) break block9;
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorPart editorPart = page.openEditor((IEditorInput)(input = new FileEditorInput(file)), editor.getId());
                    ITextEditor textEditor = (ITextEditor)AdapterUtils.getAdapter((Object)editorPart, ITextEditor.class);
                    if (textEditor != null && (document = (documentProvider = textEditor.getDocumentProvider()).getDocument((Object)input)) != null) {
                        try {
                            document.replace(0, 0, "");
                        }
                        catch (BadLocationException e) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.ui.core", NLS.bind((String)"Could not mark the document {0} as modified", (Object)input), (Throwable)e));
                        }
                    }
                    PlatformUI.getWorkbench().showPerspective(perspectiveID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                    return true;
                }
                return false;
            }
            catch (CoreException e) {
                Activator.handleError(e, Messages.NewObjectWizard_EM_CouldNotFindEditor, this.textGridObject);
                return false;
            }
        }
        return false;
    }

    public void setProject(TextGridProject project) {
        this.currentProject = project;
    }

    public void setContentType(TGContentType contentType) {
        this.currentContentType = contentType;
    }

    @Override
    public boolean setTextGridObject(TextGridObject textGridObject) {
        TextGridObject oldTextGridObject = this.textGridObject;
        this.textGridObject = textGridObject;
        if (textGridObject != oldTextGridObject) {
            this.metadataPage.loadObject(textGridObject);
        }
        return true;
    }

    @Override
    public TextGridObject getTextGridObject() {
        return this.textGridObject;
    }

    public void showDialog(Shell activeShell, TextGridProject project, TGContentType contentType) {
        this.setProject(project);
        this.setContentType(contentType);
        WizardDialog dialog = new WizardDialog(activeShell, (IWizard)this);
        dialog.setTitle(Messages.NewObjectWizard_DialogTitle);
        dialog.setBlockOnOpen(false);
        dialog.open();
    }

    public void handlePageChanging(PageChangingEvent event) {
        if (event.getTargetPage() == this.getNextPage((IWizardPage)event.getCurrentPage())) {
            ((ITextGridWizardPage)event.getCurrentPage()).finishPage();
        }
        if (event.getCurrentPage() == this.newTGOPage && this.typeSpecificAspects == null) {
            this.initTypeSpecificAspects();
        }
    }

    protected void initTypeSpecificAspects() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("info.textgrid.lab.ui.core.newObjectContributor");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (this.newTGOPage.getContentType().getId().equals(element.getAttribute("contentType"))) {
                this.typeSpecificAspects = new TypeSpecificAspects(element);
                break;
            }
            ++n2;
        }
    }

    public boolean performFinish() {
        ((ITextGridWizardPage)this.getContainer().getCurrentPage()).finishPage();
        try {
            if (this.textGridObject != null && "text/tg.work+xml".equals(this.textGridObject.getContentTypeID())) {
                if (this.textGridObject.getMetadata().getWork() == null) {
                    this.textGridObject.setWorkMetadata(null);
                }
                IFile file = (IFile)this.getTextGridObject().getAdapter(IFile.class);
                file.setContents((InputStream)new ByteArrayInputStream("work-object".getBytes("UTF-8")), 1, null);
            }
            if (this.typeSpecificAspects == null) {
                this.initTypeSpecificAspects();
            }
            if (this.typeSpecificAspects != null && this.typeSpecificAspects.getPreparator() != null) {
                return this.typeSpecificAspects.getPreparator().performFinish(this.textGridObject);
            }
            return this.defaultPerformFinish();
        }
        catch (CoreException e1) {
            Activator.handleError(e1, Messages.NewObjectWizard_EM_CouldNotMakePersistent, new Object[0]);
        }
        catch (UnsupportedEncodingException e) {
            Activator.handleError(e, Messages.NewObjectWizard_EM_CouldNotMakePersistent, new Object[0]);
        }
        return false;
    }

    public TypeSpecificAspects getTypeSpecificAspects() {
        if (this.typeSpecificAspects == null) {
            this.initTypeSpecificAspects();
        }
        return this.typeSpecificAspects;
    }

    public boolean canFinish() {
        TGContentType contentType;
        if (this.getContainer().getCurrentPage() == this.newTGOPage && this.typeSpecificAspects == null && (contentType = this.newTGOPage.getContentType()) != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("info.textgrid.lab.ui.core.newObjectContributor");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getAttribute("contentType").equals(contentType.getId()) && "false".equalsIgnoreCase(element.getAttribute("allowFastFinish"))) {
                    return false;
                }
                ++n2;
            }
        }
        return super.canFinish();
    }

    class TypeSpecificAspects {
        private boolean showMetadataPage;
        private boolean needsValidMetadata;
        private INewObjectPreparator preparator;
        private List<PageDescriptor> pageDescriptors;
        private TGContentType contentType;
        private IContributor contributor;

        public String toString() {
            return MessageFormat.format("TypeSpecificAspects for {0} from {3}: {1}, {2}", this.getContentType(), this.getPreparator(), this.pageDescriptors, this.contributor);
        }

        public TypeSpecificAspects(IConfigurationElement configurationElement) {
            block5: {
                this.pageDescriptors = new ArrayList<PageDescriptor>();
                try {
                    IConfigurationElement[] pageElements;
                    this.setContentType(TGContentType.getContentType((String)configurationElement.getAttribute("contentType")));
                    this.setShowMetadataPage(!"false".equals(configurationElement.getAttribute("showMetadataPage")));
                    this.setNeedsValidMetadata("true".equals(configurationElement.getAttribute("needsValidMetadata")));
                    this.setPreparator((INewObjectPreparator)configurationElement.createExecutableExtension("preparator"));
                    this.getPreparator().setWizard(NewObjectWizard.this);
                    this.contributor = configurationElement.getContributor();
                    IConfigurationElement[] iConfigurationElementArray = pageElements = configurationElement.getChildren("wizardPage");
                    int n = pageElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement element = iConfigurationElementArray[n2];
                        try {
                            PageDescriptor pageDescriptor = new PageDescriptor(element);
                            this.pageDescriptors.add(pageDescriptor);
                            NewObjectWizard.this.addPage(pageDescriptor.getPage());
                        }
                        catch (CoreException e) {
                            Activator.handleError(e, "Could not add a content type specific page to the new wizard.\nThe offending element is {0}\u00a0in {1} with page implementation {2}. Please file a bug report.", element, element.getContributor().getName(), element.getAttribute("page"));
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    IStatus status = Activator.handleError(e, "Could not prepare type specific parts of the New dialog.", new Object[0]);
                    if (NewObjectWizard.this.dialog == null) break block5;
                    NewObjectWizard.this.dialog.setErrorMessage(status.getMessage());
                }
            }
        }

        public void setShowMetadataPage(boolean showMetadataPage) {
            this.showMetadataPage = showMetadataPage;
        }

        public boolean isShowMetadataPage() {
            return this.showMetadataPage;
        }

        public void setNeedsValidMetadata(boolean needsValidMetadata) {
            this.needsValidMetadata = needsValidMetadata;
            NewObjectWizard.this.metadataPage.setNeedsCompleteMetadata(needsValidMetadata);
        }

        public boolean isNeedsValidMetadata() {
            return this.needsValidMetadata;
        }

        public void setPreparator(INewObjectPreparator preparator) {
            this.preparator = preparator;
        }

        public INewObjectPreparator getPreparator() {
            return this.preparator;
        }

        public void setContentType(TGContentType contentType) {
            this.contentType = contentType;
        }

        public TGContentType getContentType() {
            return this.contentType;
        }

        class PageDescriptor {
            private ITextGridWizardPage page;
            private String title;
            private boolean required;

            public ITextGridWizardPage getPage() {
                return this.page;
            }

            public String getTitle() {
                return this.title;
            }

            public boolean isRequired() {
                return this.required;
            }

            public PageDescriptor(IConfigurationElement element) throws CoreException {
                this.page = (ITextGridWizardPage)element.createExecutableExtension("page");
                this.title = element.getAttribute("title");
                this.page.init(NewObjectWizard.this, TypeSpecificAspects.this.getPreparator());
                if (this.title != null && !"".equals(this.title)) {
                    this.page.setTitle(this.title);
                }
            }
        }
    }
}

