/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.handlers;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.tgauthclient.TgAuthClientUtilities;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.handlers.Messages;
import info.textgrid.lab.ui.core.utils.TGODefaultLabelProvider;
import info.textgrid.namespaces.middleware.tgauth.AuthenticationFault;
import info.textgrid.namespaces.middleware.tgauth.BooleanResponse;
import info.textgrid.namespaces.middleware.tgauth.GetDeactivatedProjectsRequest;
import info.textgrid.namespaces.middleware.tgauth.GetDeactivatedProjectsResponse;
import info.textgrid.namespaces.middleware.tgauth.PortTgextra;
import info.textgrid.namespaces.middleware.tgauth.ProjectInfo;
import info.textgrid.namespaces.middleware.tgauth.ReactivateProjectRequest;
import info.textgrid.namespaces.middleware.tgauth.UnknownProjectFault;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ReactivateProjectDialog
extends TrayDialog {
    Group g;
    Label statusLabel;
    Button closeButton;
    Button reactivateButton;
    TableViewer projectViewer;

    public ReactivateProjectDialog(Shell shell) {
        super(shell);
        this.initialize();
    }

    public ReactivateProjectDialog(IShellProvider parentShell) {
        super(parentShell);
        this.initialize();
    }

    protected void initialize() {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.reactivateButton = this.createButton(parent, -123, Messages.ReactivateProjectDialog_Reactivate, true);
        this.closeButton = this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
        this.closeButton.setFocus();
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 12) {
            this.close();
        } else if (buttonId == -123) {
            ArrayList<TextGridProject> toBeReactivated = this.getTextGridProjectsForReactivation();
            ArrayList<TextGridProject> success = new ArrayList<TextGridProject>();
            ArrayList<TextGridProject> failed = new ArrayList<TextGridProject>();
            try {
                try {
                    PortTgextra tgextra = TgAuthClientUtilities.getTgAuthServiceStub();
                    String me = RBACSession.getInstance().getSID(false);
                    for (TextGridProject p : toBeReactivated) {
                        ReactivateProjectRequest rpa = new ReactivateProjectRequest();
                        rpa.setAuth(me);
                        rpa.setLog("");
                        rpa.setProject(p.getId());
                        BooleanResponse br = tgextra.reactivateProject(rpa);
                        if (br.isResult()) {
                            success.add(p);
                            continue;
                        }
                        failed.add(p);
                    }
                }
                catch (AuthenticationFault e) {
                    e.printStackTrace();
                    this.informUser(NLS.bind((String)Messages.ReactivateProjectDialog_IM_ReactivateOutOf, (Object)success.size(), (Object)toBeReactivated.size()));
                    if (success.size() > 0) {
                        TextGridProjectRoot.getInstance().resetProjects();
                        this.projectViewer.setInput(this.getDeactivatedProjects());
                    }
                    this.projectViewer.getTable().deselectAll();
                }
                catch (UnknownProjectFault e) {
                    block15: {
                        e.printStackTrace();
                        this.informUser(NLS.bind((String)Messages.ReactivateProjectDialog_IM_ReactivateOutOf, (Object)success.size(), (Object)toBeReactivated.size()));
                        if (success.size() <= 0) break block15;
                        TextGridProjectRoot.getInstance().resetProjects();
                        this.projectViewer.setInput(this.getDeactivatedProjects());
                    }
                    this.projectViewer.getTable().deselectAll();
                }
            }
            finally {
                this.informUser(NLS.bind((String)Messages.ReactivateProjectDialog_IM_ReactivateOutOf, (Object)success.size(), (Object)toBeReactivated.size()));
                if (success.size() > 0) {
                    TextGridProjectRoot.getInstance().resetProjects();
                    this.projectViewer.setInput(this.getDeactivatedProjects());
                }
                this.projectViewer.getTable().deselectAll();
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        GridData parentGD = new GridData();
        parentGD.horizontalAlignment = 4;
        parentGD.grabExcessVerticalSpace = true;
        parentGD.grabExcessHorizontalSpace = true;
        parentGD.heightHint = 300;
        parentGD.widthHint = 400;
        parentGD.verticalAlignment = 4;
        this.g = new Group(parent, 0);
        this.g.setLayout((Layout)new GridLayout(1, false));
        this.g.setText(Messages.ReactivateProjectDialog_IM_ReactivateDeactivated);
        Label hint = new Label((Composite)this.g, 64);
        hint.setText(NLS.bind((String)Messages.ReactivateProjectDialog_IM_ListOfProjects, (Object)TextGridProject.findLabelForRBACRole((String)"Projektleiter")));
        this.projectViewer = new TableViewer((Composite)this.g, 268438274);
        GridData projectTreeData = new GridData(4, 4, true, true);
        projectTreeData.heightHint = 200;
        this.projectViewer.getTable().setLayoutData((Object)projectTreeData);
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new TGODefaultLabelProvider(true));
        this.projectViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.projectViewer.setInput(this.getDeactivatedProjects());
        Composite c = new Composite((Composite)this.g, 4);
        GridData cGD = new GridData();
        cGD.horizontalAlignment = 4;
        cGD.grabExcessVerticalSpace = true;
        cGD.grabExcessHorizontalSpace = true;
        cGD.heightHint = 100;
        cGD.widthHint = 400;
        cGD.verticalAlignment = 4;
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)cGD);
        Label stLabel = new Label(c, 16384);
        stLabel.setText("Status: ");
        this.statusLabel = new Label(c, 64);
        GridData stGD = new GridData();
        stGD.horizontalAlignment = 4;
        stGD.grabExcessVerticalSpace = true;
        stGD.grabExcessHorizontalSpace = true;
        stGD.heightHint = 80;
        stGD.widthHint = 200;
        stGD.verticalAlignment = 4;
        this.statusLabel.setLayoutData((Object)stGD);
        this.statusLabel.setText(Messages.ReactivateProjectDialog_NothingRestored);
        this.statusLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        return this.g;
    }

    private ArrayList<TextGridProject> getDeactivatedProjects() {
        ArrayList<TextGridProject> allDeactivatedProjects = new ArrayList<TextGridProject>();
        try {
            PortTgextra tgextra = TgAuthClientUtilities.getTgAuthServiceStub();
            GetDeactivatedProjectsRequest gdpr = new GetDeactivatedProjectsRequest();
            gdpr.setAuth(RBACSession.getInstance().getSID(true));
            gdpr.setLog("");
            GetDeactivatedProjectsResponse response = tgextra.getDeactivatedProjects(gdpr);
            List pis = response.getProject();
            if (pis != null) {
                for (ProjectInfo pi : pis) {
                    allDeactivatedProjects.add(TextGridProject.getProjectInstance((ProjectInfo)pi));
                }
            }
        }
        catch (RemoteException e) {
            Activator.handleError(e, "Caught Remote Exception", e.getMessage());
        }
        return allDeactivatedProjects;
    }

    private ArrayList<TextGridProject> getTextGridProjectsForReactivation() {
        ArrayList<TextGridProject> rp = new ArrayList<TextGridProject>();
        IStructuredSelection spss = (IStructuredSelection)this.projectViewer.getSelection();
        for (Object o : spss) {
            if (!(o instanceof TextGridProject)) continue;
            rp.add((TextGridProject)o);
        }
        return rp;
    }

    public void informUser(String message) {
        this.statusLabel.setText(message);
        this.statusLabel.pack();
    }
}

