/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.util.collection;

import info.textgrid.util.collection.FilteringIterator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public class Filter<E>
implements Collection<E>,
Iterable<E> {
    private Collection<? super E> base;
    private Class<E> filterType;

    public Filter(Collection<? super E> base, Class<E> filterType) {
        this.base = base;
        this.filterType = filterType;
    }

    public Collection<? super E> getBase() {
        return this.base;
    }

    public Class<E> getFilterType() {
        return this.filterType;
    }

    @Override
    public boolean add(E o) {
        return this.base.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.base.addAll(c);
    }

    @Override
    public void clear() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.isAllowed(o) && this.base.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (!this.base.containsAll(c)) {
            return false;
        }
        for (Object o : c) {
            if (this.isAllowed(o)) continue;
            return false;
        }
        return true;
    }

    public boolean isAllowed(Object o) {
        return this.filterType.isInstance(o);
    }

    @Override
    public boolean isEmpty() {
        if (this.base.isEmpty()) {
            return true;
        }
        return !((FilteringIterator)this.iterator()).hasNext();
    }

    @Override
    public FilteringIterator<E> iterator() {
        return new FilteringIterator<E>(this.base.iterator(), this.filterType);
    }

    @Override
    public boolean remove(Object o) {
        return this.base.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.base.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Iterator iterator = this.iterator();
        boolean result = false;
        while (iterator.hasNext()) {
            if (c.contains(iterator.next())) continue;
            iterator.remove();
            result = true;
        }
        return result;
    }

    @Override
    public int size() {
        int count = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] result = a;
        int pos = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (pos == a.length) {
                result = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
                System.arraycopy(a, 0, result, 0, pos);
            }
            result[pos] = iter.next();
            ++pos;
        }
        if (pos < result.length) {
            result[pos] = null;
        }
        return result;
    }
}

