/*
 * Decompiled with CFR 0.152.
 */
package com.logabit.xlayout.handlers;

import com.logabit.xlayout.ControlHandlerConfig;
import com.logabit.xlayout.utils.ConvertHelper;
import java.util.Collections;
import java.util.Map;

public class HandlerElement {
    private Map<String, String> attributes;
    private ControlHandlerConfig config;
    private static final String ATTR_READ_ONLY = "readonly";
    private int readonly = 0;

    public HandlerElement(ControlHandlerConfig config, Map<String, String> attributes) {
        this.config = config;
        this.attributes = attributes;
    }

    public String getAttributeValueAsString(String name, String defaultValue) {
        String stringValue = this.attributes.get(name);
        return ConvertHelper.convertToString(stringValue, defaultValue);
    }

    public boolean getAttributeValueAsBoolean(String name, boolean defaultValue) {
        String stringValue = this.attributes.get(name);
        return ConvertHelper.convertToBoolean(stringValue, defaultValue);
    }

    public int getAttributeValueAsInteger(String name, int defaultValue) {
        String stringValue = this.attributes.get(name);
        return ConvertHelper.convertToInteger(stringValue, defaultValue);
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public ControlHandlerConfig getControlHandlerConfig() {
        return this.config;
    }

    public int getSWTStyle() {
        String styleAttrValue = this.attributes.get("style");
        String rdonly = this.attributes.get(ATTR_READ_ONLY);
        if (rdonly != null && rdonly.equals("true")) {
            this.readonly = 8;
        }
        if (styleAttrValue == null || "".equals(styleAttrValue)) {
            return this.config.getDefaultStyle() | this.readonly;
        }
        String[] tokens = styleAttrValue.split("\\|");
        String token = null;
        int style = 0;
        int a = 0;
        while (a < tokens.length) {
            token = tokens[a].trim();
            style |= ConvertHelper.convertToSWTStyle(token, 0);
            ++a;
        }
        return style | this.readonly;
    }

    public int getReadOnlyFlag() {
        return this.readonly;
    }
}

