/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor.autoCompletion;

import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.metadataeditor.autoCompletion.Messages;
import info.textgrid.lab.core.metadataeditor.utils.OMUtil;
import info.textgrid.lab.search.AbstractRequest;
import info.textgrid.lab.search.AutocompletionClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.commons.httpclient.HttpException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.jaxen.JaxenException;

public class TGNAutoCompletionClient
extends AutocompletionClient {
    protected static final String URL = "http://textgridlab.org/tgnsearch/tgnquery.xql?ac=";
    public static final String NS = "http://textgrid.info/namespaces/vocabularies/tgn";
    private Map<String, String> geoNamesMap = Collections.synchronizedMap(new HashMap());

    public TGNAutoCompletionClient(String whichField) {
        super(whichField);
    }

    protected AbstractRequest createRequest(String whereToComplete, String query) {
        return new Request(whereToComplete, query);
    }

    private void fetchResult(String query, IProgressMonitor monitor) throws HttpException, IOException, XMLStreamException, FactoryConfigurationError, JaxenException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.geoNamesMap.clear();
        monitor.worked(30);
        OMElement response = this.getHttpResponse(URL, query);
        if (response == null) {
            return;
        }
        monitor.worked(50);
        List persons = OMUtil.getElementListWithName("term", response, NS, "tgn");
        for (OMElement o : persons) {
            String id = o.getAttributeValue(new QName("id"));
            String name = o.getFirstChildWithName(new QName(NS, "name")).getText();
            String path = o.getFirstChildWithName(new QName(NS, "path")).getText();
            String[] completeName = path.split("\\|");
            path = "";
            int i = 0;
            while (i < completeName.length) {
                path = String.valueOf(path) + completeName[i];
                if (i >= 2) break;
                path = String.valueOf(path) + "|";
                ++i;
            }
            String n = String.valueOf(name) + " | " + path.replaceFirst("\\s*\\|\\s*World", "");
            if (n.endsWith("|")) {
                n = n.substring(0, n.length() - 1);
            }
            this.geoNamesMap.put(n, id);
        }
        monitor.worked(10);
    }

    protected int getMinimalLength() {
        return 3;
    }

    public String getIdByName(String name) {
        return this.geoNamesMap.get(name);
    }

    public class Request
    extends AbstractRequest {
        public Request(String field, String query) {
            super(field, query);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
                if (progress.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                progress.beginTask(Messages.TGNAutoCompletionClient_fetching, 100);
                TGNAutoCompletionClient.this.fetchResult(this.query, (IProgressMonitor)progress);
                ArrayList l = new ArrayList(TGNAutoCompletionClient.this.geoNamesMap.keySet());
                Collections.sort(l);
                this.addAllProposals(l);
                TGNAutoCompletionClient.this.forceOpenPopupIfClosed();
                progress.done();
                return Status.OK_STATUS;
            }
            catch (Exception e) {
                Activator.handleError(e);
                return Status.CANCEL_STATUS;
            }
        }
    }
}

