/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor.elements;

import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.metadataeditor.elements.AdvancedControlElement;
import info.textgrid.lab.core.metadataeditor.elements.ComplexRepeatControlElement;
import info.textgrid.lab.core.metadataeditor.elements.IAdvancedControlsContainer;
import info.textgrid.lab.core.metadataeditor.elements.IControl;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableComposite;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableControl;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableItemsGroup;
import info.textgrid.lab.core.metadataeditor.elements.NotImplementedException;
import info.textgrid.lab.core.metadataeditor.utils.OMUtil;
import info.textgrid.lab.core.model.TextGridObject;
import java.util.LinkedList;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.jaxen.JaxenException;

public class ComplexRepeatItemsGroup
implements IRepresentableItemsGroup {
    private LinkedList<IControl> controls = new LinkedList();
    private Button remove_btn = null;
    private ComplexRepeatControlElement parent = null;

    public ComplexRepeatItemsGroup(ComplexRepeatControlElement parent) {
        this.parent = parent;
    }

    void addControl(IControl e) {
        this.controls.addLast(e);
        if (e instanceof AdvancedControlElement) {
            ((AdvancedControlElement)e).setItemsGroup(this);
        }
    }

    void addRemoveButton(Button b) {
        this.remove_btn = b;
    }

    void activateRemoveButton(boolean active) {
        if (this.remove_btn != null && !this.remove_btn.isDisposed()) {
            this.remove_btn.setEnabled(active);
        }
    }

    @Override
    public void clear() {
        for (IControl c : this.controls) {
            c.clear();
        }
    }

    String getIdByRefId(String refId) {
        for (IControl c : this.controls) {
            if (!(c instanceof IAdvancedControlsContainer)) continue;
            IAdvancedControlsContainer adc = (IAdvancedControlsContainer)c;
            LinkedList<AdvancedControlElement> advancedControls = adc.getAdvancedControls();
            for (AdvancedControlElement e : advancedControls) {
                if (!e.getRefId().equals(refId)) continue;
                return e.getId();
            }
        }
        return refId;
    }

    private AdvancedControlElement getAdvancedControlElementById(String id) {
        for (IControl c : this.controls) {
            if (!(c instanceof IAdvancedControlsContainer)) continue;
            IAdvancedControlsContainer adc = (IAdvancedControlsContainer)c;
            LinkedList<AdvancedControlElement> advancedControls = adc.getAdvancedControls();
            for (AdvancedControlElement e : advancedControls) {
                if (!e.getId().equals(id)) continue;
                return e;
            }
        }
        return null;
    }

    void createOMElements(OMFactory omFactory, OMElement parent, OMNamespace ns) {
        for (IControl c : this.controls) {
            if (c instanceof AdvancedControlElement) {
                AdvancedControlElement e = (AdvancedControlElement)c;
                if (e.getRef() != null) {
                    AdvancedControlElement ac = this.getAdvancedControlElementById(e.getRef());
                    if (ac == null) continue;
                    e.createOMElement(omFactory, ac.getOMElement(), ns, true);
                    continue;
                }
                e.createOMElement(omFactory, parent, ns, false);
                continue;
            }
            c.createOMElement(omFactory, parent, ns, false);
        }
    }

    boolean setOMElement(OMElement root, ComplexRepeatControlElement repE, boolean tg) {
        boolean found = false;
        String parent_name = repE.getParentName();
        if (parent_name != null && !"".equals(parent_name)) {
            OMElement elem = null;
            List elems = null;
            try {
                elems = tg ? OMUtil.getElementListWithName(parent_name, root, "http://textgrid.info/namespaces/metadata/core/2010", "tg") : OMUtil.getElementListWithName(parent_name, root, TextGridObject.CUSTOM_NAMESPACE, "cns");
            }
            catch (JaxenException e) {
                Activator.handleError(e);
                return false;
            }
            boolean setForThisGroup = false;
            for (Object o : elems) {
                elem = (OMElement)o;
                if (elem == null) continue;
                if (!setForThisGroup) {
                    for (IControl c : this.controls) {
                        found |= c.setOMElement(elem, tg);
                    }
                    setForThisGroup = true;
                    continue;
                }
                repE.addControlsGroup();
                repE.getAllGroups().getLast().setOMElement(elem, repE, tg);
            }
        }
        return found;
    }

    @Override
    public void dispose() {
        while (!this.controls.isEmpty()) {
            IControl e = this.controls.getLast();
            this.controls.removeLast();
            e.dispose();
        }
        this.remove_btn.dispose();
    }

    @Override
    public boolean validate() {
        boolean valid = true;
        for (IControl c : this.controls) {
            valid &= c.validate();
        }
        return valid;
    }

    @Override
    public void createOMElement(OMFactory omFactory, OMElement parent, OMNamespace ns, boolean asAttribute) {
        throw new NotImplementedException();
    }

    @Override
    public boolean setOMElement(OMElement root, boolean tg) {
        throw new NotImplementedException();
    }

    @Override
    public String getId() {
        throw new NotImplementedException();
    }

    @Override
    public List<Control> getSWTControls() {
        LinkedList<Control> swtControls = new LinkedList<Control>();
        for (IControl c : this.controls) {
            if (c instanceof IRepresentableControl) {
                swtControls.add(((IRepresentableControl)c).getSWTControl());
                continue;
            }
            if (!(c instanceof IRepresentableComposite)) continue;
            swtControls.addAll(((IRepresentableComposite)c).getSWTControls());
        }
        swtControls.add((Control)this.remove_btn);
        return swtControls;
    }

    @Override
    public IRepresentableComposite getUnit() {
        return this;
    }

    @Override
    public List<IControl> getControls() {
        return this.controls;
    }

    @Override
    public Control getFirstControlByName(String name) {
        for (IControl c : this.controls) {
            if (!(c instanceof IAdvancedControlsContainer)) continue;
            IAdvancedControlsContainer adc = (IAdvancedControlsContainer)c;
            LinkedList<AdvancedControlElement> advancedControls = adc.getAdvancedControls();
            for (AdvancedControlElement e : advancedControls) {
                if (!e.getName().equals(name)) continue;
                return e.getSWTControl();
            }
        }
        return null;
    }

    @Override
    public void setExpanded(boolean expand) {
        this.parent.setExpanded(expand);
    }

    @Override
    public boolean isExpanded() {
        return this.parent.isExpanded();
    }
}

