/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.middleware.tgsearch.client;

import info.textgrid.middleware.tgsearch.api.Baseline;
import info.textgrid.middleware.tgsearch.api.Info;
import info.textgrid.middleware.tgsearch.api.Navigation;
import info.textgrid.middleware.tgsearch.api.Relation;
import info.textgrid.middleware.tgsearch.api.Search;
import info.textgrid.namespaces.middleware.tgsearch.PathResponse;
import info.textgrid.namespaces.middleware.tgsearch.Response;
import info.textgrid.namespaces.middleware.tgsearch.Revisions;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;

public class SearchClient {
    private String sid = "";
    private String logstring = "";
    private int LIMIT = 20;
    private String ORDER = "asc:title";
    private String target = "both";
    private int kwicWidth = 40;
    private int wordDistance = -1;
    private boolean resolvePath = false;
    private Search search;
    private Navigation nav;
    private Info info;
    private Relation relation;
    private Baseline baseline;

    public SearchClient(String endpoint) {
        this.search = (Search)JAXRSClientFactory.create((String)(endpoint + "/search"), Search.class);
        this.nav = (Navigation)JAXRSClientFactory.create((String)(endpoint + "/navigation"), Navigation.class);
        this.info = (Info)JAXRSClientFactory.create((String)(endpoint + "/info"), Info.class);
        this.relation = (Relation)JAXRSClientFactory.create((String)(endpoint + "/relation"), Relation.class);
        this.baseline = (Baseline)JAXRSClientFactory.create((String)(endpoint + "/baseline"), Baseline.class);
    }

    public Response query(String query) {
        int start = 0;
        String pstring = new Boolean(this.resolvePath).toString();
        Response res = this.search.getQuery(query, this.target, this.sid, this.logstring, "", this.ORDER, start, this.LIMIT, this.kwicWidth, this.wordDistance, pstring, "false", "false");
        return res;
    }

    public Response query(String query, String order, String sessionid, int start, int limit) {
        String pstring = new Boolean(this.resolvePath).toString();
        Response res = this.search.getQuery(query, this.target, this.sid, this.logstring, sessionid, order, start, limit, this.kwicWidth, this.wordDistance, pstring, "false", "false");
        return res;
    }

    public Response queryAllProjects(String query, String order, String sessionid, int start, int limit) {
        String pstring = new Boolean(this.resolvePath).toString();
        Response res = this.search.getQuery(query, this.target, this.sid, this.logstring, sessionid, order, start, limit, this.kwicWidth, this.wordDistance, pstring, "true", "false");
        return res;
    }

    public Response queryBaseline(String query, String order, String sessionid, int start, int limit) {
        Response res = this.baseline.getQuery(query, this.sid, order, this.logstring, start, limit);
        return res;
    }

    public Response queryBaseline(String query, int start) {
        Response res = this.baseline.getQuery(query, this.sid, this.ORDER, this.logstring, start, this.LIMIT);
        return res;
    }

    public Response listProject(String id) {
        Response res = this.nav.listProject(id, this.sid, this.logstring);
        return res;
    }

    public Response listAggregation(String id) {
        Response res = this.nav.listAggregation(id, this.sid, this.logstring);
        return res;
    }

    public Response listToplevelAggregations() {
        Response res = this.nav.listToplevelAggregations();
        return res;
    }

    public Revisions listRevisions(String uri) {
        return this.info.revisions(uri);
    }

    public Response listRevisionsAndMeta(String uri) {
        return this.info.revisionsAndMeta(uri, this.sid);
    }

    public Response getMetadata(String uri) {
        String pstring = new Boolean(this.resolvePath).toString();
        return this.info.metadata(uri, this.sid, pstring);
    }

    public Response getRelated(String relation, String uri) {
        return this.relation.getRelation(this.sid, this.logstring, relation, uri);
    }

    public Response getMeta4Relation(String relation, String uri) {
        String pstring = new Boolean(this.resolvePath).toString();
        return this.relation.getOnlyMetadata(this.sid, this.logstring, relation, uri, pstring);
    }

    public Response getRelatedAndMeta(String relation, String uri) {
        return this.relation.getCombined(this.sid, this.logstring, relation, uri);
    }

    public PathResponse getPath(String uri) {
        return this.info.getPath(uri);
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getSid() {
        return this.sid;
    }

    public void setLogstring(String logstring) {
        this.logstring = logstring;
    }

    public String getLogstring() {
        return this.logstring;
    }

    public void setLIMIT(int limit) {
        this.LIMIT = limit;
    }

    public void setORDER(String order) {
        this.ORDER = order;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setKwicWidth(int kwicWidth) {
        this.kwicWidth = kwicWidth;
    }

    public int getKwicWidth() {
        return this.kwicWidth;
    }

    public void setWordDistance(int wordDistance) {
        this.wordDistance = wordDistance;
    }

    public int getWordDistance() {
        return this.wordDistance;
    }

    public void setResolvePath(boolean getPath) {
        this.resolvePath = getPath;
    }

    public boolean isResolvePath() {
        return this.resolvePath;
    }
}

