/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.multicharbrowser;

import info.textgrid.lab.xmleditor.multicharbrowser.Activator;
import info.textgrid.lab.xmleditor.multicharbrowser.Messages;
import info.textgrid.lab.xmleditor.multicharbrowser.StreamWriterUtils;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class UnicodeSymbolResourceReader {
    private static Hashtable<String, String> unicodeSymbolsHashtable = new Hashtable();

    public static Hashtable<String, String> getMusicalSymbolsHashtable() {
        return unicodeSymbolsHashtable;
    }

    public static void readFromFile() {
        unicodeSymbolsHashtable.clear();
        StreamWriterUtils.writeResourceToTempFile(Activator.getDefault().getStateLocation().toPortableString(), "Resources", "Unicode51XmlSupplement.xml");
        UnicodeSymbolResourceReader.readerBackgroundJob();
    }

    private static void readerBackgroundJob() {
        Job job = new Job(Messages.UnicodeSymbolResourceReader_0){

            protected IStatus run(IProgressMonitor monitor) {
                File xmlFile = new File(String.valueOf(Activator.getDefault().getStateLocation().toPortableString()) + "/Unicode51XmlSupplement.xml");
                if (xmlFile.exists()) {
                    UnicodeSymbolResourceReader.parseUnicodeXmlBlockFile(xmlFile);
                } else {
                    StreamWriterUtils.writeLogError(4, Messages.UnicodeSymbolResourceReader_2, xmlFile);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    StreamWriterUtils.writeLogError(4, Messages.UnicodeSymbolResourceReader_3, event);
                }
            }
        });
        job.setPriority(20);
        job.setSystem(true);
        job.schedule();
    }

    private static void parseUnicodeXmlBlockFile(File xmlFile) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(xmlFile);
            NodeList ndList = document.getElementsByTagName("symbol");
            int i = 0;
            while (i < ndList.getLength()) {
                NamedNodeMap namedNodeMap = ndList.item(i).getAttributes();
                unicodeSymbolsHashtable.put(namedNodeMap.getNamedItem("id").getNodeValue().toString(), namedNodeMap.getNamedItem("name").getNodeValue().toString());
                ++i;
            }
        }
        catch (SAXParseException spe) {
            StreamWriterUtils.writeLogError(4, String.valueOf(spe.getLineNumber()) + ", uri " + spe.getSystemId(), spe);
        }
        catch (SAXException sxe) {
            StreamWriterUtils.writeLogError(4, sxe.getMessage(), sxe);
        }
        catch (ParserConfigurationException pce) {
            StreamWriterUtils.writeLogError(4, pce.getMessage(), pce);
        }
        catch (IOException ioe) {
            StreamWriterUtils.writeLogError(4, ioe.getMessage(), ioe);
        }
    }
}

