/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.log.logsession;
import info.textgrid.lab.workflow.Chain;
import info.textgrid.lab.workflow.ChainGWDL;
import info.textgrid.lab.workflow.ChainTGWF;
import info.textgrid.lab.workflow.EntryLink;
import info.textgrid.lab.workflow.WorkflowEngine;
import info.textgrid.lab.workflow.tgwf.CRUD;
import info.textgrid.lab.workflow.tgwf.Inputs;
import info.textgrid.lab.workflow.tgwf.Link;
import info.textgrid.lab.workflow.tgwf.ObjectFactory;
import info.textgrid.lab.workflow.tgwf.Tgwf;
import info.textgrid.lab.workflow.tgwf.URI;
import info.textgrid.namespaces.middleware.workflow.gwesproxy.PortGwesproxy;
import info.textgrid.namespaces.middleware.workflow.gwesproxy.Property;
import info.textgrid.namespaces.middleware.workflow.gwesproxy.UploadWorkflowRequest;
import info.textgrid.namespaces.middleware.workflow.gwesproxy.UploadWorkflowResponse;
import info.textgrid.namespaces.middleware.workflow.gwesproxy.WFDetails;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXB;
import javax.xml.stream.XMLStreamException;
import net.kwfgrid.gworkflowdl.structure.CapacityException;
import net.kwfgrid.gworkflowdl.structure.Data;
import net.kwfgrid.gworkflowdl.structure.JdomString;
import net.kwfgrid.gworkflowdl.structure.Place;
import net.kwfgrid.gworkflowdl.structure.Token;
import net.kwfgrid.gworkflowdl.structure.Workflow;
import net.kwfgrid.gworkflowdl.structure.WorkflowFormatException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;

public class WorkflowJob
extends PlatformObject
implements Comparable<WorkflowJob> {
    private String workflowID;
    private String workflowDescription;
    private String workflowStatus;
    private Date workflowStartDate;
    private Long workflowStartDateMS;
    private String warnings = "";
    private String workflowForSubmission = "";
    private PortGwesproxy proxy;
    private ObjectFactory tgwfFactory = new ObjectFactory();
    private Tgwf tgwf;
    private String gwdl;
    private String targetProjectId;
    private List<Property> workflowProperties;

    public WorkflowJob(TextGridObject workflow, String targetProjectId, ArrayList<ArrayList<TextGridObject>> inputTGOs, ArrayList<EntryLink> inputLinks) {
        IFile sf = (IFile)workflow.getAdapter(IFile.class);
        try {
            this.tgwf = (Tgwf)JAXB.unmarshal((InputStream)sf.getContents(true), Tgwf.class);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        this.targetProjectId = targetProjectId;
        ChainTGWF ct = new ChainTGWF(this.tgwf);
        Chain c = ct.getChain();
        ChainGWDL cg = new ChainGWDL(c);
        cg.insertCrudTransitions(targetProjectId);
        cg.connectMetadata();
        cg.mergeInputObjects(inputTGOs, inputLinks);
        this.gwdl = cg.marshal();
    }

    public WorkflowJob(TextGridObject gwdlTGO, String targeProjectId, ArrayList<java.net.URI> inputbatch) {
        Workflow w = null;
        IFile sf = (IFile)gwdlTGO.getAdapter(IFile.class);
        try {
            InputStream is = sf.getContents();
            String s = WorkflowJob.readFully(is);
            w = JdomString.string2workflow((String)s);
        }
        catch (WorkflowFormatException e) {
            e.printStackTrace();
        }
        catch (CapacityException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Place targetProjectPlace = w.getPlace("targetProject");
        Place inputURIsPlace = w.getPlace("Input");
        Place sidPlace = w.getPlace("crud-sessionId");
        Place logPlace = w.getPlace("crud-logParameter");
        targetProjectPlace.removeAllTokens();
        inputURIsPlace.removeAllTokens();
        sidPlace.removeAllTokens();
        logPlace.removeAllTokens();
        try {
            targetProjectPlace.addToken(ChainGWDL.constructDataToken("param", targeProjectId));
            sidPlace.addToken(ChainGWDL.constructDataToken("param", RBACSession.getInstance().getSID(false)));
            logPlace.addToken(ChainGWDL.constructDataToken("param", logsession.getInstance().getloginfo()));
            int groupIndex = 0;
            for (java.net.URI oneURI : inputbatch) {
                Token oneToken = ChainGWDL.constructDataToken("param", oneURI.toString());
                oneToken.getProperties().put("data.group", "UriNumber" + groupIndex);
                inputURIsPlace.addToken(oneToken);
                ++groupIndex;
            }
        }
        catch (CapacityException e1) {
            e1.printStackTrace();
        }
        try {
            this.gwdl = JdomString.workflow2string((Workflow)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.targetProjectId = this.targetProjectId;
    }

    public String start() {
        this.proxy = WorkflowEngine.getInstance().getGwesProxy();
        UploadWorkflowRequest req = new UploadWorkflowRequest();
        req.setGwdl(this.gwdl);
        req.setTargetproject(this.targetProjectId);
        req.setAuth(RBACSession.getInstance().getSID(false));
        req.setLog(logsession.getInstance().getloginfo());
        UploadWorkflowResponse resp = this.proxy.uploadWorkflow(req);
        this.workflowID = resp.getWorkflowid();
        return this.workflowID;
    }

    public WorkflowJob(WFDetails wfd) {
        this.workflowID = wfd.getID();
        this.workflowProperties = wfd.getProperty();
        this.workflowDescription = wfd.getDescription();
        for (Property p : this.workflowProperties) {
            if ("status".equals(p.getName())) {
                this.workflowStatus = p.getValue();
                continue;
            }
            if ("birthdayMs".equals(p.getName())) {
                this.workflowStartDateMS = new Long(p.getValue());
                this.workflowStartDate = new Date(this.workflowStartDateMS);
                continue;
            }
            if (!p.getName().matches("warn\\..+") && !p.getName().matches("error\\..+")) continue;
            this.warnings = String.valueOf(this.warnings) + p.getName() + ": " + p.getValue() + "\n";
        }
    }

    public void insertCurrentSettings(Tgwf tgwf, String targetProject) {
        String crudEpr = "";
        try {
            ConfClient confClient = ConfClient.getInstance();
            crudEpr = confClient.getValue("tgcrud");
        }
        catch (OfflineException e) {
            e.printStackTrace();
        }
        CRUD crud = this.tgwfFactory.createCRUD();
        crud.setInstance(crudEpr);
        crud.setSessionID(RBACSession.getInstance().getSID(false));
        crud.setLogParameter(logsession.getInstance().getloginfo());
        crud.setTargetProject(targetProject);
        tgwf.setCRUD(crud);
    }

    public void mergeWithInputs(Tgwf tgwf, ArrayList<ArrayList<TextGridObject>> inputTGOs, ArrayList<EntryLink> inputLinks) {
        Inputs inputList = this.tgwfFactory.createInputs();
        int index = 0;
        for (EntryLink l : inputLinks) {
            String tgwfLinkId = "";
            for (Link cand : tgwf.getDatalinks().getLink()) {
                if (!cand.getType().equals("input") || !cand.getToParam().equals(l.getToPort().getParam()) || !cand.getToServiceID().equals(Integer.toString(l.getTo().getID()))) continue;
                tgwfLinkId = cand.getId();
                break;
            }
            ArrayList<TextGridObject> thisBoxList = inputTGOs.get(index);
            Iterator<TextGridObject> issiter = thisBoxList.iterator();
            int groupIndex = 0;
            while (issiter.hasNext()) {
                URI u = this.tgwfFactory.createURI();
                u.setLinkId(tgwfLinkId);
                if (l.getToPort().isMultiple().booleanValue()) {
                    u.setGroupId("multi");
                } else {
                    u.setGroupId(Integer.toString(groupIndex));
                }
                TextGridObject oneInput = issiter.next();
                u.setValue(oneInput.getURI().toString());
                inputList.getURI().add(u);
                ++groupIndex;
            }
            ++index;
        }
        tgwf.setInputs(inputList);
    }

    public String toString() {
        return this.workflowDescription;
    }

    public String getStatus() {
        return this.workflowStatus;
    }

    public Date getDate() {
        return this.workflowStartDate;
    }

    public String getWfID() {
        return this.workflowID;
    }

    public ArrayList<TextGridObject> getResultTGOs() {
        ArrayList<TextGridObject> result = new ArrayList<TextGridObject>();
        String resultWorkflow = WorkflowEngine.getInstance().getWorkflowString(this.workflowID);
        Workflow w = null;
        try {
            w = JdomString.string2workflow((String)resultWorkflow);
        }
        catch (WorkflowFormatException e) {
            e.printStackTrace();
        }
        catch (CapacityException e) {
            e.printStackTrace();
        }
        Place[] placeArray = w.getPlaces();
        int n = placeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Place p = placeArray[n2];
            if (p.getProperties().get("Output") != null) {
                Token[] tokenArray = p.getTokens();
                int n3 = tokenArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Token t = tokenArray[n4];
                    Data d = t.getData();
                    String xmlString = d.toXML();
                    OMElement tgoMDom = null;
                    try {
                        tgoMDom = AXIOMUtil.stringToOM((String)xmlString);
                        tgoMDom = tgoMDom.getFirstElement().getFirstElement();
                    }
                    catch (XMLStreamException e) {
                        e.printStackTrace();
                    }
                    try {
                        TextGridObject oneTGO = TextGridObject.getInstance((OMElement)tgoMDom, (boolean)true);
                        result.add(oneTGO);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    @Override
    public int compareTo(WorkflowJob o) {
        if (this.workflowStartDateMS > o.workflowStartDateMS) {
            return -1;
        }
        if (this.workflowStartDateMS == o.workflowStartDateMS) {
            return 0;
        }
        return 1;
    }

    public boolean hasErrors() {
        return !"".equals(this.warnings);
    }

    public String getErrors() {
        return this.warnings;
    }

    public static String readFully(InputStream stream) throws IOException {
        return WorkflowJob.readFully(new InputStreamReader(stream));
    }

    public static String readFully(Reader reader) throws IOException {
        int numChars;
        char[] arr = new char[8192];
        StringBuffer buf = new StringBuffer();
        while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
            buf.append(arr, 0, numChars);
        }
        return buf.toString();
    }
}

