/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.views;

import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.ProjectDoesNotExistException;
import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.core.swtutils.DeferredListContentProvider;
import info.textgrid.lab.core.swtutils.PendingLabelProvider;
import info.textgrid.lab.ui.core.menus.TGOpenWithMenu;
import info.textgrid.lab.ui.core.utils.UpdatingDeferredListContentProvider;
import info.textgrid.lab.workflow.Activator;
import info.textgrid.lab.workflow.Chain;
import info.textgrid.lab.workflow.ChainEntry;
import info.textgrid.lab.workflow.ChainTGWF;
import info.textgrid.lab.workflow.servicedescription.Service;
import info.textgrid.lab.workflow.tgwf.Tgwf;
import info.textgrid.lab.workflow.views.ChainEntryView;
import info.textgrid.lab.workflow.views.ListOfWorkflows;
import info.textgrid.lab.workflow.views.MetadataTransformView;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import javax.xml.bind.JAXB;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.part.ViewPart;

public class ChainView
extends ViewPart {
    private TableViewer viewer;
    private Chain chain;
    private String tgwf;
    private ComboViewer saveProjectViewer;
    private Text workflowNameText;
    private Button finishButton;
    private TextGridObject originalTGO = null;
    private final UpdatingDeferredListContentProvider sPcontentProvider = new UpdatingDeferredListContentProvider();
    private DeferredListContentProvider.IDoneListener doneListener;

    public ChainView() {
        this.chain = new Chain();
    }

    public void createPartControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridData gdc = new GridData(4, 4, true, true);
        c.setLayoutData((Object)gdc);
        GridLayout glp = new GridLayout(1, false);
        c.setLayout((Layout)glp);
        this.viewer = new TableViewer(c, 68356);
        this.viewer.getTable().setHeaderVisible(false);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ChainLabelProvider());
        GridData gd1 = new GridData(4, 4, true, true);
        this.viewer.getControl().setLayoutData((Object)gd1);
        this.refreshViewer();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookContextMenu(this.viewer);
        Composite aboveBottomBar = new Composite(c, 4);
        aboveBottomBar.setLayout((Layout)new GridLayout(1, false));
        GridData gd2 = new GridData(4, 2, true, false);
        aboveBottomBar.setLayoutData((Object)gd2);
        GridData gd4a = new GridData(16384, 0x1000000, false, false);
        Label workflowName = new Label(aboveBottomBar, 4);
        workflowName.setLayoutData((Object)gd4a);
        workflowName.setText("Workflow name");
        this.workflowNameText = new Text(aboveBottomBar, 2052);
        GridData gd4b = new GridData(16384, 0x1000000, true, false);
        gd4b.widthHint = 2000;
        this.workflowNameText.setLayoutData((Object)gd4b);
        GridData gd3a = new GridData(16384, 0x1000000, false, false);
        Label saveProjectlabel = new Label(aboveBottomBar, 4);
        saveProjectlabel.setLayoutData((Object)gd3a);
        saveProjectlabel.setText("Save in Project");
        this.saveProjectViewer = new ComboViewer(aboveBottomBar, 4);
        GridData gd6b = new GridData(16384, 0x1000000, true, false);
        gd6b.widthHint = 2000;
        this.saveProjectViewer.getControl().setLayoutData((Object)gd6b);
        this.saveProjectViewer.setContentProvider((IContentProvider)this.sPcontentProvider);
        this.saveProjectViewer.setLabelProvider((IBaseLabelProvider)new PendingLabelProvider());
        this.saveProjectViewer.setInput((Object)TextGridProjectRoot.getInstance((TextGridProjectRoot.LEVELS)TextGridProjectRoot.LEVELS.EDITOR));
        Composite bottomBar = new Composite(c, 4);
        bottomBar.setLayout((Layout)new GridLayout(2, false));
        GridData gd4 = new GridData(4, 2, true, false);
        bottomBar.setLayoutData((Object)gd4);
        Button newButton = new Button(bottomBar, 8);
        newButton.setText("New");
        newButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ChainView.this.originalTGO = null;
                ChainView.this.chain = new Chain();
                ChainView.this.refreshViewer();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button validateButton = new Button(bottomBar, 8);
        validateButton.setText("Edit Metadata");
        validateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ChainView.this.chain.connectOutputs();
                boolean valid = ChainView.this.validateChain();
                ChainView.this.chain.dumpLinks();
                System.out.println("Chain is valid: " + valid);
                MetadataTransformView mv = ChainView.this.openMetadataView();
                mv.refreshTransformerView(ChainView.this.chain);
                ChainView.this.finishButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button clearButton = new Button(bottomBar, 8);
        clearButton.setText("Clear Links");
        clearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ChainView.this.chain.clearLinks();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.finishButton = new Button(bottomBar, 8);
        this.finishButton.setText("Finish and Save");
        this.finishButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TextGridObject tgwfTGO;
                IFile file;
                MetadataTransformView mv = ChainView.this.openMetadataView();
                mv.setFromInputs();
                String title = ChainView.this.workflowNameText.getText();
                ChainView.this.chain.setDescription(title);
                ChainView.this.tgwf = ChainView.this.chain.toString();
                IStructuredSelection spss = (IStructuredSelection)ChainView.this.saveProjectViewer.getSelection();
                TextGridProject saveProject = null;
                if (spss.getFirstElement() instanceof TextGridProject) {
                    saveProject = (TextGridProject)spss.getFirstElement();
                    if (saveProject == null) {
                        ChainView.this.showMessage("No target project selected.");
                        return;
                    }
                } else {
                    ChainView.this.showMessage("No target project selected!");
                }
                if (title == null || title.length() < 1) {
                    int a = ChainView.this.tgwf.indexOf("<description>");
                    int z = ChainView.this.tgwf.indexOf("</description>");
                    title = ChainView.this.tgwf.substring(a + "<description>".length(), z);
                }
                boolean isNewObject = true;
                try {
                    if (ChainView.this.originalTGO != null && title.equals(ChainView.this.originalTGO.getTitle()) && saveProject.getId().equals(ChainView.this.originalTGO.getProject())) {
                        isNewObject = false;
                    }
                }
                catch (CoreException e2) {
                    e2.printStackTrace();
                }
                if ((file = (IFile)AdapterUtils.getAdapter((Object)(tgwfTGO = isNewObject ? TextGridObject.getNewObjectInstance((TextGridProject)saveProject, (TGContentType)TGContentType.getContentType((String)"text/tg.workflow+xml"), (String)title) : ChainView.this.originalTGO), IFile.class)) == null) {
                    System.out.println("Cannot save " + title);
                } else {
                    try {
                        file.setContents((InputStream)new ByteArrayInputStream(ChainView.this.tgwf.getBytes("UTF-8")), true, false, null);
                    }
                    catch (UnsupportedEncodingException e1) {
                        e1.printStackTrace();
                    }
                    catch (CoreException e1) {
                        e1.printStackTrace();
                    }
                }
                ChainView.this.originalTGO = tgwfTGO;
                ChainView.this.openSubmitPerspective();
                IViewPart wfView = null;
                try {
                    wfView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("info.textgrid.lab.workflow.views.WorkflowSelection");
                }
                catch (PartInitException e1) {
                    e1.printStackTrace();
                }
                if (wfView != null && wfView instanceof ListOfWorkflows) {
                    ListOfWorkflows wfInstance = (ListOfWorkflows)wfView;
                    wfInstance.refreshViewer();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.finishButton.setEnabled(false);
    }

    private void openSubmitPerspective() {
        try {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchPage wbPage = wb.getActiveWorkbenchWindow().getActivePage();
            if (wbPage == null) {
                wb.getActiveWorkbenchWindow().openPage("info.textgrid.lab.workflow.WorkflowPerspective", null);
            }
            wbPage.setPerspective(wb.getPerspectiveRegistry().findPerspectiveWithId("info.textgrid.lab.workflow.WorkflowPerspective"));
            PlatformUI.getWorkbench().showPerspective("info.textgrid.lab.workflow.WorkflowPerspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        }
        catch (WorkbenchException e) {
            Status status = new Status(4, "info.textgrid.lab.workflow", "Could not open Workflow Submit Perspective!", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    private void refreshViewer() {
        this.viewer.setInput(this.chain.getChain());
    }

    private boolean validateChain() {
        return this.chain.validateLinks();
    }

    private void openConfigureView() {
        IStructuredSelection wfss = (IStructuredSelection)this.viewer.getSelection();
        ChainEntry ce = (ChainEntry)wfss.getFirstElement();
        if (ce == null) {
            return;
        }
        IViewPart configureView = null;
        try {
            configureView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("info.textgrid.lab.workflow.views.ChainEntryView");
        }
        catch (PartInitException e) {
            Status status = new Status(4, "info.textgrid.lab.workflow", "View for Service Configuration is not existent", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        if (configureView != null && configureView instanceof ChainEntryView) {
            ChainEntryView cevInstance = (ChainEntryView)configureView;
            cevInstance.setChainEntry(ce);
        }
    }

    public void addService(TextGridObject service) {
        IFile sf = (IFile)service.getAdapter(IFile.class);
        try {
            Service cfr_ignored_0 = (Service)JAXB.unmarshal((InputStream)sf.getContents(true), Service.class);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        ChainEntry centry = new ChainEntry(service);
        this.chain.addEntry(centry);
        this.refreshViewer();
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)centry), true);
    }

    public void setChainFromTGWF(TextGridObject tgwfTGO) {
        this.originalTGO = tgwfTGO;
        IFile tgwfFile = (IFile)tgwfTGO.getAdapter(IFile.class);
        Tgwf tgwf = null;
        try {
            tgwf = (Tgwf)JAXB.unmarshal((InputStream)tgwfFile.getContents(true), Tgwf.class);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        ChainTGWF ct = new ChainTGWF(tgwf);
        this.chain = ct.getChain();
        try {
            this.workflowNameText.setText(tgwfTGO.getTitle());
            final String origProjectId = tgwfTGO.getProject();
            this.doneListener = new DeferredListContentProvider.IDoneListener(){

                public void loadDone(Viewer viewer) {
                    try {
                        ChainView.this.saveProjectViewer.setSelection((ISelection)new StructuredSelection((Object)TextGridProject.getProjectInstance((String)origProjectId)), true);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                    catch (CrudServiceException e) {
                        e.printStackTrace();
                    }
                    catch (ProjectDoesNotExistException e) {
                        e.printStackTrace();
                    }
                }
            };
            this.sPcontentProvider.addDoneListener(this.doneListener);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        MetadataTransformView mv = this.openMetadataView();
        mv.refreshTransformerView(this.chain);
        this.finishButton.setEnabled(true);
        this.refreshViewer();
    }

    public Chain getChain() {
        return this.chain;
    }

    private void hookContextMenu(final TableViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ChainView.this.fillContextMenu(manager, viewer);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    private void fillContextMenu(IMenuManager manager, TableViewer viewer) {
        MenuManager openWithSubMenu = new MenuManager("Open with...");
        Object firstElement = ((IStructuredSelection)viewer.getSelection()).getFirstElement();
        if (firstElement == null) {
            return;
        }
        IFile iFile = (IFile)((IAdaptable)firstElement).getAdapter(IFile.class);
        openWithSubMenu.add((IContributionItem)new TGOpenWithMenu(this.getSite().getPage(), (IAdaptable)iFile));
        manager.add((IContributionItem)openWithSubMenu);
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    private void hookDoubleClickAction(TableViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Service List", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        this.sPcontentProvider.removeDoneListener(this.doneListener);
    }

    private MetadataTransformView openMetadataView() {
        IViewPart mdtView = null;
        try {
            mdtView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("info.textgrid.lab.workflow.views.MetadataTransform");
        }
        catch (PartInitException pie) {
            Status status = new Status(4, "info.textgrid.lab.workflow", "View for Metadata Transformation is not existent", (Throwable)pie);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        MetadataTransformView mdtInstance = null;
        if (mdtView != null && mdtView instanceof MetadataTransformView) {
            mdtInstance = (MetadataTransformView)mdtView;
        }
        return mdtInstance;
    }

    class ChainLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ChainLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (!(obj instanceof ChainEntry)) {
                return "unknown class: " + obj.getClass();
            }
            ChainEntry ce = (ChainEntry)obj;
            if (index == 0) {
                return ce.getName();
            }
            return "extra column " + index;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

