/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.views;

import info.textgrid.lab.ui.core.menus.TGOpenWithMenu;
import info.textgrid.lab.ui.core.utils.TextGridObjectTableViewer;
import info.textgrid.lab.workflow.WorkflowJob;
import info.textgrid.lab.workflow.views.Messages;
import java.util.ArrayList;
import java.util.EnumSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;

public class WorkflowResults
extends ViewPart {
    private TextGridObjectTableViewer viewer;

    public void createPartControl(Composite parent) {
        Composite c = new Composite(parent, 4);
        c.setLayout((Layout)new GridLayout(1, false));
        GridData cGD = new GridData();
        cGD.horizontalAlignment = 4;
        cGD.grabExcessVerticalSpace = true;
        cGD.grabExcessHorizontalSpace = true;
        cGD.verticalAlignment = 4;
        c.setLayoutData((Object)cGD);
        this.viewer = new TextGridObjectTableViewer(c, 66306);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setVisibleColumns(EnumSet.of(TextGridObjectTableViewer.Column.TITLE));
        this.viewer.getTable().setHeaderVisible(false);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookContextMenu();
        GridData vGD = new GridData();
        vGD.horizontalAlignment = 4;
        vGD.grabExcessVerticalSpace = true;
        vGD.grabExcessHorizontalSpace = true;
        vGD.verticalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)vGD);
    }

    public void refreshViewer(WorkflowJob job) {
        if (job == null) {
            this.viewer.setInput(new ArrayList());
        } else {
            this.viewer.setInput((Object)job.getResultTGOs().toArray());
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                WorkflowResults.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        MenuManager openWithSubMenu = new MenuManager(Messages.WorkflowResults_openwith);
        Object firstElement = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (firstElement == null) {
            return;
        }
        IFile iFile = (IFile)((IAdaptable)firstElement).getAdapter(IFile.class);
        openWithSubMenu.add((IContributionItem)new TGOpenWithMenu(this.getSite().getPage(), (IAdaptable)iFile));
        manager.add((IContributionItem)openWithSubMenu);
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
    }
}

