/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.wizard;

import info.textgrid.lab.workflow.Chain;
import info.textgrid.lab.workflow.ChainEntry;
import info.textgrid.lab.workflow.EntryLink;
import info.textgrid.lab.workflow.EntryLinkFromComparator;
import info.textgrid.lab.workflow.servicedescription.Input;
import info.textgrid.lab.workflow.servicedescription.Output;
import info.textgrid.lab.workflow.wizard.Messages;
import info.textgrid.lab.workflow.wizard.ServiceConfigurationPage;
import info.textgrid.lab.workflow.wizard.WorkflowWizard;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class LinkInsertionPage
extends WizardPage
implements Listener {
    Chain chain;
    Composite composite;
    ScrolledComposite scrolledcomposite;
    boolean chainIsValid = false;

    public LinkInsertionPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.LinkInsertionPage_pagetitle);
        this.setDescription(Messages.LinkInsertionPage_pagedescription);
    }

    public void createControl(Composite parent) {
        this.chain = ((WorkflowWizard)this.getWizard()).getChain();
        GridData parentGD = new GridData();
        parentGD.horizontalAlignment = 4;
        parentGD.grabExcessVerticalSpace = true;
        parentGD.grabExcessHorizontalSpace = true;
        parentGD.heightHint = 400;
        parentGD.widthHint = 800;
        parentGD.verticalAlignment = 4;
        parent.setLayoutData((Object)parentGD);
        this.scrolledcomposite = new ScrolledComposite(parent, 768);
        this.scrolledcomposite.setAlwaysShowScrollBars(true);
        this.composite = new Composite((Composite)this.scrolledcomposite, 2048);
        GridLayout glstd = new GridLayout(1, false);
        this.composite.setLayout((Layout)glstd);
        GridData gdstd = new GridData(4, 4, true, true);
        this.composite.setLayoutData((Object)gdstd);
        this.scrolledcomposite.setContent((Control)this.composite);
        this.scrolledcomposite.setExpandVertical(true);
        this.scrolledcomposite.setExpandHorizontal(true);
        this.scrolledcomposite.setMinWidth(775);
        this.scrolledcomposite.setMinHeight(300 * this.chain.getChain().size());
        this.setControl((Control)this.scrolledcomposite);
        this.drawCEboxes();
        this.chainIsValid = this.chain.validateLinks();
    }

    public void drawCEboxes() {
        Control[] controlArray = this.composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        for (ChainEntry ce : this.chain.getChain()) {
            this.drawCEbox(ce);
        }
        this.appendClearButton();
        this.scrolledcomposite.setMinHeight(200 * this.chain.getChain().size());
        this.scrolledcomposite.layout(true, true);
    }

    public void appendClearButton() {
        Button clearButton = new Button(this.composite, 8);
        clearButton.setText(Messages.LinkInsertionPage_ClearLinksButtonText);
        clearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LinkInsertionPage.this.chain.clearLinks();
                LinkInsertionPage.this.chain.connectEntriesMonotone();
                LinkInsertionPage.this.drawCEboxes();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public void drawCEbox(ChainEntry ce) {
        Composite comp = new Composite(this.composite, 2048);
        GridLayout glstd = new GridLayout(1, false);
        comp.setLayout((Layout)glstd);
        GridData gdstd = new GridData(4, 4, true, false);
        comp.setLayoutData((Object)gdstd);
        this.drawInputLinks(ce, comp);
        this.drawName(ce, comp);
        this.drawOutputLinks(ce, comp);
    }

    public void drawInputLinks(ChainEntry e, Composite comp) {
        int noOfInputLInks = e.getInputs().size();
        Composite paramBar = new Composite(comp, 0);
        GridLayout glstd = new GridLayout(noOfInputLInks + 1, false);
        glstd.horizontalSpacing = 15;
        paramBar.setLayout((Layout)glstd);
        GridData gdstd = new GridData(4, 4, true, true);
        paramBar.setLayoutData((Object)gdstd);
        Label labelFrom = new Label(paramBar, 4);
        labelFrom.setText(Messages.LinkInsertionPage_FromLabel);
        GridData gd3aF = new GridData(16384, 0x1000000, false, false);
        labelFrom.setLayoutData((Object)gd3aF);
        for (Input i : e.getInputs()) {
            List<EntryLink> linksToHere = this.chain.findLinksToHere(e, i);
            LinkLabelProvider clp = new LinkLabelProvider();
            if (linksToHere.size() == 1) {
                EntryLink solitaire = linksToHere.get(0);
                Label fromReal = new Label(paramBar, 4);
                GridData gd3a = new GridData(16384, 0x1000000, true, false);
                fromReal.setLayoutData((Object)gd3a);
                fromReal.setText(clp.getText(solitaire));
                if (!solitaire.isUndecided()) continue;
                this.chain.addLink(solitaire);
                this.checkLinksComplete();
                continue;
            }
            final ComboViewer cv = new ComboViewer(paramBar, 4);
            GridData gd0 = new GridData(4, 4, false, false);
            cv.getControl().setLayoutData((Object)gd0);
            cv.setLabelProvider((IBaseLabelProvider)clp);
            cv.setContentProvider((IContentProvider)new ArrayContentProvider());
            cv.setComparator((ViewerComparator)new EntryLinkFromComparator());
            cv.setInput(linksToHere);
            cv.addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection sel = (IStructuredSelection)cv.getSelection();
                    if (sel == null) {
                        return;
                    }
                    Object elem = sel.getFirstElement();
                    if (elem instanceof EntryLink) {
                        EntryLink selectedLink = (EntryLink)elem;
                        LinkInsertionPage.this.chain.addLink(selectedLink);
                        LinkInsertionPage.this.drawCEboxes();
                        LinkInsertionPage.this.checkLinksComplete();
                    }
                }
            });
        }
        Label labelInput = new Label(paramBar, 4);
        labelInput.setText(Messages.LinkInsertionPage_InputLabel);
        GridData gd3aI = new GridData(16384, 0x1000000, false, false);
        labelInput.setLayoutData((Object)gd3aI);
        for (Input i : e.getInputs()) {
            Label nextInputName = new Label(paramBar, 4);
            GridData gd3N = new GridData(16384, 0x1000000, true, false);
            nextInputName.setLayoutData((Object)gd3N);
            nextInputName.setText(i.getName());
        }
    }

    public void drawName(ChainEntry e, Composite comp) {
        Composite nameBar = new Composite(comp, 0);
        GridLayout glstd = new GridLayout(2, false);
        glstd.horizontalSpacing = 20;
        nameBar.setLayout((Layout)glstd);
        GridData gdstd = new GridData(4, 4, true, false);
        nameBar.setLayoutData((Object)gdstd);
        Label labelName = new Label(nameBar, 4);
        labelName.setText(e.getName());
        GridData gd3aI = new GridData(16384, 0x1000000, false, false);
        labelName.setLayoutData((Object)gd3aI);
        Label descriptionText = new Label(nameBar, 64);
        GridData gdll = new GridData(4, 4, true, false);
        descriptionText.setLayoutData((Object)gdll);
        descriptionText.setText(e.getDescription());
        descriptionText.setBounds(nameBar.getBounds());
    }

    public void drawOutputLinks(ChainEntry e, Composite comp) {
        int noOfOutputLInks = e.getOutputs().size();
        Composite paramBar = new Composite(comp, 0);
        GridLayout glstd = new GridLayout(noOfOutputLInks + 1, false);
        glstd.horizontalSpacing = 15;
        paramBar.setLayout((Layout)glstd);
        GridData gdstd = new GridData(4, 4, true, true);
        paramBar.setLayoutData((Object)gdstd);
        Label labelOutput = new Label(paramBar, 4);
        labelOutput.setText(Messages.LinkInsertionPage_OutputLabel);
        GridData gd3aI = new GridData(16384, 0x1000000, false, false);
        labelOutput.setLayoutData((Object)gd3aI);
        for (Output o : e.getOutputs()) {
            Label nextOutputName = new Label(paramBar, 4);
            GridData gd3N = new GridData(16384, 0x1000000, true, false);
            nextOutputName.setLayoutData((Object)gd3N);
            nextOutputName.setText(o.getName());
        }
        Label labelTo = new Label(paramBar, 4);
        labelTo.setText(Messages.LinkInsertionPage_ToLabel);
        GridData gd3aF = new GridData(16384, 0x1000000, false, false);
        labelTo.setLayoutData((Object)gd3aF);
        for (Output o : e.getOutputs()) {
            List<EntryLink> linksFromHere = this.chain.findLinksFromHere(e, o);
            LinkOutLabelProvider clp = new LinkOutLabelProvider();
            if (linksFromHere.size() == 1) {
                EntryLink solitaire = linksFromHere.get(0);
                Label toReal = new Label(paramBar, 4);
                GridData gd3a = new GridData(16384, 0x1000000, true, false);
                toReal.setLayoutData((Object)gd3a);
                toReal.setText(clp.getText(solitaire));
                if (!solitaire.isUndecided()) continue;
                this.chain.addLink(solitaire);
                this.checkLinksComplete();
                continue;
            }
            final ComboViewer cv = new ComboViewer(paramBar, 4);
            GridData gd0 = new GridData(4, 4, false, false);
            cv.getControl().setLayoutData((Object)gd0);
            cv.setLabelProvider((IBaseLabelProvider)clp);
            cv.setContentProvider((IContentProvider)new ArrayContentProvider());
            cv.setInput(linksFromHere);
            cv.addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection sel = (IStructuredSelection)cv.getSelection();
                    if (sel == null) {
                        return;
                    }
                    Object elem = sel.getFirstElement();
                    if (elem instanceof EntryLink) {
                        EntryLink selectedLink = (EntryLink)elem;
                        LinkInsertionPage.this.chain.addLink(selectedLink);
                        LinkInsertionPage.this.drawCEboxes();
                        LinkInsertionPage.this.checkLinksComplete();
                    }
                }
            });
        }
    }

    public void checkLinksComplete() {
        this.chainIsValid = this.chain.validateLinks();
        this.setPageComplete(this.chainIsValid);
    }

    public void handleEvent(Event event) {
    }

    public boolean canFlipToNextPage() {
        return this.chainIsValid;
    }

    public IWizardPage getNextPage() {
        ServiceConfigurationPage sc = ((WorkflowWizard)this.getWizard()).serviceConfiguration;
        sc.drawCEboxes();
        return sc;
    }

    class LinkLabelProvider
    extends LabelProvider {
        LinkLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof EntryLink) {
                EntryLink l = (EntryLink)obj;
                if (l.getFrom() == null || l.getFromPort() == null) {
                    return Messages.LinkInsertionPage_LinkFromWorkflowInputs;
                }
                return String.valueOf(l.getFrom().getName()) + ", " + l.getFromPort().getName();
            }
            return "unknown class: " + obj.getClass();
        }
    }

    class LinkOutLabelProvider
    extends LabelProvider {
        LinkOutLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof EntryLink) {
                EntryLink l = (EntryLink)obj;
                if (l.getTo() == null || l.getToPort() == null) {
                    return Messages.LinkInsertionPage_LinkToWorkflowOutputs;
                }
                return String.valueOf(l.getTo().getName()) + ", " + l.getToPort().getName();
            }
            return "unknown class: " + obj.getClass();
        }
    }
}

