/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.importexport.model;

import com.google.common.collect.Maps;
import info.textgrid._import.ImportSpec;
import info.textgrid._import.RewriteMethod;
import info.textgrid._import.XmlConfiguration;
import info.textgrid.lab.core.importexport.model.Messages;
import info.textgrid.utils.linkrewriter.ConfigurableXMLRewriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class RewriteSetup {
    private static final RewriteSetup NONE = new RewriteSetup(RewriteMethod.NONE);
    private RewriteMethod method;
    private XmlConfiguration configuration;
    private URI uri;
    private static LinkedHashMap<URI, RewriteSetup> internalSetups;

    protected RewriteMethod getMethod() {
        return this.method;
    }

    protected XmlConfiguration getConfiguration() {
        return this.configuration;
    }

    protected URI getUri() {
        return this.uri;
    }

    public RewriteSetup(URI uri, XmlConfiguration configuration) {
        this.uri = uri;
        this.configuration = configuration;
        this.method = RewriteMethod.XML;
    }

    protected RewriteSetup(RewriteMethod method) {
        this.method = method;
    }

    public RewriteSetup(ImportSpec spec, URI uri) {
        this.method = RewriteMethod.XML;
        this.uri = uri;
    }

    public static LinkedHashMap<URI, RewriteSetup> getInternal() {
        if (internalSetups == null) {
            internalSetups = Maps.newLinkedHashMap();
            internalSetups.put(URI.create("none"), NONE);
            for (Map.Entry entry : ConfigurableXMLRewriter.getInternalConfigurations().entrySet()) {
                internalSetups.put((URI)entry.getKey(), new RewriteSetup((URI)entry.getKey(), (XmlConfiguration)entry.getValue()));
            }
        }
        return internalSetups;
    }

    public String toString() {
        switch (this.method) {
            case NONE: {
                return Messages.RewriteSetup_Method_None;
            }
            case TEXT: {
                return Messages.RewriteSetup_Method_Plain_Text;
            }
            case XML: {
                return NLS.bind((String)Messages.RewriteSetup_Label_URI_Format, (Object)(this.getConfiguration() == null ? Messages.RewriteSetup_Custom : this.getConfiguration().getDescription()), (Object)this.getUri());
            }
        }
        return super.toString();
    }

    public static RewriteSetup of(RewriteMethod rewriteMethod, String rewriteConfig) {
        if (rewriteMethod == RewriteMethod.NONE) {
            return NONE;
        }
        if (rewriteMethod == RewriteMethod.XML) {
            try {
                URI uri = new URI(rewriteConfig);
                return RewriteSetup.getInternal().get(uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RewriteSetup other = (RewriteSetup)obj;
        if (this.method != other.method) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

