/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.importexport.ui;

import info.textgrid.lab.core.importexport.ImportPlugin;
import info.textgrid.lab.core.importexport.model.ImportExportStatus;
import info.textgrid.lab.core.importexport.ui.ImportExportPart;
import info.textgrid.lab.core.importexport.ui.ImportPart;
import info.textgrid.lab.core.importexport.ui.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wb.swt.ResourceManager;

public class ResultPage
extends Composite {
    private TreeViewer resultViewer;
    private Label summaryLabel;
    private Button back;
    private ImportExportPart editor;
    private boolean isImport;

    public ResultPage(final Composite parent, final ImportExportPart editor) {
        super(parent, 0);
        this.editor = editor;
        this.isImport = editor instanceof ImportPart;
        this.setLayout((Layout)new GridLayout(1, false));
        CLabel titleLable = new CLabel((Composite)this, 0);
        titleLable.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        titleLable.setText(this.isImport ? Messages.ResultPage_Import_Finished : Messages.ResultPage_Export_Finished);
        this.summaryLabel = new Label((Composite)this, 64);
        this.summaryLabel.setText(this.isImport ? Messages.ResultPage_Import_Some_Problems : Messages.ResultPage_Export_Some_Problems);
        this.resultViewer = new TreeViewer((Composite)this, 67584);
        Tree tree = this.resultViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TreeViewerColumn statusColumn = new TreeViewerColumn(this.resultViewer, 16384);
        statusColumn.setLabelProvider((CellLabelProvider)new StatusSeverityLabelProvider());
        TreeColumn tblclmnNewColumn = statusColumn.getColumn();
        tblclmnNewColumn.setMoveable(true);
        tblclmnNewColumn.setWidth(63);
        tblclmnNewColumn.setText(Messages.ResultPage_Status);
        TreeViewerColumn messageColumn = new TreeViewerColumn(this.resultViewer, 0);
        TreeColumn tblclmnMessage = messageColumn.getColumn();
        tblclmnMessage.setWidth(290);
        tblclmnMessage.setText(Messages.ResultPage_Message);
        messageColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IStatus) {
                    return ((IStatus)element).getMessage();
                }
                return super.getText(element);
            }
        });
        TreeViewerColumn obectColumn = new TreeViewerColumn(this.resultViewer, 0);
        TreeColumn tblclmnObject = obectColumn.getColumn();
        tblclmnObject.setWidth(100);
        tblclmnObject.setText(Messages.ResultPage_URI);
        obectColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                ImportExportStatus status;
                if (element instanceof ImportExportStatus && (status = (ImportExportStatus)((Object)element)).getEntry() != null && status.getEntry().getObject() != null) {
                    try {
                        return status.getEntry().getObject().getContentType(false).getImage(true);
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e, "info.textgrid.lab.core.importexport");
                    }
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof ImportExportStatus) {
                    ImportExportStatus status = (ImportExportStatus)((Object)element);
                    return status.getEntry().getTextgridUri();
                }
                return null;
            }
        });
        TreeViewerColumn fileColumn = new TreeViewerColumn(this.resultViewer, 0);
        TreeColumn tblclmnFile = fileColumn.getColumn();
        tblclmnFile.setWidth(100);
        tblclmnFile.setText(Messages.ResultPage_File);
        fileColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ImportExportStatus status;
                if (element instanceof ImportExportStatus && (status = (ImportExportStatus)((Object)element)).getEntry() != null) {
                    return status.getEntry().getLocalData();
                }
                return null;
            }
        });
        this.resultViewer.setContentProvider((IContentProvider)new StatusTreeContentProvider());
        Label label = new Label((Composite)this, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label saveLabel = new Label((Composite)this, 64);
        saveLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        saveLabel.setText(Messages.ResultPage_SaveInfo);
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
        this.back = new Button(composite, 0x800000);
        this.back.setImage(ResourceManager.getPluginImage("org.eclipse.ui", "/icons/full/elcl16/backward_nav.gif"));
        this.back.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (parent instanceof PageBook) {
                    PageBook pages = (PageBook)parent;
                    pages.showPage(pages.getChildren()[0]);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Label space = new Label(composite, 0x1000020);
        space.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
        Button btnSaveToTextgrid = new Button(composite, 0);
        btnSaveToTextgrid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                editor.saveAsTextGridObject(false);
            }
        });
        btnSaveToTextgrid.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        btnSaveToTextgrid.setImage(ResourceManager.getPluginImage("org.eclipse.ui", "/icons/full/etool16/save_edit.gif"));
        btnSaveToTextgrid.setText(Messages.ResultPage_Save_to_TextGrid);
        Button btnSaveToFile = new Button(composite, 0);
        btnSaveToFile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        btnSaveToFile.setImage(ResourceManager.getPluginImage("info.textgrid.lab.ui.core", "icons/017-speichere-DateiLokal2.gif"));
        btnSaveToFile.setText(Messages.ResultPage_Save_to_File);
        btnSaveToFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                editor.saveAsLocalFile();
            }
        });
    }

    public void setInput(IStatus result) {
        if (!this.isDisposed()) {
            if (result.isOK()) {
                this.summaryLabel.setText(this.isImport ? Messages.ResultPage_Import_Successful : Messages.ResultPage_Export_Successful);
            } else {
                this.summaryLabel.setText(this.isImport ? Messages.ResultPage_Import_Some_Problems : Messages.ResultPage_Export_Some_Problems);
            }
            this.resultViewer.setInput((Object)result);
        }
    }

    private final class StatusSeverityLabelProvider
    extends ColumnLabelProvider {
        private StatusSeverityLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IStatus) {
                IStatus status = (IStatus)element;
                switch (status.getSeverity()) {
                    case 0: {
                        return ImportPlugin.getDefault().getImageRegistry().get("status-ok");
                    }
                    case 1: {
                        return ImportPlugin.getDefault().getImageRegistry().get("status-info");
                    }
                    case 2: {
                        return ImportPlugin.getDefault().getImageRegistry().get("status-warning");
                    }
                    case 4: {
                        return ImportPlugin.getDefault().getImageRegistry().get("status-error");
                    }
                }
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IStatus) {
                IStatus status = (IStatus)element;
                switch (status.getSeverity()) {
                    case 0: {
                        return Messages.ResultPage_Success;
                    }
                    case 1: {
                        return Messages.ResultPage_Info;
                    }
                    case 2: {
                        return Messages.ResultPage_Warning;
                    }
                    case 4: {
                        return Messages.ResultPage_Error;
                    }
                    case 8: {
                        return Messages.ResultPage_Cancelled;
                    }
                }
            }
            return "";
        }
    }

    private final class StatusTreeContentProvider
    implements ITreeContentProvider {
        private StatusTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IStatus) {
                IStatus status = (IStatus)parentElement;
                return status.getChildren();
            }
            return new IStatus[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IStatus) {
                return ((IStatus)element).isMultiStatus();
            }
            return false;
        }
    }
}

