/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.debug.decoraters;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import info.textgrid.lab.core.model.Activator;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class TGODecorator
extends BaseLabelProvider
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        TextGridObject object = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
        if (object == null) {
            return;
        }
        StringBuilder label = new StringBuilder(" ");
        ArrayList flags = Lists.newArrayList();
        if (object.isNew()) {
            flags.add(Character.valueOf('N'));
        }
        if (!object.isComplete()) {
            flags.add(Character.valueOf('I'));
        } else {
            try {
                if (object.getAdaptor() != null) {
                    flags.add(Character.valueOf('A'));
                }
                if (object.getSchemaURI() != null) {
                    flags.add(Character.valueOf('S'));
                }
            }
            catch (CrudServiceException e) {
                Activator.handleError((Throwable)e, null, (Object[])new Object[0]);
            }
        }
        if (flags.size() > 0) {
            label.append('[').append(Joiner.on((String)"").join((Iterable)flags)).append("] ");
        }
        try {
            label.append(object.getContentTypeID());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        decoration.addSuffix(label.toString());
    }
}

