/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.model.links;

import info.textgrid.lab.linkeditor.model.graphics.TGRectangle;
import info.textgrid.lab.linkeditor.model.links.ILink;
import info.textgrid.lab.linkeditor.model.links.RectLink;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LinksContainer
implements Iterable<ILink> {
    private static final long serialVersionUID = 1L;
    private final List<ILink> links = Collections.synchronizedList(new LinkedList());

    public boolean add(ILink link) {
        return this.links.add(link);
    }

    public void add(int index, ILink link) {
        this.links.add(index, link);
    }

    public ILink set(int index, ILink link) {
        return this.links.set(index, link);
    }

    public void edit(ILink link, String startAnchorId, String endAnchorId) {
        int index = this.links.indexOf(link);
        ILink l = this.links.get(index);
        l.setStartAnchorId(startAnchorId);
        l.setEndAnchorId(endAnchorId);
    }

    public Object clone() {
        LinksContainer lc = new LinksContainer();
        for (ILink l : this.links) {
            lc.add(l);
        }
        return lc;
    }

    @Override
    public Iterator<ILink> iterator() {
        return this.links.iterator();
    }

    public void clear() {
        this.links.clear();
    }

    public boolean isEmpty() {
        return this.links.isEmpty();
    }

    public int size() {
        return this.links.size();
    }

    public List<ILink> getList() {
        return this.links;
    }

    public ILink get(int index) {
        return this.links.get(index);
    }

    public ILink remove(int index) {
        return this.links.remove(index);
    }

    public boolean remove(ILink link) {
        return this.links.remove(link);
    }

    public static void main(String[] args) {
        TGRectangle rect = new TGRectangle("test");
        LinksContainer l = new LinksContainer();
        l.add(new RectLink(rect, "1", "2", "", true));
        l.add(new RectLink(rect, "5", "6", "", true));
        l.add(new RectLink(rect, "3", "4", "", true));
        for (ILink a : l) {
            System.err.println(a.getStartAnchorId());
        }
        System.err.println("---------------------------");
        l.edit(new RectLink(rect, "3", "4", "", true), "7", "8");
        for (ILink a : l) {
            System.err.println(a.getStartAnchorId());
        }
        TGRectangle s = new TGRectangle("test");
        System.err.println(s instanceof TGRectangle);
        TGRectangle sd = s;
        System.err.println(sd instanceof TGRectangle);
    }
}

