/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.efs.tgcrud;

import info.textgrid.lab.core.efs.tgcrud.MappingWrapper;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "info.textgrid.lab.core.efs.tgcrud";
    public static final String DEBUG_SERVICE = "info.textgrid.lab.core.efs.tgcrud/debug/servicecalls";
    public static final String DEBUG_LOCALFILE = "info.textgrid.lab.core.efs.tgcrud/debug/localfile";
    public static final String DEBUG_READS = "info.textgrid.lab.core.efs.tgcrud/debug/reads";
    public static final String DEBUG_STREAMS = "info.textgrid.lab.core.efs.tgcrud/debug/streams";
    private static final String TYPE_EXTENSION_MAPPING_PREFS = "TypeExtensionMappingPreferences";
    private static Activator plugin;
    private LinkedHashMap<Pattern, String> typeExtensionMappingCache = null;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void logServiceCall(String msg, Object ... args) {
        if (Activator.isDebugging(DEBUG_SERVICE)) {
            System.out.println(String.valueOf(System.currentTimeMillis()) + ": TGcrud/EFS: " + NLS.bind((String)msg, (Object[])args));
        }
    }

    public static boolean isDebugging(String option) {
        return Activator.getDefault().isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)option));
    }

    public IStatus handleProblem(Throwable e) {
        return this.handleProblem(4, null, e);
    }

    public IStatus handleProblem(int severity, String message, Throwable cause) {
        if ((message == null || message.equals("")) && cause != null) {
            message = cause.getLocalizedMessage();
        }
        Status status = new Status(severity, PLUGIN_ID, message, cause);
        StatusManager.getManager().handle((IStatus)status, status.getSeverity() == 4 ? 3 : 1);
        return status;
    }

    public static IStatus handleError(Throwable cause, String message, Object ... args) {
        return Activator.getDefault().handleProblem(4, NLS.bind((String)message, (Object[])args), cause);
    }

    LinkedList<MappingWrapper> getTypeExtensionMappings() {
        String prefString = this.getPreferenceStore().getString(TYPE_EXTENSION_MAPPING_PREFS);
        String[] encodedMappings = prefString.split("\n", 0);
        LinkedList<MappingWrapper> wrapperList = new LinkedList<MappingWrapper>();
        String[] stringArray = encodedMappings;
        int n = encodedMappings.length;
        int n2 = 0;
        while (n2 < n) {
            String encodedMapping = stringArray[n2];
            if (encodedMapping != null && !"".equals(encodedMapping)) {
                String ext;
                String[] mapping = encodedMapping.split("\t", 2);
                String type = mapping.length > 0 && mapping[0] != null ? mapping[0] : "";
                String string = ext = mapping.length > 1 && mapping[1] != null ? mapping[1] : "";
                if (!"".equals(type) && !"".equals(ext)) {
                    MappingWrapper wrapper = new MappingWrapper(type, ext);
                    wrapperList.add(wrapper);
                }
            }
            ++n2;
        }
        return wrapperList;
    }

    synchronized void setTypeExtensionMappings(LinkedList<MappingWrapper> wrapperList) {
        this.typeExtensionMappingCache = null;
        StringBuffer prefStringBuffer = new StringBuffer();
        for (MappingWrapper wrapper : wrapperList) {
            prefStringBuffer.append('\n');
            prefStringBuffer.append(wrapper.getContentType());
            prefStringBuffer.append('\t');
            prefStringBuffer.append(wrapper.getExtension());
        }
        this.getPreferenceStore().setValue(TYPE_EXTENSION_MAPPING_PREFS, prefStringBuffer.toString());
    }

    public synchronized LinkedHashMap<Pattern, String> getContentTypeExtensionMap() {
        if (this.typeExtensionMappingCache == null) {
            LinkedList<MappingWrapper> wrapperList = this.getTypeExtensionMappings();
            this.typeExtensionMappingCache = new LinkedHashMap();
            for (MappingWrapper wrapper : wrapperList) {
                try {
                    Pattern contentTypePattern = Pattern.compile(wrapper.getContentType());
                    String extension = wrapper.getExtension();
                    this.typeExtensionMappingCache.put(contentTypePattern, extension);
                }
                catch (Throwable e) {
                    Activator.handleError(e, "Content Type Pattern '{0}' is not a valid regular expression", wrapper.getContentType());
                }
            }
        }
        return this.typeExtensionMappingCache;
    }
}

