/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.swtutils;

import info.textgrid.lab.core.swtutils.AdapterUtils;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.progress.WorkbenchJob;

public class DeferredListContentProvider
implements IStructuredContentProvider,
ISelectionChangedListener {
    private Viewer viewer;
    private AbstractListViewer listViewer = null;
    private AbstractTableViewer tableViewer = null;
    private ListenerList doneListeners = new ListenerList();
    private ISelection oldSelection = null;
    private boolean restoreSelection = false;
    private Class<?> targetClass = null;

    public boolean isRestoreSelection() {
        return this.restoreSelection;
    }

    public void setRestoreSelection(boolean restoreSelection) {
        this.restoreSelection = restoreSelection;
        if (restoreSelection && this.viewer != null) {
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public DeferredListContentProvider() {
    }

    public DeferredListContentProvider(Class<?> targetClass) {
        this();
        this.targetClass = targetClass;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.viewer != null) {
            viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (viewer instanceof AbstractListViewer) {
            this.listViewer = (AbstractListViewer)viewer;
            this.viewer = viewer;
        } else if (viewer instanceof AbstractTableViewer) {
            this.tableViewer = (AbstractTableViewer)viewer;
            this.viewer = viewer;
        } else {
            throw new IllegalArgumentException(MessageFormat.format("A deferred list content provider must be associated with an AbstractListViewer or AbstractTableViewer, but {0} is an {1}.", viewer, viewer.getClass().getSimpleName()));
        }
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public Object[] getElements(Object inputElement) {
        PendingUpdateAdapter pendingUpdateAdapter = new PendingUpdateAdapter();
        this.startFetchingChildren(inputElement, pendingUpdateAdapter);
        return new Object[]{pendingUpdateAdapter};
    }

    protected void startFetchingChildren(Object inputElement, PendingUpdateAdapter placeholder) {
        final IDeferredWorkbenchAdapter adapter = this.getAdapter(inputElement);
        if (adapter == null) {
            throw new IllegalArgumentException(MessageFormat.format("Can only fetch children in background for an IDeferredWorkbenchAdapter, but there is none for {0}", inputElement));
        }
        final IElementCollector collector = this.createElementCollector(inputElement, placeholder);
        Job job = new Job("Fetching list of projects"){

            protected IStatus run(IProgressMonitor monitor) {
                adapter.fetchDeferredChildren((Object)adapter, collector, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected IElementCollector createElementCollector(Object inputElement, final PendingUpdateAdapter placeholder) {
        return new IElementCollector(){

            public void add(Object element, IProgressMonitor monitor) {
                this.add(new Object[]{element}, monitor);
            }

            public void add(Object[] elements, IProgressMonitor monitor) {
                DeferredListContentProvider.this.addElements(elements, monitor);
            }

            public void done() {
                DeferredListContentProvider.this.runDoneJob(placeholder);
            }
        };
    }

    protected void addElements(final Object[] elements, IProgressMonitor monitor) {
        WorkbenchJob updateJob = new WorkbenchJob("Adding elements ..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object[] realElements;
                if (DeferredListContentProvider.this.viewer.getControl().isDisposed() || monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Object[] objectArray = realElements = DeferredListContentProvider.this.targetClass == null ? elements : AdapterUtils.getAdapters(elements, DeferredListContentProvider.this.targetClass, false);
                if (DeferredListContentProvider.this.listViewer != null) {
                    DeferredListContentProvider.this.listViewer.add(realElements);
                } else {
                    DeferredListContentProvider.this.tableViewer.add(realElements);
                }
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.schedule();
    }

    protected void runDoneJob(final PendingUpdateAdapter placeholder) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        WorkbenchJob clearJob = new WorkbenchJob("Removing pending message ..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (DeferredListContentProvider.this.viewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                if (DeferredListContentProvider.this.listViewer != null) {
                    DeferredListContentProvider.this.listViewer.remove((Object)placeholder);
                } else {
                    DeferredListContentProvider.this.tableViewer.remove((Object)placeholder);
                }
                if (DeferredListContentProvider.this.restoreSelection && DeferredListContentProvider.this.oldSelection != null) {
                    DeferredListContentProvider.this.viewer.setSelection(DeferredListContentProvider.this.oldSelection, true);
                    System.out.println("Restored old selection: " + DeferredListContentProvider.this.oldSelection);
                }
                DeferredListContentProvider.this.notifyDoneListeners();
                return Status.OK_STATUS;
            }
        };
        clearJob.setSystem(true);
        clearJob.schedule();
    }

    protected IDeferredWorkbenchAdapter getAdapter(Object element) {
        if (element instanceof IDeferredWorkbenchAdapter) {
            return (IDeferredWorkbenchAdapter)element;
        }
        if (element instanceof IAdaptable) {
            return (IDeferredWorkbenchAdapter)((IAdaptable)element).getAdapter(IDeferredWorkbenchAdapter.class);
        }
        return (IDeferredWorkbenchAdapter)Platform.getAdapterManager().getAdapter(element, IDeferredWorkbenchAdapter.class);
    }

    public void dispose() {
    }

    public void addDoneListener(IDoneListener listener) {
        this.doneListeners.add((Object)listener);
    }

    public void removeDoneListener(IDoneListener listener) {
        this.doneListeners.remove((Object)listener);
    }

    protected void notifyDoneListeners() {
        Object[] objectArray = this.doneListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IDoneListener)listener).loadDone(this.viewer);
            ++n2;
        }
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection != null && !selection.isEmpty()) {
            this.oldSelection = selection;
            System.out.println("Saved selection: " + selection);
        }
    }

    public static interface IDoneListener {
        public void loadDone(Viewer var1);
    }
}

