/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.tgcrud.client;

import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.core.tgcrud.client.TGCrudClientPlugin;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.TGCrudService;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.TGCrudService_Service;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class CrudClientUtilities {
    private static final String TGCRUD_TIMEOUT_PROP = "info.textgrid.lab.core.tgcrud.timeout";
    private static final int DEFAULT_TIMEOUT = 360000;
    private static TGCrudService_Service service;
    private static TGCrudService stub;

    protected static TGCrudService_Service getService() {
        if (service == null) {
            service = new TGCrudService_Service(null, new QName("http://textgrid.info/namespaces/middleware/tgcrud/services/TGCrudService", "TGCrudService"));
        }
        return service;
    }

    private static String getCrudEPR() {
        try {
            return ConfClient.getInstance().getValue("tgcrud");
        }
        catch (OfflineException e) {
            OnlineStatus.netAccessFailed((String)"Could not retrieve TG-Crud EPR from configuration server", (Throwable)e);
            return null;
        }
    }

    public static synchronized TGCrudService getCrudServiceStub() {
        if (stub != null) {
            return stub;
        }
        stub = (TGCrudService)CrudClientUtilities.getService().getPort(TGCrudService.class, new WebServiceFeature[]{new MTOMFeature(true)});
        BindingProvider bindingProvider = (BindingProvider)stub;
        Map requestContext = bindingProvider.getRequestContext();
        requestContext.put("javax.xml.ws.service.endpoint.address", CrudClientUtilities.getCrudEPR());
        Client client = ClientProxy.getClient((Object)stub);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        int timeout = 360000;
        try {
            String timeoutProp = System.getProperty(TGCRUD_TIMEOUT_PROP);
            if (timeoutProp != null) {
                int parsedTimeout = Integer.parseInt(timeoutProp);
                if (parsedTimeout < 1000) {
                    parsedTimeout *= 1000;
                }
                timeout = parsedTimeout;
                TGCrudClientPlugin.getDefault().getLog().log((IStatus)new Status(1, "info.textgrid.lab.core.tgcrud.client.jaxws", NLS.bind((String)"Manually set TG-crud timeout to {0} ms", (Object)timeout)));
            }
        }
        catch (RuntimeException e) {
            TGCrudClientPlugin.getDefault().getLog().log((IStatus)new Status(2, "info.textgrid.lab.core.tgcrud.client.jaxws", "An error occurred while reading the timeout propertyinfo.textgrid.lab.core.tgcrud.timeout", (Throwable)e));
        }
        httpClientPolicy.setConnectionTimeout((long)timeout);
        httpClientPolicy.setReceiveTimeout((long)timeout);
        http.setClient(httpClientPolicy);
        return stub;
    }
}

