/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.feedback.ui.bugreport;

import info.textgrid.lab.feedback.ui.Activator;
import info.textgrid.lab.feedback.ui.bugreport.BugInfoDialog;
import info.textgrid.lab.feedback.ui.bugreport.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.CharBuffer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class BugInfoDialogArea
extends Composite {
    private Link logLink = null;
    private Text logArea = null;
    private BugInfoDialog dialog;
    private Label introMessage;
    private Link step1;
    private Label step2;
    private SelectionListener linkSelectionAdaptor = new LinkSelectionAdapter();
    private Label step3;
    private Link step4;
    private Label step5;
    private Link options;

    public BugInfoDialogArea(Composite parent, int style, BugInfoDialog dialog) {
        super(parent, style);
        this.dialog = dialog;
        this.initialize();
    }

    private void initialize() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        GridDataFactory labelsFactory = GridDataFactory.createFrom((GridData)gridData);
        this.introMessage = new Label((Composite)this, 64);
        this.introMessage.setText(Messages.BugInfoDialogArea_introMessage);
        labelsFactory.applyTo((Control)this.introMessage);
        this.step1 = new Link((Composite)this, 0);
        this.step1.setText(Messages.BugInfoDialogArea_step1);
        labelsFactory.applyTo((Control)this.step1);
        this.step1.addSelectionListener(this.linkSelectionAdaptor);
        this.step2 = new Label((Composite)this, 64);
        this.step2.setText(Messages.BugInfoDialogArea_step2);
        labelsFactory.applyTo((Control)this.step2);
        this.step3 = new Label((Composite)this, 64);
        this.step3.setText(Messages.BugInfoDialogArea_step3);
        labelsFactory.applyTo((Control)this.step3);
        this.step4 = new Link((Composite)this, 64);
        this.step4.setText(Messages.BugInfoDialogArea_step4);
        labelsFactory.applyTo((Control)this.step4);
        this.step4.addSelectionListener(this.linkSelectionAdaptor);
        this.step5 = new Label((Composite)this, 64);
        this.step5.setText(Messages.BugInfoDialogArea_step5);
        labelsFactory.applyTo((Control)this.step5);
        GridData logAreaGridData = new GridData();
        logAreaGridData.horizontalAlignment = 4;
        logAreaGridData.grabExcessVerticalSpace = true;
        logAreaGridData.grabExcessHorizontalSpace = true;
        logAreaGridData.heightHint = 300;
        logAreaGridData.widthHint = 500;
        logAreaGridData.verticalAlignment = 4;
        this.logArea = new Text((Composite)this, 2570);
        this.logArea.setEditable(false);
        this.logArea.setToolTipText(Messages.BugInfoDialogArea_LogTooltip);
        this.logArea.setLayoutData((Object)logAreaGridData);
        this.logLink = new Link((Composite)this, 0);
        GridData logLinkGridData = new GridData();
        logLinkGridData.horizontalAlignment = 4;
        logLinkGridData.grabExcessHorizontalSpace = true;
        this.logLink.addSelectionListener(this.linkSelectionAdaptor);
        this.options = new Link((Composite)this, 64);
        this.options.setText(Messages.BugInfoDialogArea_bottomMessage);
        labelsFactory.applyTo((Control)this.options);
        this.options.addSelectionListener(this.linkSelectionAdaptor);
        this.setSize(new Point(434, 547));
        this.setLayout((Layout)new GridLayout());
    }

    protected void saveAs() {
        this.dialog.saveLogAs();
    }

    public void setLogText(String logText) {
        this.logArea.setText(logText);
    }

    public String getLogText() {
        return this.logArea.getText();
    }

    public void updateLogText() {
        final File logFile = Platform.getLogFileLocation().toFile();
        this.logLink.setText(NLS.bind((String)Messages.BugInfoDialogArea_logLink, (Object)logFile.toString()));
        this.logLink.setToolTipText(logFile.toString());
        new Job(Messages.BugInfoDialogArea_ReadingLogFile){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    FileReader fileReader = new FileReader(logFile);
                    try {
                        final CharBuffer buffer = CharBuffer.allocate(logFile.length() <= Integer.MAX_VALUE ? (int)logFile.length() : Integer.MAX_VALUE);
                        fileReader.read(buffer);
                        buffer.rewind();
                        new UIJob(Messages.BugInfoDialogArea_ReadingLogFile){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                BugInfoDialogArea.this.setLogText(buffer.toString());
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                    finally {
                        if (fileReader != null) {
                            fileReader.close();
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    return Activator.getDefault().handleProblem(4, NLS.bind((String)Messages.BugInfoDialogArea_LogHides, (Object)logFile.getAbsolutePath()), e);
                }
                catch (IOException e) {
                    return Activator.getDefault().handleProblem(4, NLS.bind((String)Messages.BugInfoDialogArea_CouldNotReadLog, (Object)logFile.getAbsolutePath()), e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void copy() {
        Point selection = this.logArea.getSelection();
        if (selection.x == selection.y) {
            this.logArea.selectAll();
        }
        this.logArea.copy();
        this.logArea.setSelection(selection);
    }

    protected final class LinkSelectionAdapter
    extends SelectionAdapter {
        protected LinkSelectionAdapter() {
        }

        protected void openBrowser(String url) {
            try {
                PlatformUI.getWorkbench().getBrowserSupport().createBrowser("info.textgrid.lab.feedback.ui.bugreport").openURL(new URL(url));
            }
            catch (PartInitException e1) {
                Activator.getDefault().handleProblem(2, e1);
            }
            catch (MalformedURLException e1) {
                Activator.getDefault().handleProblem(4, e1);
            }
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.text.equals("#save")) {
                BugInfoDialogArea.this.dialog.saveLogAs();
            } else if (event.text.equals("#view")) {
                BugInfoDialogArea.this.dialog.showLogView();
            } else {
                this.openBrowser(event.text);
            }
        }
    }
}

