/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.templateeditor.wizard;

import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.templateeditor.config.ConfigCustomElement;
import info.textgrid.lab.templateeditor.utils.RepeatItemsGroup;
import info.textgrid.lab.templateeditor.wizard.ITemplateEditorPage;
import info.textgrid.lab.templateeditor.wizard.PageTwo;
import info.textgrid.lab.templateeditor.wizard.WizardUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class TemplateEditorWizardSelected
extends Wizard
implements IPageChangingListener {
    private PageTwo pageTwo = null;
    private WizardDialog dialog = null;
    private WizardUtils wizard_util = new WizardUtils();
    private LinkedList<RepeatItemsGroup> groups = null;

    public TemplateEditorWizardSelected(TextGridProject project) {
        this.setWindowTitle("Template Editor");
        this.setNeedsProgressMonitor(true);
        this.setSelectedProject(project);
    }

    private void setSelectedProject(TextGridProject project) {
        this.wizard_util.setProject(project);
    }

    void initPageTwo() {
        this.pageTwo.setLastCreatedCustomElements(this.wizard_util.getLastSavedCustomElements());
    }

    void setCustomElements(LinkedList<RepeatItemsGroup> groups) {
        this.groups = groups;
    }

    public void addPages() {
        super.addPages();
        this.pageTwo = new PageTwo();
        this.pageTwo.init(this);
        this.addPage(this.pageTwo);
        IWizardContainer container = this.getContainer();
        if (container instanceof WizardDialog) {
            this.dialog = (WizardDialog)container;
            this.dialog.addPageChangingListener((IPageChangingListener)this);
        }
    }

    public boolean performFinish() {
        ArrayList<ConfigCustomElement> lastElems;
        ((ITemplateEditorPage)this.getContainer().getCurrentPage()).finishPage();
        if (this.groups == null) {
            this.pageTwo.finishPage();
        }
        if ((lastElems = this.wizard_util.getLastSavedCustomElements()) != null && !lastElems.isEmpty()) {
            ArrayList<String> notFoundElems = new ArrayList<String>(10);
            ArrayList<String> inputElems = new ArrayList<String>(10);
            for (RepeatItemsGroup g : this.groups) {
                for (Control c : g.getControls()) {
                    if (!(c instanceof Text)) continue;
                    inputElems.add(((Text)c).getText());
                }
            }
            String s = "";
            for (ConfigCustomElement c : lastElems) {
                s = c.getName();
                if (inputElems.contains(s)) continue;
                notFoundElems.add(s);
            }
            if (!notFoundElems.isEmpty()) {
                MessageBox warn = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 200);
                String message = "The following fields were renamed or removed:\n";
                for (String s1 : notFoundElems) {
                    message = String.valueOf(message) + "- " + s1 + "\n";
                }
                message = String.valueOf(message) + "This may cause data loss if the listed fields were filled!\nDo you want to proceed?";
                warn.setMessage(message);
                if (warn.open() != 64) {
                    return false;
                }
            }
        }
        this.wizard_util.createAndSaveData(this.groups);
        return true;
    }

    public void handlePageChanging(PageChangingEvent event) {
        if (event.getTargetPage() == this.getNextPage((IWizardPage)event.getCurrentPage())) {
            ((ITemplateEditorPage)event.getCurrentPage()).finishPage();
        }
    }
}

