/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.templateeditor.xulmapping;

import info.textgrid.lab.core.model.util.StringToOM;
import info.textgrid.lab.templateeditor.Activator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;

public class XULCreator {
    private StringWriter writer = new StringWriter();
    private static XULCreator instance = null;

    private XULCreator() {
    }

    public static void reCreate() {
        instance = null;
        instance = new XULCreator();
    }

    public static XULCreator getInstance() {
        if (instance == null) {
            instance = new XULCreator();
        }
        return instance;
    }

    public void addToDocument(InputStream in) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String s = null;
            while ((s = reader.readLine()) != null) {
                this.writer.write(s);
            }
            this.writer.flush();
        }
        catch (IOException e) {
            Activator.handleError(e);
        }
    }

    public void addToDocument(String line) {
        this.writer.write(line);
        this.writer.flush();
    }

    public OMElement createXUL() {
        try {
            if (this.writer.getBuffer().length() > 0) {
                return StringToOM.getOMElement((String)this.writer.getBuffer().toString());
            }
        }
        catch (XMLStreamException e) {
            Activator.handleError(e);
        }
        catch (UnsupportedEncodingException e) {
            Activator.handleError(e);
        }
        catch (FactoryConfigurationError e) {
            Activator.handleError(e);
        }
        return null;
    }
}

