/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search.ui.newsearch;

import info.textgrid.lab.search.ui.newsearch.BaselineEncodingMainAreaLine;
import info.textgrid.lab.search.ui.newsearch.Messages;
import java.util.ArrayList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BaselineEncodingMainArea {
    private Composite comMainArea;
    private ScrolledComposite scrolledComposite;
    private ArrayList<BaselineEncodingMainAreaLine> baselineEncodingMainAreaLines = new ArrayList();
    private ArrayList<Label> baselineEncodingMainAreaLabels = new ArrayList();

    public BaselineEncodingMainArea(Composite comMainAra, ScrolledComposite scrolledComposite) {
        this.comMainArea = comMainAra;
        this.scrolledComposite = scrolledComposite;
        this.baselineEncodingMainAreaLines.add(this.addControlLine(true));
        this.baselineEncodingMainAreaLabels.add(this.addLabelLine());
        this.baselineEncodingMainAreaLines.add(this.addControlLine(false));
        this.setRemoveIconsVisible(false);
    }

    private BaselineEncodingMainAreaLine addControlLine(Boolean firstLine) {
        Composite composite = new Composite(this.comMainArea, 0);
        return new BaselineEncodingMainAreaLine(this, composite, this.scrolledComposite, firstLine);
    }

    private Label addLabelLine() {
        Composite composite = new Composite(this.comMainArea, 0);
        RowLayout rl = new RowLayout();
        rl.marginLeft = 10;
        composite.setLayout((Layout)rl);
        Label label = new Label(composite, 0);
        label.setText(Messages.BaselineEncodingMainArea_AndLabel);
        return label;
    }

    public BaselineEncodingMainAreaLine addLine() {
        if (this.baselineEncodingMainAreaLines.size() == 2) {
            this.setRemoveIconsVisible(true);
        }
        this.baselineEncodingMainAreaLabels.add(this.addLabelLine());
        BaselineEncodingMainAreaLine newLine = this.addControlLine(false);
        this.baselineEncodingMainAreaLines.add(newLine);
        return newLine;
    }

    public void removeLine(BaselineEncodingMainAreaLine line) {
        if (this.baselineEncodingMainAreaLines.size() <= 2) {
            return;
        }
        int index = this.baselineEncodingMainAreaLines.indexOf(line);
        this.baselineEncodingMainAreaLines.remove(line);
        line.getMainComposite().dispose();
        if (index != -1) {
            if (index <= this.baselineEncodingMainAreaLabels.size() - 1) {
                Label label = this.baselineEncodingMainAreaLabels.get(index);
                label.getParent().dispose();
                this.baselineEncodingMainAreaLabels.remove(index);
            } else {
                Label label = this.baselineEncodingMainAreaLabels.get(this.baselineEncodingMainAreaLabels.size() - 1);
                label.getParent().dispose();
                this.baselineEncodingMainAreaLabels.remove(this.baselineEncodingMainAreaLabels.size() - 1);
            }
        }
        this.comMainArea.layout();
        this.scrolledComposite.setMinSize(this.scrolledComposite.getContent().computeSize(-1, -1));
        if (this.baselineEncodingMainAreaLines.size() == 2) {
            this.setRemoveIconsVisible(false);
        }
    }

    public BaselineEncodingMainAreaLine getNextLine(BaselineEncodingMainAreaLine line) {
        int index = this.baselineEncodingMainAreaLines.indexOf(line);
        if (index != -1) {
            try {
                return this.baselineEncodingMainAreaLines.get(index + 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
        return null;
    }

    public Boolean isFirstLine(BaselineEncodingMainAreaLine line) {
        int index = this.baselineEncodingMainAreaLines.indexOf(line);
        if (index == 1) {
            return true;
        }
        return false;
    }

    private void setRemoveIconsVisible(Boolean state) {
        for (BaselineEncodingMainAreaLine line : this.baselineEncodingMainAreaLines) {
            line.getDeleteImage().setVisible(state.booleanValue());
        }
    }

    public String getBaselineEncodingMainSearchString() {
        String metadataString = "";
        String elementString = "";
        boolean setAND = false;
        for (BaselineEncodingMainAreaLine line : this.baselineEncodingMainAreaLines) {
            elementString = line.getElementText().getText().trim().toLowerCase();
            if (elementString.equals("")) continue;
            boolean firstRun = true;
            for (Text text : line.getTextList()) {
                if (text.getText().trim().equals("")) continue;
                if (setAND && firstRun) {
                    metadataString = String.valueOf(metadataString) + "AND ";
                }
                if (!firstRun) {
                    metadataString = String.valueOf(metadataString) + "OR ";
                }
                metadataString = String.valueOf(metadataString) + elementString + ":\"" + text.getText().trim() + "\" ";
                firstRun = false;
            }
            setAND = true;
        }
        return metadataString;
    }
}

