/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.tools.util.SOAPBindingUtil;
import org.apache.cxf.tools.validator.internal.AbstractDefinitionValidator;

public class MIMEBindingValidator
extends AbstractDefinitionValidator {
    public MIMEBindingValidator(Definition def) {
        super(def);
    }

    public boolean isValid() {
        Collection<Binding> bindings = CastUtils.cast(this.def.getBindings().values());
        for (Binding binding : bindings) {
            for (BindingOperation bindingOperation : binding.getBindingOperations()) {
                if (bindingOperation.getBindingInput() == null) continue;
                for (ExtensibilityElement extElement : bindingOperation.getBindingInput().getExtensibilityElements()) {
                    Iterator itMimeParts;
                    if (!(extElement instanceof MIMEMultipartRelated) || this.doValidate(itMimeParts = ((MIMEMultipartRelated)extElement).getMIMEParts().iterator(), bindingOperation.getName())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean doValidate(Iterator mimeParts, String operationName) {
        boolean gotRootPart = false;
        while (mimeParts.hasNext()) {
            MIMEPart mPart = (MIMEPart)mimeParts.next();
            ArrayList<MIMEContent> mimeContents = new ArrayList<MIMEContent>();
            for (ExtensibilityElement extElement : mPart.getExtensibilityElements()) {
                if (SOAPBindingUtil.isSOAPBody(extElement)) {
                    if (gotRootPart) {
                        this.addErrorMessage("Operation(" + operationName + "): There's more than one soap body mime part" + " in its binding input");
                        return false;
                    }
                    gotRootPart = true;
                    continue;
                }
                if (!(extElement instanceof MIMEContent)) continue;
                mimeContents.add((MIMEContent)extElement);
            }
            if (this.doValidateMimeContentPartNames(mimeContents.iterator(), operationName)) continue;
            return false;
        }
        if (!gotRootPart) {
            this.addErrorMessage("Operation(" + operationName + "): There's no soap body in mime part" + " in its binding input");
            return false;
        }
        return true;
    }

    private boolean doValidateMimeContentPartNames(Iterator mimeContents, String operationName) {
        String partName = null;
        while (mimeContents.hasNext()) {
            MIMEContent mimeContent = (MIMEContent)mimeContents.next();
            String mimeContnetPart = mimeContent.getPart();
            if (mimeContnetPart == null) {
                this.addErrorMessage("Operation(" + operationName + "): Must provide part attribute value for meme:content elements");
                return false;
            }
            if (partName == null) {
                partName = mimeContnetPart;
                continue;
            }
            if (partName.equals(mimeContnetPart)) continue;
            this.addErrorMessage("Operation(" + operationName + "): Part attribute value for meme:content " + "elements are different");
            return false;
        }
        return true;
    }
}

