/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.mpeditor;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;

public class LabErrorListener
implements ErrorListener {
    private List<TransformerException> exceptions = Collections.synchronizedList(new LinkedList());

    @Override
    public void warning(TransformerException exception) throws TransformerException {
        this.exceptions.add(exception);
        StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.xmleditor.mpeditor", exception.getMessageAndLocation(), (Throwable)exception));
    }

    @Override
    public void error(TransformerException exception) throws TransformerException {
        this.exceptions.add(exception);
        StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.xmleditor.mpeditor", exception.getMessageAndLocation(), (Throwable)exception));
    }

    @Override
    public void fatalError(TransformerException exception) throws TransformerException {
        this.exceptions.add(exception);
        StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.xmleditor.mpeditor", exception.getMessageAndLocation(), (Throwable)exception));
        throw exception;
    }

    public synchronized String toHTML() {
        if (this.exceptions.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder("<ul>");
        for (TransformerException e : this.exceptions) {
            builder.append("<li>");
            if (e.getLocator() != null) {
                builder.append("<a href=\"");
                builder.append(e.getLocator().getSystemId());
                builder.append("\">");
            }
            builder.append(e.getMessageAndLocation());
            if (e.getLocator() != null) {
                builder.append("</a>");
            }
            builder.append("</li>\n");
        }
        builder.append("</ul>\n");
        return builder.toString();
    }
}

