/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.mpeditor;

import info.textgrid.lab.xmleditor.mpeditor.LabErrorListener;
import info.textgrid.lab.xmleditor.mpeditor.Messages;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class PreviewPage
extends Composite {
    private final Browser browser;

    public PreviewPage(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.browser = new Browser((Composite)this, 0);
        this.browser.setText(Messages.PreviewPage_Loading);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    protected void checkSubclass() {
    }

    public void setDocument(final IDocument document) {
        if (this.browser != null && !this.browser.isDisposed()) {
            new Job(Messages.PreviewPage_Updating){

                protected IStatus run(IProgressMonitor monitor) {
                    TransformerFactory factory;
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    try {
                        factory = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
                    }
                    catch (TransformerFactoryConfigurationError e) {
                        StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.xmleditor.mpeditor", "Could not instantiate saxon: XSLT support is limited to XSLT 1.0", (Throwable)e));
                        factory = TransformerFactory.newInstance();
                    }
                    LabErrorListener errorListener = new LabErrorListener();
                    factory.setErrorListener(errorListener);
                    progress.worked(5);
                    String doc = document.get();
                    try {
                        StringReader anaReader = new StringReader(doc);
                        StreamSource anaSource = new StreamSource(anaReader);
                        Source stylesheet = factory.getAssociatedStylesheet(anaSource, null, null, null);
                        if (stylesheet == null) {
                            PreviewPage.this.showUsageMessage(Messages.PreviewPage_NoStylesheetAssociated, Messages.PreviewPage_NoStylesheetHTML);
                            return Status.CANCEL_STATUS;
                        }
                        progress.worked(10);
                        Transformer transformer = factory.newTransformer(stylesheet);
                        progress.worked(30);
                        StringReader reader = new StringReader(doc);
                        StreamSource source = new StreamSource(reader);
                        StringWriter writer = new StringWriter();
                        StreamResult result = new StreamResult(writer);
                        progress.worked(10);
                        transformer.transform(source, result);
                        progress.worked(45);
                        PreviewPage.this.setText(writer.toString());
                        progress.worked(5);
                        progress.done();
                    }
                    catch (TransformerConfigurationException e) {
                        return PreviewPage.this.handleException(e, errorListener);
                    }
                    catch (TransformerException e) {
                        return PreviewPage.this.handleException(e, errorListener);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void showUsageMessage(String title, String body) {
        String message = Messages.PreviewPage_UsageMessageHTML;
        this.setText(NLS.bind((String)message, (Object)title, (Object)body));
    }

    private IStatus handleException(Throwable e, LabErrorListener errorListener) {
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        e.printStackTrace(printer);
        this.showUsageMessage(e.getClass().getSimpleName(), MessageFormat.format(Messages.PreviewPage_ErrorDetailsHTML, e.getLocalizedMessage(), e.getCause() == null ? Messages.PreviewPage_NoCause : e.getCause().getLocalizedMessage(), errorListener == null ? Messages.PreviewPage_NoCause : errorListener.toHTML(), writer.toString()));
        Status status = new Status(4, "info.textgrid.lab.xmleditor.mpeditor", e.getLocalizedMessage(), e);
        StatusManager.getManager().handle((IStatus)status);
        return status;
    }

    public void setText(final String text) {
        new UIJob(Messages.PreviewPage_UpdatingBrowser){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (PreviewPage.this.browser != null && !PreviewPage.this.browser.isDisposed()) {
                    PreviewPage.this.browser.setText(text, true);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

