/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.relaxng.provisional;

import com.thaiopensource.relaxng.translate.Driver;
import info.textgrid._import.RewriteMethod;
import info.textgrid.lab.core.importexport.model.AbstractImportEntryConfigurator;
import info.textgrid.lab.core.importexport.model.IImportEntryConfigurator;
import info.textgrid.lab.core.importexport.model.ISpecialImportEntrySupplier;
import info.textgrid.lab.core.importexport.model.ImportEntry;
import info.textgrid.lab.core.importexport.model.RewriteSetup;
import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.xmleditor.relaxng.provisional.ConvertedXSDSupplier;
import info.textgrid.lab.xmleditor.relaxng.provisional.Messages;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

public class ImportRNGConfigurator
extends AbstractImportEntryConfigurator
implements IImportEntryConfigurator {
    public void configureImport(ImportEntry entry, IProgressMonitor monitor) {
        if (FilenameUtils.isExtension((String)entry.getLocalData(), (String[])new String[]{"rng", "rnc"})) {
            if (this.ask(NLS.bind((String)Messages.ImportRNGConfigurator_Importing_X, (Object)entry.getLocalData()), NLS.bind((String)Messages.ImportRNGConfigurator_RNG_Not_Supported, (Object)entry.getLocalData()), 1, new String[]{Messages.ImportRNGConfigurator_Leave_as_is, Messages.ImportRNGConfigurator_Convert}) == 1) {
                try {
                    File xsdFile = File.createTempFile("textgridlab", ".xsd");
                    Driver trang = new Driver();
                    trang.run(new String[]{"-O", "xsd", entry.getLocalFile().getAbsolutePath(), xsdFile.getAbsolutePath()});
                    xsdFile.deleteOnExit();
                    entry.getObject().setContentType(TGContentType.of((String)"text/xsd+xml"));
                    entry.setSupplier((ISpecialImportEntrySupplier)new ConvertedXSDSupplier(entry.getLocalFile(), xsdFile));
                    entry.setRewriteSetup(RewriteSetup.of((RewriteMethod)RewriteMethod.XML, (String)"internal:schema#xsd"));
                }
                catch (IOException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.xmleditor.relaxng.provisional", NLS.bind((String)Messages.ImportRNGConfigurator_Failed_to_convert, (Object)entry.getLocalData()), (Throwable)e));
                }
            } else if (FilenameUtils.isExtension((String)entry.getLocalData(), (String)"rnc")) {
                entry.getObject().setContentType(TGContentType.of((String)"application/relax-ng-compact-syntax"));
            } else {
                entry.getObject().setContentType(TGContentType.of((String)"text/xml"));
            }
        }
    }
}

