/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.log.logsession;
import info.textgrid.lab.workflow.Chain;
import info.textgrid.lab.workflow.ChainEntry;
import info.textgrid.lab.workflow.EntryLink;
import info.textgrid.lab.workflow.MetadataTransformer;
import info.textgrid.lab.workflow.servicedescription.Configparameter;
import info.textgrid.lab.workflow.servicedescription.Examplevalue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kwfgrid.gworkflowdl.structure.ArrayListProperties;
import net.kwfgrid.gworkflowdl.structure.CapacityException;
import net.kwfgrid.gworkflowdl.structure.Data;
import net.kwfgrid.gworkflowdl.structure.Edge;
import net.kwfgrid.gworkflowdl.structure.Factory;
import net.kwfgrid.gworkflowdl.structure.GenericProperties;
import net.kwfgrid.gworkflowdl.structure.JdomString;
import net.kwfgrid.gworkflowdl.structure.Operation;
import net.kwfgrid.gworkflowdl.structure.OperationCandidate;
import net.kwfgrid.gworkflowdl.structure.OperationClass;
import net.kwfgrid.gworkflowdl.structure.Place;
import net.kwfgrid.gworkflowdl.structure.Token;
import net.kwfgrid.gworkflowdl.structure.Transition;
import net.kwfgrid.gworkflowdl.structure.Workflow;
import net.kwfgrid.gworkflowdl.structure.WorkflowFormatException;
import org.apache.axiom.om.util.Base64;

public class ChainGWDL {
    Workflow w;
    Chain c;
    Place sidReadPlace = null;
    Place logReadPlace = null;
    String crudEpr = "";
    String streamingEditorEpr = "";
    public static final HashMap<String, String> wsTypeMap = new HashMap();

    static {
        wsTypeMap.put("soap", "soap");
        wsTypeMap.put("rest", "XXXunimplementedXXX");
    }

    public ChainGWDL(Chain c) {
        this.c = c;
        this.w = Factory.newWorkflow();
        this.w.setProperties((GenericProperties)new ArrayListProperties());
        this.w.getProperties().put("redistributionOfFailedActivities", "false");
        this.w.getProperties().put("occurrence.sequence", "");
        StringBuffer automaticDescription = new StringBuffer();
        for (ChainEntry ce : c.getChain()) {
            automaticDescription.append(ce.getName()).append(" and ");
            Transition t = this.constructTransition(ce);
            this.w.addTransition(t);
            for (Configparameter cp : ce.getConfigParameters()) {
                ArrayList<Place> configPlaces = this.constructPlacesWithConfigDataToken(ce, cp);
                for (Place p : configPlaces) {
                    this.w.addPlace(p);
                    Edge e = Factory.newEdge();
                    if (ce.getTns() == null) {
                        e.setExpression(cp.getParam());
                    } else {
                        e.setExpression("tns:" + cp.getParam());
                    }
                    e.setPlace(p);
                    t.addReadEdge(e);
                }
            }
        }
        if (c.getDescription().length() > 0) {
            this.w.setDescription(c.getDescription());
        } else {
            int tmp = automaticDescription.length();
            automaticDescription.delete(tmp - 5, tmp);
            this.w.setDescription(automaticDescription.toString());
        }
        int placecount = 0;
        for (EntryLink l : c.getLinks()) {
            if (l.isDeleted().booleanValue() || l.isUndecided()) continue;
            this.addPlaceAndEdge(l, ++placecount);
        }
    }

    public void addPlaceAndEdge(EntryLink l, int placecount) {
        Edge e;
        Place p = Factory.newPlace();
        p.setID("placeid" + Integer.toString(placecount));
        p.setProperties((GenericProperties)new ArrayListProperties());
        if (l.getFrom() != null && l.getFromPort() != null) {
            p.getProperties().put("FromTransition", ChainGWDL.getTransID(l.getFrom()));
            p.getProperties().put("FromPort", l.getFromPort().getParam());
            p.getProperties().put("FromPortMultiple", Boolean.toString(l.getFromPort().isMultiple()));
            p.getProperties().put("FromPortCRUD", Boolean.toString(l.getFromPort().isCrud()));
            Transition source = this.w.getTransition(ChainGWDL.getTransID(l.getFrom()));
            e = Factory.newEdge();
            if (l.getFrom().getTns() == null) {
                e.setExpression("$" + l.getFromPort().getParam());
            } else {
                e.setExpression("$tns:" + l.getFromPort().getParam());
            }
            e.setPlace(p);
            source.addOutEdge(e);
        } else {
            p.getProperties().put("FromPortCRUD", "true");
            p.getProperties().put("Input", String.valueOf(ChainGWDL.getTransID(l.getTo())) + "@" + l.getToPort().getParam());
        }
        if (l.getTo() != null && l.getToPort() != null) {
            p.getProperties().put("ToTransition", ChainGWDL.getTransID(l.getTo()));
            p.getProperties().put("ToPort", l.getToPort().getParam());
            p.getProperties().put("ToPortMultiple", Boolean.toString(l.getToPort().isMultiple()));
            p.getProperties().put("ToPortCRUD", Boolean.toString(l.getToPort().isCrud()));
            Transition target = this.w.getTransition(ChainGWDL.getTransID(l.getTo()));
            e = Factory.newEdge();
            if (l.getTo().getTns() == null) {
                e.setExpression(l.getToPort().getParam());
            } else {
                e.setExpression("tns:" + l.getToPort().getParam());
            }
            e.setPlace(p);
            if (l.getToPort().isMultiple().booleanValue()) {
                target.addReadEdge(e);
            } else {
                target.addInEdge(e);
            }
        } else {
            p.getProperties().put("ToPortCRUD", "true");
            p.getProperties().put("Output", String.valueOf(ChainGWDL.getTransID(l.getFrom())) + "@" + l.getFromPort().getParam());
        }
        if (p.getProperties().get("Input") == null || p.getProperties().get("Output") == null) {
            this.w.addPlace(p);
        }
    }

    public ArrayList<Place> constructPlacesWithConfigDataToken(ChainEntry ce, Configparameter cp) {
        ArrayList<Examplevalue> exes = ce.getChosenConfigParamExampleValues(cp.getParam());
        ArrayList<Place> result = new ArrayList<Place>();
        int distinctPlaceIDcounter = 0;
        for (Examplevalue ex : exes) {
            ++distinctPlaceIDcounter;
            String dataString = ChainEntry.anyToString(ex.getContent());
            if ((cp.isNeedsB64Encoding().booleanValue() || cp.isCrud()) && ex.isInline()) {
                dataString = Base64.encode((byte[])dataString.getBytes());
            }
            Place p = ChainGWDL.constructDataTokenPlace("config--" + ChainGWDL.getTransID(ce) + "--" + cp.getParam() + distinctPlaceIDcounter, cp.getParam(), dataString);
            p.getProperties().put("ToTransition", ChainGWDL.getTransID(ce));
            p.getProperties().put("ConfigForParam", cp.getParam());
            p.getProperties().put("FromPortCRUD", Boolean.toString(!ex.isInline()));
            p.getProperties().put("ToPortCRUD", Boolean.toString(cp.isCrud()));
            result.add(p);
        }
        return result;
    }

    public Transition constructTransition(ChainEntry ce) {
        Transition t = Factory.newTransition();
        t.setID(ChainGWDL.getTransID(ce));
        if (ce.getTns() != null) {
            t.setProperties((GenericProperties)new ArrayListProperties());
            t.getProperties().put("xmlns:tns", ce.getTns());
        }
        Operation op = Factory.newOperation();
        t.setOperation(op);
        OperationClass oc = Factory.newOperationClass();
        oc.setName(ce.getOperationName());
        op.set(oc);
        OperationCandidate o = Factory.newOperationCandidate();
        o.setType(wsTypeMap.get(ce.getType()));
        o.setOperationName(ce.getOperationName());
        o.setResourceName(ce.getURL());
        o.setSelected(true);
        oc.addOperationCandidate(o);
        return t;
    }

    public ChainGWDL(TextGridObject tgo) {
    }

    public static String getTransID(ChainEntry ce) {
        return "n" + Integer.toString(ce.getID()) + "-" + ce.getOperationName();
    }

    public String marshal() {
        try {
            return JdomString.workflow2string((Workflow)this.w);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Sorry, there was some exception while marshalling";
        }
    }

    public static boolean checkForEqualNumbers(ArrayList<ArrayList<TextGridObject>> inputTGOs, ArrayList<EntryLink> inputLinks) {
        int previousNumberOfInputs = inputTGOs.get(0).size();
        int i = 1;
        while (i < inputLinks.size()) {
            if (inputLinks.get(i).getFrom() == null && inputLinks.get(i).getFromPort() == null && !inputLinks.get(i).getToPort().isMultiple().booleanValue() && inputTGOs.get(i).size() != previousNumberOfInputs) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void mergeInputObjects(ArrayList<ArrayList<TextGridObject>> inputTGOs, ArrayList<EntryLink> inputLinks) {
        Pattern extractChainLevel = Pattern.compile("n(\\d+)-.*");
        int index = 0;
        Place foundPlace = null;
        for (EntryLink l : inputLinks) {
            Place[] placeArray = this.w.getPlaces();
            int n = placeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Place cand = placeArray[n2];
                if (cand.getProperties().get("Input") != null && cand.getProperties().get("ToPort").equals(l.getToPort().getParam())) {
                    String toTransition = cand.getProperties().get("ToTransition");
                    Matcher mt = extractChainLevel.matcher(toTransition);
                    if (!mt.matches()) {
                        return;
                    }
                    int level = Integer.parseInt(mt.group(1));
                    if (level == l.getTo().getID()) {
                        foundPlace = cand;
                        break;
                    }
                }
                ++n2;
            }
            ArrayList<TextGridObject> thisBoxList = inputTGOs.get(index);
            Iterator<TextGridObject> issiter = thisBoxList.iterator();
            if (l.getToPort().isMultiple().booleanValue()) {
                String foundPlaceID = foundPlace.getID();
                Transition followingCrudRead = this.w.getTransition("crudRead-" + foundPlaceID);
                Place afterRead = null;
                Place beforeService = null;
                Transition followingService = this.w.getTransition(foundPlace.getProperties().get("ToTransition"));
                beforeService = followingCrudRead != null ? (afterRead = followingCrudRead.getOutEdge(String.valueOf(foundPlaceID) + "-afterRead").getPlace()) : foundPlace;
                int multicount = 0;
                while (issiter.hasNext()) {
                    TextGridObject oneInput = issiter.next();
                    String suffix = "multi" + Integer.toString(++multicount);
                    Place p = ChainGWDL.constructDataTokenPlace(String.valueOf(foundPlaceID) + suffix, "param", oneInput.getURI().toString());
                    this.w.addPlace(p);
                    if (followingCrudRead == null) {
                        Edge e = Factory.newEdge();
                        e.setExpression(followingService.getReadEdge(beforeService.getID()).getExpression());
                        e.setPlace(p);
                        followingService.addReadEdge(e);
                        continue;
                    }
                    Place q = Factory.newPlace();
                    q.setID(String.valueOf(afterRead.getID()) + suffix);
                    this.w.addPlace(q);
                    Transition t = Factory.newTransition();
                    t.setID(String.valueOf(followingCrudRead.getID()) + suffix);
                    Operation opX = Factory.newOperation();
                    t.setOperation(opX);
                    OperationClass ocX = Factory.newOperationClass();
                    ocX.setName("read");
                    opX.set(ocX);
                    OperationCandidate oX = Factory.newOperationCandidate();
                    oX.setType(wsTypeMap.get("soap"));
                    oX.setOperationName("read");
                    oX.setResourceName(this.crudEpr);
                    oX.setSelected(true);
                    ocX.addOperationCandidate(oX);
                    Edge sidEdge = Factory.newEdge();
                    sidEdge.setExpression("tns:sessionId");
                    sidEdge.setPlace(this.sidReadPlace);
                    t.addReadEdge(sidEdge);
                    Edge logEdge = Factory.newEdge();
                    logEdge.setExpression("tns:logParameter");
                    logEdge.setPlace(this.logReadPlace);
                    t.addReadEdge(logEdge);
                    Edge uriRead = Factory.newEdge();
                    uriRead.setExpression("tns:uri");
                    uriRead.setPlace(p);
                    t.addInEdge(uriRead);
                    Edge b64afterRead = Factory.newEdge();
                    b64afterRead.setExpression("$tns:data");
                    b64afterRead.setPlace(q);
                    t.addOutEdge(b64afterRead);
                    this.w.addTransition(t);
                    Edge e = Factory.newEdge();
                    e.setExpression(followingService.getReadEdge(beforeService.getID()).getExpression());
                    e.setPlace(q);
                    followingService.addReadEdge(e);
                }
                followingService.removeReadEdge(beforeService.getID());
                String[] numberedPlaces = this.w.getPlaceIDs();
                int i = 0;
                while (i < numberedPlaces.length) {
                    if (numberedPlaces[i].equals(foundPlace.getID())) {
                        this.w.removePlace(i);
                    }
                    ++i;
                }
                if (followingCrudRead != null) {
                    String[] numberedTransitions = this.w.getTransitionIDs();
                    int i2 = 0;
                    while (i2 < numberedTransitions.length) {
                        if (numberedTransitions[i2].equals(followingCrudRead.getID())) {
                            this.w.removeTransition(i2);
                        }
                        ++i2;
                    }
                    numberedPlaces = this.w.getPlaceIDs();
                    i2 = 0;
                    while (i2 < numberedPlaces.length) {
                        if (numberedPlaces[i2].equals(afterRead.getID())) {
                            this.w.removePlace(i2);
                        }
                        ++i2;
                    }
                    Place afterReadMD = followingCrudRead.getOutEdge(String.valueOf(foundPlaceID) + "-afterReadMD").getPlace();
                    numberedPlaces = this.w.getPlaceIDs();
                    int i3 = 0;
                    while (i3 < numberedPlaces.length) {
                        if (numberedPlaces[i3].equals(afterReadMD.getID())) {
                            this.w.removePlace(i3);
                        }
                        ++i3;
                    }
                }
            } else {
                int groupIndex = 0;
                while (issiter.hasNext()) {
                    TextGridObject oneInput = issiter.next();
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("<data><param>").append(oneInput.getURI().toString()).append("</param></data>");
                    Data data = Factory.newData();
                    try {
                        data.fromXML(buffer.toString());
                    }
                    catch (WorkflowFormatException e) {
                        e.printStackTrace();
                    }
                    Token t = Factory.newToken((Data)data);
                    t.getProperties().put("data.group", "UriNumber" + groupIndex);
                    try {
                        foundPlace.addToken(t);
                    }
                    catch (CapacityException e) {
                        e.printStackTrace();
                    }
                    ++groupIndex;
                }
            }
            ++index;
        }
    }

    public void connectMetadata() {
        ArrayList<Place> mdProviders = new ArrayList<Place>();
        ArrayList<Place> mdConsumers = new ArrayList<Place>();
        try {
            ConfClient confClient = ConfClient.getInstance();
            this.streamingEditorEpr = confClient.getValue("StreamingEditor");
        }
        catch (OfflineException e) {
            OnlineStatus.netAccessFailed((String)"Could not contact Confserv", (Throwable)e);
        }
        Place[] placeArray = this.w.getPlaces();
        int n = placeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Place p = placeArray[n2];
            if (p.getProperties().get("MetadataFrom") != null && !p.getProperties().get("MetadataFrom").equals("unknown")) {
                mdProviders.add(p);
            }
            if (p.getProperties().get("MetadataFor") != null) {
                mdConsumers.add(p);
            }
            ++n2;
        }
        Pattern extractChainLevel = Pattern.compile("n(\\d+)-.*");
        Pattern extractParam = Pattern.compile("[^@]+@(\\S+)");
        Iterator nextProviderIterator = mdProviders.iterator();
        int seIDcount = 0;
        for (Place consumer : mdConsumers) {
            MetadataTransformer foundmdt;
            Place possibleProvider;
            String consumerId = consumer.getProperties().get("MetadataConsumer");
            Matcher mc = extractChainLevel.matcher(consumerId);
            if (!mc.matches()) {
                return;
            }
            int consumerLevel = Integer.parseInt(mc.group(1));
            String metadataForPhrase = consumer.getProperties().get("MetadataFor");
            Matcher mfor = extractParam.matcher(metadataForPhrase);
            if (!mfor.matches()) {
                return;
            }
            String consumerParam = mfor.group(1);
            int triedAllProviders = 0;
            while (true) {
                if (!nextProviderIterator.hasNext()) {
                    nextProviderIterator = mdProviders.iterator();
                }
                possibleProvider = (Place)nextProviderIterator.next();
                ++triedAllProviders;
                String providerId = possibleProvider.getProperties().get("MetadataProvider");
                Matcher mp = extractChainLevel.matcher(providerId);
                if (!mp.matches()) {
                    return;
                }
                int providerLevel = Integer.parseInt(mp.group(1));
                String metadataFromPhrase = possibleProvider.getProperties().get("MetadataFrom");
                Matcher mfrom = extractParam.matcher(metadataFromPhrase);
                if (!mfrom.matches()) {
                    return;
                }
                String providerParam = mfrom.group(1);
                if (providerLevel > consumerLevel) continue;
                boolean foundInTransformers = false;
                foundmdt = null;
                for (MetadataTransformer mdt : this.c.getTransformers()) {
                    if (mdt.getOutput().getFrom().getID() != consumerLevel || !mdt.getOutput().getFromPort().getParam().equals(consumerParam) || mdt.getFromInput().getTo().getID() != providerLevel || !mdt.getFromInput().getToPort().getParam().equals(providerParam)) continue;
                    foundmdt = mdt;
                    foundInTransformers = true;
                    break;
                }
                if (foundInTransformers || triedAllProviders >= mdProviders.size()) break;
            }
            triedAllProviders = 0;
            ++seIDcount;
            String stylesheetUri = MetadataTransformer.DEFAULT_STYLESHEET_URI;
            if (foundmdt != null) {
                stylesheetUri = foundmdt.getStylesheet().getURI().toString();
            }
            Place xslURI = ChainGWDL.constructDataTokenPlace("xslURIforSE-" + seIDcount, "param", stylesheetUri);
            Place xslB64 = Factory.newPlace();
            xslB64.setID("xslB64forSE-" + seIDcount);
            Transition readXSL = Factory.newTransition();
            readXSL.setID("XSLreaderForSE-" + seIDcount);
            Operation opX = Factory.newOperation();
            readXSL.setOperation(opX);
            OperationClass ocX = Factory.newOperationClass();
            ocX.setName("read");
            opX.set(ocX);
            OperationCandidate oX = Factory.newOperationCandidate();
            oX.setType(wsTypeMap.get("soap"));
            oX.setOperationName("read");
            oX.setResourceName(this.crudEpr);
            oX.setSelected(true);
            ocX.addOperationCandidate(oX);
            Edge sidEdge = Factory.newEdge();
            sidEdge.setExpression("tns:sessionId");
            sidEdge.setPlace(this.sidReadPlace);
            readXSL.addReadEdge(sidEdge);
            Edge logEdge = Factory.newEdge();
            logEdge.setExpression("tns:logParameter");
            logEdge.setPlace(this.logReadPlace);
            readXSL.addReadEdge(logEdge);
            Edge xslUriRead = Factory.newEdge();
            xslUriRead.setExpression("tns:uri");
            xslUriRead.setPlace(xslURI);
            readXSL.addInEdge(xslUriRead);
            Edge b64afterRead = Factory.newEdge();
            b64afterRead.setExpression("$tns:tgObjectData");
            b64afterRead.setPlace(xslB64);
            readXSL.addOutEdge(b64afterRead);
            Transition mdTrans = Factory.newTransition();
            mdTrans.setID("SE-" + seIDcount);
            Operation op = Factory.newOperation();
            mdTrans.setOperation(op);
            OperationClass oc = Factory.newOperationClass();
            oc.setName("sedit");
            op.set(oc);
            OperationCandidate o = Factory.newOperationCandidate();
            o.setType(wsTypeMap.get("soap"));
            o.setOperationName("transformInline");
            o.setResourceName(this.streamingEditorEpr);
            o.setSelected(true);
            oc.addOperationCandidate(o);
            if (foundmdt != null) {
                StringBuffer paramStruct = new StringBuffer();
                boolean tg1109isfixed = true;
                if (tg1109isfixed) {
                    for (String key : foundmdt.getParams().keySet()) {
                        paramStruct.append("<param><name>").append(key).append("</name><value>").append(foundmdt.getParams().get(key)).append("</value></param>");
                    }
                }
                Place paramsPlace = ChainGWDL.constructDataTokenPlace("ParamsForSE-" + seIDcount, "param", paramStruct.toString());
                this.w.addPlace(paramsPlace);
                Edge paramEdge = Factory.newEdge();
                paramEdge.setExpression("params");
                paramEdge.setPlace(paramsPlace);
                mdTrans.addReadEdge(paramEdge);
            }
            Edge xslEdge = Factory.newEdge();
            xslEdge.setExpression("stylesheet");
            xslEdge.setPlace(xslB64);
            mdTrans.addReadEdge(xslEdge);
            Edge inEdge = Factory.newEdge();
            inEdge.setExpression("input");
            inEdge.setPlace(possibleProvider);
            mdTrans.addInEdge(inEdge);
            Edge siddEdge = Factory.newEdge();
            siddEdge.setExpression("session");
            siddEdge.setPlace(this.sidReadPlace);
            mdTrans.addReadEdge(siddEdge);
            Edge loggEdge = Factory.newEdge();
            loggEdge.setExpression("loginfo");
            loggEdge.setPlace(this.logReadPlace);
            mdTrans.addReadEdge(loggEdge);
            Edge outEdge = Factory.newEdge();
            outEdge.setExpression("$result");
            outEdge.setPlace(consumer);
            mdTrans.addOutEdge(outEdge);
            this.w.addPlace(xslB64);
            this.w.addPlace(xslURI);
            this.w.addTransition(readXSL);
            this.w.addTransition(mdTrans);
        }
    }

    public boolean insertCrudTransitions(String targetProject) {
        Place targetProjectReadPlace = null;
        if (!targetProject.equals("")) {
            targetProjectReadPlace = ChainGWDL.constructDataTokenPlace("targetProject", "param", targetProject);
            this.w.addPlace(targetProjectReadPlace);
        }
        this.sidReadPlace = ChainGWDL.constructDataTokenPlace("crud-sessionId", "param", RBACSession.getInstance().getSID(false));
        this.logReadPlace = ChainGWDL.constructDataTokenPlace("crud-logParameter", "param", logsession.getInstance().getloginfo());
        this.w.addPlace(this.sidReadPlace);
        this.w.addPlace(this.logReadPlace);
        Place emptyRevison = null;
        Place emptyURI = null;
        if (targetProjectReadPlace != null && targetProject.length() > 0) {
            emptyRevison = ChainGWDL.constructDataTokenPlace("emptyRevision", "param", "");
            emptyURI = ChainGWDL.constructDataTokenPlace("emptyURI", "param", "");
            this.w.addPlace(emptyRevison);
            this.w.addPlace(emptyURI);
        }
        try {
            ConfClient confClient = ConfClient.getInstance();
            this.crudEpr = String.valueOf(confClient.getValue("tgcrud")) + "?wsdl";
        }
        catch (OfflineException e) {
            OnlineStatus.netAccessFailed((String)"Could not contact Confserv", (Throwable)e);
        }
        Place[] placeArray = this.w.getPlaces();
        int n = placeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Place p = placeArray[n2];
            String precedingProducesURIString = p.getProperties().get("FromPortCRUD");
            String followingConsumesURIString = p.getProperties().get("ToPortCRUD");
            if (precedingProducesURIString != null && followingConsumesURIString != null) {
                boolean precedingProducesURI = Boolean.parseBoolean(precedingProducesURIString);
                boolean followingConsumesURI = Boolean.parseBoolean(followingConsumesURIString);
                if (precedingProducesURI && !followingConsumesURI) {
                    this.insertCrudRead(p);
                } else if (!precedingProducesURI && followingConsumesURI) {
                    if (targetProjectReadPlace == null || targetProject.length() < 1) {
                        if (p.getProperties().get("Output") != null) {
                            Place metadataForCreate = Factory.newPlace();
                            metadataForCreate.setID(String.valueOf(p.getID()) + "-mdbeforeCreate");
                            metadataForCreate.setProperties((GenericProperties)new ArrayListProperties());
                            String metadataFor = "Output:" + p.getProperties().get("Output");
                            metadataForCreate.getProperties().put("MetadataFor", metadataFor);
                            Transition source = this.w.getTransition(p.getProperties().get("FromTransition"));
                            metadataForCreate.getProperties().put("MetadataConsumer", source.getID());
                            this.w.addPlace(metadataForCreate);
                        }
                    } else {
                        this.insertCrudCreate(p, emptyRevison, emptyURI, targetProjectReadPlace);
                    }
                }
            }
            ++n2;
        }
        return true;
    }

    public boolean insertCrudRead(Place p) {
        boolean isReadEdge;
        String originalExpression;
        Transition crudRead = Factory.newTransition();
        crudRead.setID("crudRead-" + p.getID());
        Operation op = Factory.newOperation();
        crudRead.setOperation(op);
        OperationClass oc = Factory.newOperationClass();
        oc.setName("read");
        op.set(oc);
        OperationCandidate o = Factory.newOperationCandidate();
        o.setType(wsTypeMap.get("soap"));
        o.setOperationName("read");
        o.setResourceName(this.crudEpr);
        o.setSelected(true);
        oc.addOperationCandidate(o);
        Edge sidEdge = Factory.newEdge();
        sidEdge.setExpression("tns:sessionId");
        sidEdge.setPlace(this.sidReadPlace);
        crudRead.addReadEdge(sidEdge);
        Edge logEdge = Factory.newEdge();
        logEdge.setExpression("tns:logParameter");
        logEdge.setPlace(this.logReadPlace);
        crudRead.addReadEdge(logEdge);
        Place afterRead = Factory.newPlace();
        afterRead.setID(String.valueOf(p.getID()) + "-afterRead");
        Place afterReadMD = Factory.newPlace();
        afterReadMD.setID(String.valueOf(p.getID()) + "-afterReadMD");
        String metadataFrom = p.getProperties().get("Input") != null ? "Input:" + p.getProperties().get("Input") : (p.getProperties().get("FromTransition") != null ? "Transition:" + p.getProperties().get("FromTransition") + "@" + p.getProperties().get("FromPort") : "unknown");
        afterReadMD.setProperties((GenericProperties)new ArrayListProperties());
        afterReadMD.getProperties().put("MetadataFrom", metadataFrom);
        Transition target = this.w.getTransition(p.getProperties().get("ToTransition"));
        afterReadMD.getProperties().put("MetadataProvider", target.getID());
        if (target.getInEdge(p.getID()) != null) {
            originalExpression = target.getInEdge(p.getID()).getExpression();
            target.removeInEdge(p.getID());
            isReadEdge = false;
        } else if (target.getReadEdge(p.getID()) != null) {
            originalExpression = target.getReadEdge(p.getID()).getExpression();
            target.removeReadEdge(p.getID());
            isReadEdge = true;
        } else {
            return false;
        }
        Edge uri2CrudRead = Factory.newEdge();
        uri2CrudRead.setExpression("tns:uri");
        uri2CrudRead.setPlace(p);
        crudRead.addInEdge(uri2CrudRead);
        Edge crudRead2Data = Factory.newEdge();
        crudRead2Data.setExpression("$tns:tgObjectData");
        crudRead2Data.setPlace(afterRead);
        crudRead.addOutEdge(crudRead2Data);
        Edge crudRead2MD = Factory.newEdge();
        crudRead2MD.setExpression("$tns:tgObjectMetadata");
        crudRead2MD.setPlace(afterReadMD);
        crudRead.addOutEdge(crudRead2MD);
        Edge data2target = Factory.newEdge();
        data2target.setExpression(originalExpression);
        data2target.setPlace(afterRead);
        if (isReadEdge) {
            target.addReadEdge(data2target);
        } else {
            target.addInEdge(data2target);
        }
        this.w.addPlace(afterRead);
        this.w.addPlace(afterReadMD);
        this.w.addTransition(crudRead);
        return true;
    }

    public boolean insertCrudCreate(Place p, Place emptyRevision, Place emptyURI, Place targetProjectReadPlace) {
        Transition crudCreate = Factory.newTransition();
        crudCreate.setID("crudCreate-" + p.getID());
        Operation op = Factory.newOperation();
        crudCreate.setOperation(op);
        OperationClass oc = Factory.newOperationClass();
        oc.setName("create");
        op.set(oc);
        OperationCandidate o = Factory.newOperationCandidate();
        o.setType(wsTypeMap.get("soap"));
        o.setOperationName("create");
        o.setResourceName(this.crudEpr);
        o.setSelected(true);
        oc.addOperationCandidate(o);
        Edge sidEdge = Factory.newEdge();
        sidEdge.setExpression("tns:sessionId");
        sidEdge.setPlace(this.sidReadPlace);
        crudCreate.addReadEdge(sidEdge);
        Edge logEdge = Factory.newEdge();
        logEdge.setExpression("tns:logParameter");
        logEdge.setPlace(this.logReadPlace);
        crudCreate.addReadEdge(logEdge);
        Edge fromTargetProject = Factory.newEdge();
        fromTargetProject.setExpression("tns:projectId");
        fromTargetProject.setPlace(targetProjectReadPlace);
        crudCreate.addReadEdge(fromTargetProject);
        Edge emptyURIEdge = Factory.newEdge();
        emptyURIEdge.setExpression("tns:uri");
        emptyURIEdge.setPlace(emptyURI);
        crudCreate.addReadEdge(emptyURIEdge);
        Edge emptyRevisionEdge = Factory.newEdge();
        emptyRevisionEdge.setExpression("tns:createRevision");
        emptyRevisionEdge.setPlace(emptyRevision);
        crudCreate.addReadEdge(emptyRevisionEdge);
        Place dataForCreate = Factory.newPlace();
        dataForCreate.setID(String.valueOf(p.getID()) + "-beforeCreate");
        Place metadataForCreate = Factory.newPlace();
        metadataForCreate.setID(String.valueOf(p.getID()) + "-mdbeforeCreate");
        crudCreate.setProperties((GenericProperties)new ArrayListProperties());
        crudCreate.getProperties().put("xmlns:tgc", "http://textgrid.info/namespaces/middleware/tgcrud/services/TGCrudService");
        String metadataFor = p.getProperties().get("Output") != null ? "Output:" + p.getProperties().get("Output") : (p.getProperties().get("ToTransition") != null ? "Transition:" + p.getProperties().get("ToTransition") + "@" + p.getProperties().get("ToPort") : "unknown");
        metadataForCreate.setProperties((GenericProperties)new ArrayListProperties());
        metadataForCreate.getProperties().put("MetadataFor", metadataFor);
        Transition source = this.w.getTransition(p.getProperties().get("FromTransition"));
        metadataForCreate.getProperties().put("MetadataConsumer", source.getID());
        String originalExpression = source.getOutEdge(p.getID()).getExpression();
        source.removeOutEdge(p.getID());
        Edge create2uri = Factory.newEdge();
        create2uri.setExpression("*");
        create2uri.setPlace(p);
        crudCreate.addOutEdge(create2uri);
        Edge data2create = Factory.newEdge();
        data2create.setExpression("tgc:tgObjectData");
        data2create.setPlace(dataForCreate);
        crudCreate.addInEdge(data2create);
        Edge metadata2create = Factory.newEdge();
        metadata2create.setExpression("tgc:tgObjectMetadata");
        metadata2create.setPlace(metadataForCreate);
        crudCreate.addInEdge(metadata2create);
        Edge transition2data = Factory.newEdge();
        transition2data.setExpression(originalExpression);
        transition2data.setPlace(dataForCreate);
        source.addOutEdge(transition2data);
        this.w.addPlace(dataForCreate);
        this.w.addPlace(metadataForCreate);
        this.w.addTransition(crudCreate);
        return true;
    }

    public void addTrueControl(Transition t) {
        Place controlPlace = Factory.newPlace();
        controlPlace.setID(String.valueOf(t.getID()) + "control");
        Token trueControl = Factory.newToken((boolean)true);
        try {
            controlPlace.addToken(trueControl);
        }
        catch (CapacityException e) {
            e.printStackTrace();
        }
        Edge controlEdge = Factory.newEdge();
        controlEdge.setPlace(controlPlace);
        t.addInEdge(controlEdge);
        this.w.addPlace(controlPlace);
    }

    public static Token constructDataToken(String tag, String value) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<data><").append(tag).append(">").append(value).append("</").append(tag).append("></data>");
        Data data = Factory.newData();
        try {
            data.fromXML(buffer.toString());
        }
        catch (WorkflowFormatException e) {
            e.printStackTrace();
        }
        return Factory.newToken((Data)data);
    }

    public static Place constructDataTokenPlace(String id, String tag, String value) {
        Place p = Factory.newPlace();
        p.setID(id);
        p.setProperties((GenericProperties)new ArrayListProperties());
        try {
            p.addToken(ChainGWDL.constructDataToken(tag, value));
        }
        catch (CapacityException e) {
            e.printStackTrace();
        }
        return p;
    }
}

