/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.views;

import info.textgrid.lab.workflow.Chain;
import info.textgrid.lab.workflow.ChainEntry;
import info.textgrid.lab.workflow.EntryLink;
import info.textgrid.lab.workflow.EntryLinkFromComparator;
import info.textgrid.lab.workflow.servicedescription.Configparameter;
import info.textgrid.lab.workflow.servicedescription.Examplevalue;
import info.textgrid.lab.workflow.servicedescription.Input;
import info.textgrid.lab.workflow.servicedescription.Output;
import info.textgrid.lab.workflow.views.ChainView;
import info.textgrid.lab.workflow.views.ConfigParameterEditingDialogue;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ChainEntryView
extends ViewPart {
    private Chain chain;
    private Group rahmen;
    private Group descGroup;
    private Group inputGroup;
    private Group outputGroup;
    private Group configGroup;
    private final ISelectionListener selectedChainEntryListener;
    private ChainEntry currentChainEntry = null;
    private ArrayList<Widget> reminder = new ArrayList();
    private ChainView cvInstance;

    public ChainEntryView() {
        this.selectedChainEntryListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart sourcepart, ISelection selection) {
                IStructuredSelection iss;
                if (sourcepart != ChainEntryView.this && selection instanceof IStructuredSelection && !(iss = (IStructuredSelection)selection).isEmpty()) {
                    Object firstelem = iss.toArray()[0];
                    if (firstelem instanceof ChainEntry) {
                        ChainEntryView.this.currentChainEntry = (ChainEntry)firstelem;
                    } else {
                        ChainEntryView.this.currentChainEntry = null;
                    }
                    ChainEntryView.this.chain = ChainEntryView.this.cvInstance.getChain();
                    ChainEntryView.this.setChainEntry(ChainEntryView.this.currentChainEntry);
                }
            }
        };
    }

    public void createPartControl(Composite parent) {
        this.rahmen = new Group(parent, 768);
        GridData gdc = new GridData(4, 4, true, true);
        this.rahmen.setLayoutData((Object)gdc);
        GridLayout glp = new GridLayout(1, false);
        this.rahmen.setLayout((Layout)glp);
        this.descGroup = new Group((Composite)this.rahmen, 768);
        this.descGroup.setText("Description");
        GridData gdcd = new GridData(4, 4, true, true);
        this.descGroup.setLayoutData((Object)gdcd);
        GridLayout glpd = new GridLayout(1, false);
        this.descGroup.setLayout((Layout)glpd);
        this.inputGroup = new Group((Composite)this.rahmen, 768);
        this.inputGroup.setText("This service's input data, select data sources");
        GridData gdci = new GridData(4, 4, true, true);
        this.inputGroup.setLayoutData((Object)gdci);
        GridLayout glpi = new GridLayout(1, false);
        this.inputGroup.setLayout((Layout)glpi);
        this.outputGroup = new Group((Composite)this.rahmen, 768);
        this.outputGroup.setText("This Service's output data, select data targets");
        GridData gdco = new GridData(4, 4, true, true);
        this.outputGroup.setLayoutData((Object)gdco);
        GridLayout glpo = new GridLayout(1, false);
        this.outputGroup.setLayout((Layout)glpo);
        this.configGroup = new Group((Composite)this.rahmen, 0);
        this.configGroup.setText("Configuration Options");
        GridData gdcc = new GridData(4, 4, true, true);
        this.configGroup.setLayoutData((Object)gdcc);
        GridLayout glpc = new GridLayout(1, false);
        this.configGroup.setLayout((Layout)glpc);
        IViewPart chainView = null;
        chainView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("info.textgrid.lab.workflow.views.ChainView");
        if (chainView != null && chainView instanceof ChainView) {
            this.cvInstance = (ChainView)chainView;
        }
        this.getSite().getPage().addSelectionListener(this.selectedChainEntryListener);
    }

    public void setChainEntry(ChainEntry e) {
        Button setB;
        ComboViewer cv;
        EntryLink solitaire;
        LabelProvider clp;
        Label t;
        GridData gdc;
        Composite c;
        for (Widget old : this.reminder) {
            old.dispose();
        }
        this.reminder.clear();
        if (e == null) {
            this.rahmen.setText("Please select a service from the workflow");
            return;
        }
        this.rahmen.setText(e.getName());
        this.currentChainEntry = e;
        Label descriptionText = new Label((Composite)this.descGroup, 64);
        GridData gdll = new GridData(4, 4, true, true);
        descriptionText.setLayoutData((Object)gdll);
        descriptionText.setText(e.getDescription());
        descriptionText.setBounds(this.descGroup.getBounds());
        this.reminder.add((Widget)descriptionText);
        for (Input i : e.getInputs()) {
            c = new Composite((Composite)this.inputGroup, 0);
            this.reminder.add((Widget)c);
            c.setLayout((Layout)new GridLayout(3, false));
            gdc = new GridData(4, 4, true, true);
            c.setLayoutData((Object)gdc);
            t = new Label(c, 4);
            t.setText(String.valueOf(i.getName()) + ": from ");
            List<EntryLink> linksToHere = this.chain.findLinksToHere(e, i);
            clp = new LinkLabelProvider();
            if (linksToHere.size() == 1) {
                solitaire = linksToHere.get(0);
                Label from = new Label(c, 4);
                from.setText(clp.getText(solitaire));
                if (!solitaire.isUndecided()) continue;
                this.chain.addLink(solitaire);
                continue;
            }
            cv = new ComboViewer(c, 4);
            cv.setLabelProvider((IBaseLabelProvider)clp);
            cv.setContentProvider((IContentProvider)new ArrayContentProvider());
            cv.setComparator((ViewerComparator)new EntryLinkFromComparator());
            cv.setInput(linksToHere);
            setB = new Button(c, 8);
            setB.setText("Set");
            setB.addSelectionListener(new SelectionListener((LinkLabelProvider)clp){
                private final /* synthetic */ LinkLabelProvider val$clp;
                {
                    this.val$clp = linkLabelProvider;
                }

                public void widgetSelected(SelectionEvent event) {
                    IStructuredSelection spss = (IStructuredSelection)cv.getSelection();
                    EntryLink selectedLink = null;
                    if (spss.getFirstElement() instanceof EntryLink) {
                        selectedLink = (EntryLink)spss.getFirstElement();
                        if (selectedLink != null) {
                            boolean success = ChainEntryView.this.chain.addLink(selectedLink);
                            if (success) {
                                cv.getControl().dispose();
                                setB.dispose();
                                Label from = new Label(c, 4);
                                from.setText(this.val$clp.getText(selectedLink));
                                c.layout();
                            } else {
                                System.out.println("Could not add link, there were conflicts.");
                            }
                        } else {
                            System.out.println("no incoming link selected");
                        }
                    } else {
                        System.out.println("no incoming link selected");
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        for (Output o : e.getOutputs()) {
            c = new Composite((Composite)this.outputGroup, 0);
            this.reminder.add((Widget)c);
            c.setLayout((Layout)new GridLayout(3, false));
            gdc = new GridData(4, 4, true, true);
            c.setLayoutData((Object)gdc);
            t = new Label(c, 4);
            t.setText(String.valueOf(o.getName()) + ": to ");
            List<EntryLink> linksFromHere = this.chain.findLinksFromHere(e, o);
            clp = new LinkOutLabelProvider();
            if (linksFromHere.size() == 1) {
                solitaire = linksFromHere.get(0);
                Label to = new Label(c, 4);
                to.setText(clp.getText(solitaire));
                solitaire.isUndecided();
                continue;
            }
            cv = new ComboViewer(c, 4);
            cv.setLabelProvider((IBaseLabelProvider)clp);
            cv.setContentProvider((IContentProvider)new ArrayContentProvider());
            cv.setInput(linksFromHere);
            setB = new Button(c, 8);
            setB.setText("Set");
            setB.addSelectionListener(new SelectionListener((LinkOutLabelProvider)clp){
                private final /* synthetic */ LinkOutLabelProvider val$clp;
                {
                    this.val$clp = linkOutLabelProvider;
                }

                public void widgetSelected(SelectionEvent event) {
                    IStructuredSelection spss = (IStructuredSelection)cv.getSelection();
                    EntryLink selectedLink = null;
                    if (spss.getFirstElement() instanceof EntryLink) {
                        selectedLink = (EntryLink)spss.getFirstElement();
                        if (selectedLink != null) {
                            boolean success = ChainEntryView.this.chain.addLink(selectedLink);
                            if (success) {
                                cv.getControl().dispose();
                                setB.dispose();
                                Label to = new Label(c, 4);
                                to.setText(this.val$clp.getText(selectedLink));
                                c.layout();
                            } else {
                                System.out.println("Could not add link, there were conflicts.");
                            }
                        } else {
                            System.out.println("no incoming link selected");
                        }
                    } else {
                        System.out.println("no incoming link selected");
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        for (Configparameter cp : e.getConfigParameters()) {
            c = new Composite((Composite)this.configGroup, 0);
            this.reminder.add((Widget)c);
            final String thisConfigParam = cp.getParam();
            final String thisConfigParamName = cp.getName();
            c.setLayout((Layout)new GridLayout(cp.isMultiple() != false ? 6 : 4, false));
            GridData gdc2 = new GridData(4, 4, true, true);
            c.setLayoutData((Object)gdc2);
            ArrayList<Examplevalue> exValues = e.getChosenConfigParamExampleValues(cp.getParam());
            if (exValues.size() == 0) {
                Label t2 = new Label(c, 4);
                t2.setText(String.valueOf(cp.getName()) + ": (no value set)");
                Button addB = new Button(c, 8);
                addB.setText("Add...");
                addB.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent event) {
                        ChainEntryView.this.currentChainEntry.addDefaultExampleValue(thisConfigParam);
                        ChainEntryView.this.setChainEntry(ChainEntryView.this.currentChainEntry);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                break;
            }
            int i = 0;
            while (i < exValues.size()) {
                if (i == 0) {
                    Label t3 = new Label(c, 4);
                    t3.setText(String.valueOf(cp.getName()) + ": ");
                } else {
                    Label dummy = new Label(c, 4);
                    dummy.setText("");
                }
                final ComboViewer cv2 = new ComboViewer(c, 4);
                cv2.setLabelProvider((IBaseLabelProvider)new ConfigLabelProvider());
                cv2.setContentProvider((IContentProvider)new ArrayContentProvider());
                cv2.setComparator((ViewerComparator)new EntryLinkFromComparator());
                cv2.setInput(cp.getExamplevalue());
                cv2.setSelection((ISelection)new StructuredSelection((Object)exValues.get(i)), true);
                final int fi = i;
                Button setB2 = new Button(c, 8);
                setB2.setText("Set");
                final Button editB = new Button(c, 8);
                editB.setText("Edit...");
                if (cp.isMultiple().booleanValue()) {
                    Button addB = new Button(c, 8);
                    addB.setText("Add...");
                    addB.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent event) {
                            ChainEntryView.this.currentChainEntry.addDefaultExampleValue(thisConfigParam);
                            ChainEntryView.this.setChainEntry(ChainEntryView.this.currentChainEntry);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                    Button delB = new Button(c, 8);
                    delB.setText("Delete");
                    delB.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent event) {
                            ChainEntryView.this.currentChainEntry.deleteExampleValue(thisConfigParam, fi);
                            ChainEntryView.this.setChainEntry(ChainEntryView.this.currentChainEntry);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                }
                editB.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent event) {
                        Examplevalue selectedExValue = ChainEntryView.this.currentChainEntry.getChosenConfigParamExampleValues(thisConfigParam).get(fi);
                        IStructuredSelection spss = (IStructuredSelection)cv2.getSelection();
                        if (spss.getFirstElement() instanceof Examplevalue) {
                            selectedExValue = (Examplevalue)spss.getFirstElement();
                        }
                        String orig = ChainEntry.anyToString(selectedExValue.getContent());
                        ConfigParameterEditingDialogue cped = new ConfigParameterEditingDialogue(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                        cped.setContents(thisConfigParamName, orig, ChainEntryView.this.currentChainEntry, thisConfigParam, selectedExValue.isInline(), fi);
                        cped.setBlockOnOpen(true);
                        cped.open();
                        cv2.setInput(ChainEntryView.this.currentChainEntry.getAllAvailableExampleValues(thisConfigParam));
                        cv2.setSelection((ISelection)new StructuredSelection((Object)ChainEntryView.this.currentChainEntry.getChosenConfigParamExampleValues(thisConfigParam).get(fi)), true);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                setB2.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent event) {
                        IStructuredSelection spss = (IStructuredSelection)cv2.getSelection();
                        Examplevalue selectedID = null;
                        if (spss.getFirstElement() instanceof Examplevalue) {
                            selectedID = (Examplevalue)spss.getFirstElement();
                            if (selectedID != null) {
                                ChainEntryView.this.currentChainEntry.selectExampleValue(thisConfigParam, selectedID, fi);
                                editB.setEnabled(true);
                            } else {
                                System.out.println("no example value selected");
                            }
                        } else {
                            System.out.println("no example value selected");
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                ++i;
            }
        }
        this.rahmen.layout(true, true);
    }

    public void setFocus() {
    }

    public void dispose() {
        if (this.selectedChainEntryListener != null) {
            this.getSite().getPage().removeSelectionListener(this.selectedChainEntryListener);
        }
    }

    class ConfigLabelProvider
    extends LabelProvider {
        ConfigLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof Examplevalue) {
                Examplevalue ex = (Examplevalue)obj;
                return ex.getName();
            }
            return "unknown class: " + obj.getClass();
        }
    }

    class LinkLabelProvider
    extends LabelProvider {
        LinkLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof EntryLink) {
                EntryLink l = (EntryLink)obj;
                if (l.getFrom() == null || l.getFromPort() == null) {
                    return "Workflow Inputs";
                }
                return String.valueOf(l.getFrom().getName()) + ", " + l.getFromPort().getName();
            }
            return "unknown class: " + obj.getClass();
        }
    }

    class LinkOutLabelProvider
    extends LabelProvider {
        LinkOutLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof EntryLink) {
                EntryLink l = (EntryLink)obj;
                if (l.getTo() == null || l.getToPort() == null) {
                    return "Workflow Outputs";
                }
                return String.valueOf(l.getTo().getName()) + ", " + l.getToPort().getName();
            }
            return "unknown class: " + obj.getClass();
        }
    }
}

