/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.views;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.dialogs.INewObjectPreparator;
import info.textgrid.lab.ui.core.dialogs.ITextGridWizard;
import info.textgrid.lab.ui.core.dialogs.NewObjectWizard;
import info.textgrid.lab.workflow.Activator;
import info.textgrid.namespaces.metadata.agent._2010.PersonType;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class NewWorkflowPreparator
implements INewObjectPreparator {
    private ITextGridWizard wizard;
    public static final String NEW_SCHEMA_CONTENTS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<tgwf:tgwf xmlns:tgwf=\"http://textgrid.info/namespaces/middleware/workflow\" version=\"0.5\">\n  <tgwf:description/>\n  <tgwf:activities>\n    <tgwf:service description=\"\" name=\"\" operation=\"\" serviceID=\"\" targetNamespace=\"\" wsdlLocation=\"\" usetns=\"\"/>\n  </tgwf:activities>\n  <tgwf:datalinks>\n    <tgwf:link linkID=\"read\" fromServiceID=\"crud\" fromParam=\"batchinput\" toServiceID=\"\" toParam=\"\"/>\n    <tgwf:link linkID=\"write\" fromServiceID=\"\" fromParam=\"\" toServiceID=\"crud\" toParam=\"batchoutput\"/>\n  </tgwf:datalinks>\n  <tgwf:CRUD instance=\"inserted automatically\" sessionID=\"inserted automatically\" logParameter=\"inserted automatically\"/>\n  <tgwf:batchinput/>\n  <tgwf:metadatatransformation>\n   <xsl:transform xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ns1=\"http://textgrid.info/namespaces/middleware/tgcrud/services/TGCrudService\" xmlns:tgomd=\"http://textgrid.info/namespaces/metadata/core/2008-07-24\" version=\"1.0\">\n      <xsl:output method=\"xml\" encoding=\"UTF-8\" indent=\"no\"/>\n      <xsl:template match=\"/\">\n        <ns1:tgObjectMetadata xmlns:ns1=\"http://textgrid.info/namespaces/middleware/tgcrud/services/TGCrudService\">\n          <xsl:copy-of select=\"/ns1:tgObjectMetadata/tgomd:descriptive\"/>\n          <administrative xmlns=\"http://textgrid.info/namespaces/metadata/core/2008-07-24\">\n            <client>\n              <project id=\"TGPRXXX\"/>\n              <xsl:copy-of select=\"/ns1:tgObjectMetadata/tgomd:administrative/tgomd:client/tgomd:format\"/>\n              <xsl:copy-of select=\"/ns1:tgObjectMetadata/tgomd:administrative/tgomd:client/tgomd:partNo\"/>\n            </client>\n          </administrative>\n          <xsl:copy-of select=\"/ns1:tgObjectMetadata/tgomd:custom\"/>\n        </ns1:tgObjectMetadata>\n      </xsl:template>\n    </xsl:transform>\n  </tgwf:metadatatransformation>\n  <tgwf:inputconstants>\n    <tgwf:activity serviceID=\"\">\n      <tgwf:const name=\"\" needsB64encoding=\"false\">\n      </tgwf:const>\n    </tgwf:activity>\n  </tgwf:inputconstants>\n</tgwf:tgwf>\n";

    public void initializeObject(TextGridObject textGridObject) {
        PersonType rightsHolder = RBACSession.getInstance().getPerson();
        textGridObject.setItemMetadata(rightsHolder);
    }

    public boolean performFinish(TextGridObject textGridObject) {
        try {
            IFile file = (IFile)AdapterUtils.getAdapter((Object)textGridObject, IFile.class);
            file.setCharset("UTF-8", null);
            textGridObject.setInitialContent(NEW_SCHEMA_CONTENTS.getBytes("UTF-8"));
            System.out.println("URI of new TGO:" + textGridObject.getURI());
        }
        catch (IllegalStateException e) {
            Activator.handleProblem(2, e, "The TextGrid Workflow object {0} has already been made persistent in this new wizard. Cannot initialize its contents properly.", textGridObject);
        }
        catch (UnsupportedEncodingException e) {
            Activator.handleProblem(4, e, "UTF-8 is unsupported!? What a strange setup is this? It will be hard to run the lab here ...", new Object[0]);
        }
        catch (CoreException e) {
            Activator.handleProblem(4, e, "Core Exception during PerformFinish()", new Object[0]);
        }
        if (this.wizard instanceof NewObjectWizard) {
            return ((NewObjectWizard)this.wizard).defaultPerformFinish("info.textgrid.lab.workflow.WorkflowPerspective");
        }
        return false;
    }

    public void setWizard(ITextGridWizard wizard) {
        this.wizard = wizard;
    }
}

