/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.views;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.menus.TGOpenWithMenu;
import info.textgrid.lab.ui.core.utils.TextGridObjectTableViewer;
import info.textgrid.lab.workflow.EntryLink;
import info.textgrid.lab.workflow.views.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public class WorkflowInputs
extends ViewPart {
    private ArrayList<TextGridObjectTableViewer> inputViewers;
    private ArrayList<ArrayList<TextGridObject>> inputTGOlists;
    private ArrayList<String> headings;
    private ArrayList<Boolean> multiState;
    private Composite inputBoxes;
    private Composite c;
    private ArrayList<Composite> reminder = new ArrayList();

    public void createPartControl(Composite parent) {
        this.c = new Composite(parent, 0);
        GridData gdc = new GridData(4, 4, true, true);
        this.c.setLayoutData((Object)gdc);
        GridLayout glp = new GridLayout(1, false);
        this.c.setLayout((Layout)glp);
        this.inputBoxes = new Composite(this.c, 0);
        Composite bottom = new Composite(this.c, 0);
        GridData gdb = new GridData(4, 4, true, true);
        bottom.setLayoutData((Object)gdb);
        GridLayout glb = new GridLayout(1, false);
        bottom.setLayout((Layout)glb);
        Label howtoAdd = new Label(bottom, 64);
        GridData gd7 = new GridData(4, 2, true, false);
        howtoAdd.setLayoutData((Object)gd7);
        howtoAdd.setText(Messages.WorkflowInputs_DragHelp);
        Button removeInputsButton = new Button(bottom, 8);
        GridData gd6 = new GridData(16384, 0x1000000, false, false);
        removeInputsButton.setLayoutData((Object)gd6);
        removeInputsButton.setText(Messages.WorkflowInputs_RemoveButtonText);
        removeInputsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WorkflowInputs.this.removeSelectedInputs();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public void drawInputBoxes(ArrayList<EntryLink> links) {
        int numberOfBoxes = links.size();
        GridData gdc = new GridData(4, 4, true, true);
        this.inputBoxes.setLayoutData((Object)gdc);
        GridLayout glp = new GridLayout(numberOfBoxes, true);
        this.inputBoxes.setLayout((Layout)glp);
        this.inputViewers = new ArrayList();
        this.inputTGOlists = new ArrayList();
        this.headings = new ArrayList();
        this.multiState = new ArrayList();
        for (Composite c : this.reminder) {
            c.dispose();
        }
        this.reminder.clear();
        int index = 0;
        for (EntryLink l : links) {
            this.drawOneBox(l, index);
            ++index;
        }
        this.c.layout(true, true);
    }

    public void drawOneBox(EntryLink l, final int index) {
        String heading = String.valueOf(l.getTo().getName()) + ": " + l.getToPort().getName();
        Boolean isMulti = l.getToPort().isMultiple();
        ArrayList tgos = new ArrayList();
        this.inputTGOlists.add(tgos);
        Composite box = new Composite(this.inputBoxes, 2048);
        GridData gdc = new GridData(4, 4, true, true);
        box.setLayoutData((Object)gdc);
        GridLayout glp = new GridLayout(1, false);
        box.setLayout((Layout)glp);
        this.reminder.add(box);
        Label headingLabel = new Label(box, 4);
        headingLabel.setText(heading);
        this.headings.add(heading);
        Label multiLabel = new Label(box, 4);
        if (isMulti.booleanValue()) {
            multiLabel.setText(Messages.WorkflowInputs_PooledLabel);
        } else {
            multiLabel.setText(Messages.WorkflowInputs_OneByOneLabe);
        }
        this.multiState.add(isMulti);
        TextGridObjectTableViewer inputViewer = new TextGridObjectTableViewer(box, 68354);
        this.inputViewers.add(inputViewer);
        GridData gd5 = new GridData(4, 4, true, true);
        inputViewer.getControl().setLayoutData((Object)gd5);
        inputViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        inputViewer.setVisibleColumns(EnumSet.of(TextGridObjectTableViewer.Column.TITLE));
        inputViewer.getTable().setHeaderVisible(false);
        inputViewer.addDropSupport(19, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)inputViewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return true;
            }

            public boolean performDrop(Object data) {
                if (data instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)data;
                    Object[] droppedObjects = (TextGridObject[])AdapterUtils.getAdapters((Object[])Iterators.toArray((Iterator)selection.iterator(), Object.class), TextGridObject.class, (boolean)false);
                    ((TextGridObjectTableViewer)WorkflowInputs.this.inputViewers.get(index)).add(droppedObjects);
                    ((ArrayList)WorkflowInputs.this.inputTGOlists.get(index)).addAll(ImmutableList.copyOf((Object[])droppedObjects));
                }
                return true;
            }
        });
        this.hookContextMenu((TableViewer)inputViewer);
        inputViewer.setInput((Object)tgos.toArray());
    }

    private void removeSelectedInputs() {
        int index = 0;
        while (index < this.inputViewers.size()) {
            IStructuredSelection iss = (IStructuredSelection)this.inputViewers.get(index).getSelection();
            for (TextGridObject oneTarget : iss) {
                this.inputTGOlists.get(index).remove(oneTarget);
            }
            this.inputViewers.get(index).setInput((Object)this.inputTGOlists.get(index).toArray());
            ++index;
        }
    }

    public ArrayList<ArrayList<TextGridObject>> getInputs() {
        return this.inputTGOlists;
    }

    public void addtoInputs(ArrayList<TextGridObject> tgos, int inputIndex) {
        if (this.inputViewers.get(inputIndex) == null || this.inputTGOlists.get(inputIndex) == null) {
            return;
        }
        TextGridObject[] existingTGOs = this.inputTGOlists.get(inputIndex).toArray(new TextGridObject[0]);
        for (TextGridObject oneTGO : tgos) {
            boolean foundit = false;
            TextGridObject[] textGridObjectArray = existingTGOs;
            int n = existingTGOs.length;
            int n2 = 0;
            while (n2 < n) {
                TextGridObject t = textGridObjectArray[n2];
                if (oneTGO == t) {
                    foundit = true;
                }
                ++n2;
            }
            if (foundit) continue;
            Long oneTGOSize = 0L;
            boolean couldNotDetermineSize = false;
            try {
                oneTGOSize = oneTGO.getSize();
            }
            catch (CoreException coreException) {
                couldNotDetermineSize = true;
            }
            if (couldNotDetermineSize) {
                this.showMessage(Messages.WorkflowInputs_SizeWarning);
            } else if (oneTGOSize > 0x100000L) {
                this.showMessage(MessageFormat.format(Messages.WorkflowInputs_TooLargeWarning, oneTGOSize.toString()));
            }
            this.inputTGOlists.get(inputIndex).add(oneTGO);
        }
        this.inputViewers.get(inputIndex).setInput((Object)this.inputTGOlists.get(inputIndex).toArray());
    }

    private void hookContextMenu(final TableViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                WorkflowInputs.this.fillContextMenu(manager, viewer);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    private void fillContextMenu(IMenuManager manager, TableViewer viewer) {
        MenuManager openWithSubMenu = new MenuManager(Messages.WorkflowInputs_openwithmenu);
        Object firstElement = ((IStructuredSelection)viewer.getSelection()).getFirstElement();
        if (firstElement == null) {
            return;
        }
        IFile iFile = (IFile)((IAdaptable)firstElement).getAdapter(IFile.class);
        openWithSubMenu.add((IContributionItem)new TGOpenWithMenu(this.getSite().getPage(), (IAdaptable)iFile));
        manager.add((IContributionItem)openWithSubMenu);
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    private void hookDoubleClickAction(TableViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.inputBoxes.getShell(), (String)Messages.WorkflowInputs_CommonMessagesTitle, (String)message);
    }

    public void setFocus() {
        this.inputBoxes.setFocus();
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }
}

