/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.versions.ui;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.core.versions.ui.Messages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.handlers.HandlerUtil;

public class DetachVersionHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            TextGridObject[] objects = (TextGridObject[])AdapterUtils.getAdapters((Object[])((IStructuredSelection)currentSelection).toArray(), TextGridObject.class, (boolean)false);
            new ClearVersionJob(objects).schedule();
        }
        return null;
    }

    public class ClearVersionJob
    extends Job {
        private TextGridObject[] objects;

        public ClearVersionJob(TextGridObject ... objects) {
            super(NLS.bind((String)Messages.DetachVersionHandler_DetachObjectsFromParent, (Object)objects.length));
            this.objects = objects;
            this.setUser(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(10 * this.objects.length));
            MultiStatus multiStatus = new MultiStatus("info.textgrid.lab.search", 0, Messages.DetachVersionHandler_DetachFailed, null);
            TextGridObject[] textGridObjectArray = this.objects;
            int n = this.objects.length;
            int n2 = 0;
            while (n2 < n) {
                TextGridObject object = textGridObjectArray[n2];
                progress.subTask(NLS.bind((String)Messages.DetachVersionHandler_Detaching, (Object)object));
                if (progress.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                object.clearPreviousVersion();
                progress.worked(1);
                try {
                    object.makeMetadataPersistent((IProgressMonitor)progress.newChild(9));
                }
                catch (CoreException e) {
                    multiStatus.add(e.getStatus());
                }
                ++n2;
            }
            progress.done();
            if (multiStatus.isOK()) {
                return Status.OK_STATUS;
            }
            return multiStatus;
        }
    }
}

