/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.templateeditor.config;

import info.textgrid.lab.templateeditor.Activator;
import info.textgrid.lab.templateeditor.config.ConfigCustomElement;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.jaxen.JaxenException;

public class ConfigCreator {
    public static String templateEditorSectionNS = "http://textgrid.info/namespaces/metadata/templateEditor/config/2009-01-31";
    public static QName templateConfQname = new QName(templateEditorSectionNS, "templateEditorConfig", "tc");
    private static QName customElementsQname = new QName(templateEditorSectionNS, "customElements", "tc");
    private static ConfigCreator instance = null;
    private ArrayList<ConfigCustomElement> cus_elements = new ArrayList();

    public static ConfigCreator getInstance() {
        if (instance == null) {
            instance = new ConfigCreator();
        }
        return instance;
    }

    private ConfigCreator() {
    }

    public void addConfigElement(ConfigCustomElement elem) {
        this.cus_elements.add(elem);
    }

    public OMElement createConfig() {
        OMFactory omfactory = OMAbstractFactory.getOMFactory();
        OMElement root = omfactory.createOMElement(templateConfQname);
        OMElement customElems = omfactory.createOMElement(customElementsQname);
        OMNamespace ns = omfactory.createOMNamespace(templateConfQname.getNamespaceURI(), templateConfQname.getPrefix());
        for (ConfigCustomElement e : this.cus_elements) {
            customElems.addChild((OMNode)e.createConfigCustomElement(omfactory, ns));
        }
        root.addChild((OMNode)customElems);
        this.clear();
        return root;
    }

    private void clear() {
        if (!this.cus_elements.isEmpty()) {
            this.cus_elements.clear();
        }
    }

    private static OMElement getElementWithName(String elementName, OMElement root) throws JaxenException {
        AXIOMXPath xpath = new AXIOMXPath(String.valueOf(templateConfQname.getPrefix()) + ":" + elementName);
        xpath.addNamespace(templateConfQname.getPrefix(), templateConfQname.getNamespaceURI());
        OMElement elem = (OMElement)xpath.selectSingleNode((Object)root);
        return elem;
    }

    public static ArrayList<ConfigCustomElement> getConfigCustomElements(OMElement root) {
        OMElement cusElems = null;
        ArrayList<ConfigCustomElement> elements = new ArrayList<ConfigCustomElement>();
        try {
            cusElems = ConfigCreator.getElementWithName(customElementsQname.getLocalPart(), root);
            OMElement name = null;
            OMElement type = null;
            OMElement repeatable = null;
            OMElement required = null;
            Iterator iter = cusElems.getChildElements();
            while (iter.hasNext()) {
                OMElement elem = (OMElement)iter.next();
                if (elem == null) continue;
                name = ConfigCreator.getElementWithName("name", elem);
                type = ConfigCreator.getElementWithName("type", elem);
                repeatable = ConfigCreator.getElementWithName("repeatable", elem);
                required = ConfigCreator.getElementWithName("required", elem);
                elements.add(new ConfigCustomElement(name.getText(), type.getText(), Boolean.parseBoolean(repeatable.getText()), required != null ? Boolean.parseBoolean(required.getText()) : false));
            }
        }
        catch (JaxenException e) {
            Activator.handleError(e);
        }
        return elements;
    }
}

