/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.handlers;

import info.textgrid.lab.core.model.Activator;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.handlers.Messages;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.StatusManager;

@Deprecated
public class ExportHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TextGridObject[] textGridObjects;
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            textGridObjects = (TextGridObject[])AdapterUtils.getAdapters((Object[])selection.toArray(), TextGridObject.class, (boolean)false);
            if (textGridObjects.length == 0) {
                throw new ExecutionException(MessageFormat.format(String.valueOf(Messages.ExportHandler_NoTGObject) + Messages.ExportHandler_EM_ShouldBePrevented, selection));
            }
        } else {
            throw new ExecutionException(MessageFormat.format(String.valueOf(Messages.ExportHandler_EM_KindOfSelection) + Messages.ExportHandler_EM_ShouldBePrevented, sel));
        }
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ExportHandler.exportObjects(shell, textGridObjects);
        return null;
    }

    public static void exportObjects(Shell shell, TextGridObject ... textGridObjects) {
        DirectoryDialog dialog = new DirectoryDialog(shell);
        dialog.setText("Export");
        dialog.setMessage(Messages.ExportHandler_IM_SelectDirectory);
        String targetPath = dialog.open();
        if (targetPath == null) {
            return;
        }
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        ExportRunnable exportRunnable = new ExportRunnable(targetPath, textGridObjects);
        try {
            progressService.run(true, true, (IRunnableWithProgress)exportRunnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                StatusManager.getManager().handle(((CoreException)e.getCause()).getStatus(), 3);
            }
        }
        catch (InterruptedException e) {
            Activator.handleProblem((int)1, (Throwable)e, (String)Messages.ExportHandler_Canceled, (Object[])new Object[0]);
        }
        if (exportRunnable.status.getSeverity() < 2) {
            StatusManager.getManager().handle((IStatus)new MultiStatus("info.textgrid.lab.core.model", 0, exportRunnable.status.getChildren(), Messages.ExportHandler_Finished, null));
        }
    }

    private static class ExportRunnable
    implements IRunnableWithProgress {
        private String targetPath;
        private TextGridObject[] textGridObjects;
        private MultiStatus status = new MultiStatus("info.textgrid.lab.core.model", 0, Messages.ExportHandler_EM_MultiStatus, null);

        public ExportRunnable(String targetPath, TextGridObject[] textGridObjects) {
            this.targetPath = targetPath;
            this.textGridObjects = textGridObjects;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format(Messages.ExportHandler_ExportTo, this.targetPath), (int)(10 + 100 * this.textGridObjects.length));
            File targetDir = new File(this.targetPath);
            if (!targetDir.isDirectory() && !targetDir.mkdirs()) {
                throw new InvocationTargetException(new IOException(MessageFormat.format(Messages.ExportHandler_EM_TargetDirectory, targetDir)));
            }
            progress.worked(10);
            TextGridObject[] textGridObjectArray = this.textGridObjects;
            int n = this.textGridObjects.length;
            int n2 = 0;
            while (n2 < n) {
                TextGridObject textGridObject = textGridObjectArray[n2];
                if (progress.isCanceled()) {
                    throw new InterruptedException(Messages.ExportHandler_EM_UserRequest);
                }
                progress.subTask(MessageFormat.format(Messages.ExportHandler_Export, textGridObject));
                IFile file = (IFile)AdapterUtils.getAdapter((Object)textGridObject, IFile.class);
                progress.worked(10);
                try {
                    File targetFile = new File(targetDir, textGridObject.getURIBasedName());
                    progress.subTask(MessageFormat.format(Messages.ExportHandler_Export, textGridObject));
                    IFileStore remoteStore = EFS.getStore((URI)file.getLocationURI());
                    IFileStore localStore = EFS.getLocalFileSystem().fromLocalFile(targetFile);
                    progress.worked(10);
                    remoteStore.copy(localStore, 2, (IProgressMonitor)progress.newChild(70));
                    if (progress.isCanceled()) {
                        throw new InterruptedException(Messages.ExportHandler_EM_UserRequest2);
                    }
                    File metaFile = new File(targetDir, "." + textGridObject.getURIBasedName().concat(".meta"));
                    BufferedOutputStream metaStream = new BufferedOutputStream(new FileOutputStream(metaFile));
                    textGridObject.getMetadataXML().serialize((OutputStream)metaStream);
                    metaStream.close();
                    progress.worked(10);
                    this.status.add((IStatus)new Status(0, "info.textgrid.lab.core.model", MessageFormat.format(Messages.ExportHandler_SuccessfullExport, textGridObject, targetFile)));
                }
                catch (CoreException e) {
                    this.status.add(this.exportFailed(e, textGridObject));
                }
                catch (FileNotFoundException e) {
                    this.status.add(this.exportFailed(e, textGridObject));
                }
                catch (XMLStreamException e) {
                    this.status.add(this.exportFailed(e, textGridObject));
                }
                catch (IOException e) {
                    this.status.add(this.exportFailed(e, textGridObject));
                }
                ++n2;
            }
            if (this.status.getSeverity() >= 2) {
                throw new InvocationTargetException(new CoreException((IStatus)this.status));
            }
        }

        private IStatus exportFailed(Throwable e, TextGridObject textGridObject) {
            if (e instanceof CoreException) {
                CoreException ce = (CoreException)e;
                return new MultiStatus("info.textgrid.lab.core.model", 0, new IStatus[]{ce.getStatus()}, MessageFormat.format(Messages.ExportHandler_Failed1, textGridObject), e);
            }
            return new Status(4, "info.textgrid.lab.core.model", MessageFormat.format(Messages.ExportHandler_Failed2, textGridObject), e);
        }
    }
}

