/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.handlers;

import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.handlers.Messages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class ReloadMetadataHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null && selection instanceof IStructuredSelection) {
            final TextGridObject[] objects = (TextGridObject[])AdapterUtils.getAdapters((Object[])((IStructuredSelection)selection).toArray(), TextGridObject.class, (boolean)false);
            Job reloadJob = new Job(NLS.bind((String)Messages.ReloadMetadataHandler_JobName, (Object)objects.length)){

                protected IStatus run(IProgressMonitor monitor) {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)objects.length);
                    MultiStatus result = new MultiStatus("info.textgrid.lab.ui.core", 0, NLS.bind((String)Messages.ReloadMetadataHandler_MultiStatus, (Object)objects.length), null);
                    TextGridObject[] textGridObjectArray = objects;
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TextGridObject object = textGridObjectArray[n2];
                        progress.subTask(NLS.bind((String)Messages.ReloadMetadataHandler_NameSubTask, (Object)object));
                        try {
                            object.reloadMetadata(true);
                            object.notifyMetadataEditor();
                            result.add((IStatus)new Status(0, "info.textgrid.lab.ui.core", NLS.bind((String)Messages.ReloadMetadataHandler_StatusMessage, (Object)object)));
                        }
                        catch (CrudServiceException e) {
                            result.add(e.getStatus());
                        }
                        progress.worked(1);
                        ++n2;
                    }
                    progress.done();
                    StatusManager.getManager().handle((IStatus)result);
                    return result;
                }
            };
            reloadJob.setUser(true);
            reloadJob.schedule();
        }
        return null;
    }
}

