/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.woerterbuchsearchmask.view;

import info.textgrid.lab.dictionarysearch.Activator;
import info.textgrid.lab.dictionarysearch.DSLemma;
import info.textgrid.lab.dictionarysearch.client.Wbb_WebService_Impl;
import info.textgrid.lab.dictionarysearch.views.DictionarySearchView;
import info.textgrid.lab.woerterbuchsearchmask.view.Messages;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DictionarySearchMaskView
extends ViewPart {
    private static final String TG_WOERTERBUCH_WEBSERVICE_UNI_TRIER = "http://tg-woerterbuch-webservice.uni-trier.de/Wbb_WebService/";
    private static final int READ_TIME_OUT = 8000;
    private static final String SEARCH_PROCESSING = Messages.DictionarySearchMaskView_Search_Processing;
    public static String ID = "info.textgrid.lab.woerterbuchsearchmask.view.DictionarySearchMaskView";
    private CheckboxTreeViewer treeViewer = null;
    private Label labelSearchstring = null;
    private Text lemma = null;
    private Label labelLimit = null;
    private Text textLimit = null;
    private Label labelSearchForm = null;
    private Button buttonSearchFormExact = null;
    private Button buttonSearchFormFuzzy = null;
    private Button buttonSearchStart = null;
    private static String LIMIT = "10";
    private static String LINKEDLEMMAS = "false";
    private String suchArt = null;
    private Button buttonLinkedLemma;
    private Label labelLinkedLemmaText;
    private Label labelSearchStatus = null;
    private Composite top;
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private boolean withWBLE = false;

    public void createPartControl(final Composite parent) {
        this.top = new Composite(parent, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        this.top.setLayout((Layout)gridLayout);
        Group groupSearchParameters = new Group(this.top, 0);
        groupSearchParameters.setText(Messages.DictionarySearchMaskView_Search_Parameters);
        GridLayout searchLayout4SearchParameters = new GridLayout();
        groupSearchParameters.setLayout((Layout)searchLayout4SearchParameters);
        searchLayout4SearchParameters.numColumns = 3;
        searchLayout4SearchParameters.makeColumnsEqualWidth = false;
        this.buttonSearchStart = new Button(this.top, 8);
        this.buttonSearchStart.setText(Messages.DictionarySearchMaskView_Start_Search);
        this.buttonSearchStart.setFocus();
        Group groupSearchFacts = new Group(this.top, 0);
        groupSearchFacts.setText(Messages.DictionarySearchMaskView_Limit);
        GridLayout searchLayout4SearchFacts = new GridLayout();
        groupSearchFacts.setLayout((Layout)searchLayout4SearchFacts);
        searchLayout4SearchFacts.numColumns = 1;
        searchLayout4SearchFacts.makeColumnsEqualWidth = false;
        Composite compositeSearchParameters = new Composite((Composite)groupSearchParameters, 0);
        compositeSearchParameters.setLayout((Layout)new GridLayout(1, false));
        Composite compositeKeyword = new Composite(compositeSearchParameters, 0);
        compositeKeyword.setLayout((Layout)new GridLayout(2, false));
        Composite compositeSearchType = new Composite(compositeSearchParameters, 0);
        compositeSearchType.setLayout((Layout)new GridLayout(2, false));
        this.labelSearchstring = new Label(compositeKeyword, 0);
        this.labelSearchstring.setText(Messages.DictionarySearchMaskView_Keyword);
        this.lemma = new Text(compositeKeyword, 2048);
        this.lemma.setLayoutData((Object)new GridData(120, -1));
        this.lemma.setSize(200, 20);
        Composite compositeLimit = new Composite((Composite)groupSearchFacts, 0);
        compositeLimit.setLayout((Layout)new GridLayout(1, false));
        Composite compositeLimitCount = new Composite(compositeLimit, 0);
        compositeLimitCount.setLayout((Layout)new GridLayout(3, false));
        this.labelLimit = new Label(compositeLimitCount, 0);
        this.labelLimit.setText(Messages.DictionarySearchMaskView_Limit);
        this.textLimit = new Text(compositeLimitCount, 2048);
        this.textLimit.setText(LIMIT);
        this.textLimit.setLayoutData((Object)new GridData(25, -1));
        this.textLimit.setToolTipText(Messages.DictionarySearchMaskView_Max_Limit);
        this.textLimit.setTextLimit(4);
        this.textLimit.pack();
        this.textLimit.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Object src = e.getSource();
                if (src == DictionarySearchMaskView.this.textLimit && e.text.matches("^\\D+$")) {
                    e.doit = false;
                    DictionarySearchMaskView.this.showMessage("Numbers only! Attempted input: " + e.text);
                }
            }
        });
        this.labelSearchForm = new Label(compositeSearchType, 0);
        this.labelSearchForm.setText(Messages.DictionarySearchMaskView_Searchtype);
        Composite compositeSearchTypeButtons = new Composite(compositeSearchType, 0);
        compositeSearchTypeButtons.setLayout((Layout)new RowLayout());
        this.buttonSearchFormExact = new Button(compositeSearchTypeButtons, 16);
        this.buttonSearchFormExact.setText(Messages.DictionarySearchMaskView_Exact);
        this.buttonSearchFormExact.setSelection(true);
        this.buttonSearchFormFuzzy = new Button(compositeSearchTypeButtons, 16);
        this.buttonSearchFormFuzzy.setText(Messages.DictionarySearchMaskView_Fuzzy);
        Composite compositeLinkedLemmasOnlyOutline = new Composite(compositeLimit, 0);
        compositeLinkedLemmasOnlyOutline.setLayout((Layout)new GridLayout(1, false));
        Composite compositeLinkedLemmasOnly = new Composite(compositeLinkedLemmasOnlyOutline, 0);
        compositeLinkedLemmasOnly.setLayout((Layout)new GridLayout(1, false));
        if (this.withWBLE) {
            this.buttonLinkedLemma = new Button(compositeLinkedLemmasOnly, 32);
            this.buttonLinkedLemma.setText(Messages.DictionarySearchMaskView_Linked_Lemmas_Only);
        } else {
            Label labelWBLEfalse = new Label(compositeLinkedLemmasOnly, 0);
            labelWBLEfalse.setText(" ");
        }
        this.labelSearchStatus = new Label(compositeLimitCount, 0);
        GridData gridData = new GridData(105, -1);
        this.labelSearchStatus.setLayoutData((Object)gridData);
        this.labelSearchStatus.setText(" ");
        this.treeViewer = new CheckboxTreeViewer(this.top);
        GridData treeGridData = new GridData();
        treeGridData.horizontalAlignment = 4;
        treeGridData.horizontalSpan = 3;
        treeGridData.verticalAlignment = 4;
        treeGridData.grabExcessVerticalSpace = true;
        treeGridData.grabExcessHorizontalSpace = true;
        this.treeViewer.getTree().setLayoutData((Object)treeGridData);
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof List) {
                    return ((List)parentElement).toArray();
                }
                if (parentElement instanceof Library) {
                    return ((Library)parentElement).getDictionaryGroups().toArray();
                }
                if (parentElement instanceof DictionaryGroup) {
                    return ((DictionaryGroup)parentElement).getDictionaries().toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof DictionaryGroup) {
                    return ((DictionaryGroup)element).getAssociatedLibrary();
                }
                if (element instanceof DictionaryW) {
                    return ((DictionaryW)element).getAssociatedDictionaryGroup();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof List) {
                    return ((List)element).size() > 0;
                }
                if (element instanceof Library) {
                    return ((Library)element).getDictionaryGroups().size() > 0;
                }
                if (element instanceof DictionaryGroup) {
                    return ((DictionaryGroup)element).getDictionaries().size() > 0;
                }
                return false;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TestLabelProvider());
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    DictionarySearchMaskView.this.treeViewer.setSubtreeChecked(event.getElement(), true);
                    DictionarySearchMaskView.this.getCheckedDictionaries();
                } else {
                    DictionarySearchMaskView.this.treeViewer.setSubtreeChecked(event.getElement(), false);
                    DictionarySearchMaskView.this.getCheckedDictionaries();
                }
            }
        });
        try {
            this.treeViewer.setInput(this.initModel());
        }
        catch (SAXException e2) {
            Status status = new Status(4, "info.textgrid.lab.dicitionarysearch", "SAXException in DictionarySearchMaskView (treeViewer.setInput(initModel());", (Throwable)e2);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        catch (IOException e2) {
            Status status = new Status(4, "info.textgrid.lab.dicitionarysearch", "IOException in DictionarySearchMaskView (treeViewer.setInput(initModel());", (Throwable)e2);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        catch (ParserConfigurationException e2) {
            Status status = new Status(4, "info.textgrid.lab.dicitionarysearch", "ParseConfigurationException in DictionarySearchMaskView (treeViewer.setInput(initModel());", (Throwable)e2);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        this.treeViewer.expandAll();
        this.treeViewer.setAllChecked(true);
        this.treeViewer.getControl().setBackground(new Color(null, 238, 238, 238));
        this.lemma.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 && DictionarySearchMaskView.this.checkAllNecessary()) {
                    DictionarySearchView dsv;
                    if (DictionarySearchMaskView.this.buttonSearchFormExact.getSelection()) {
                        DictionarySearchMaskView.this.suchArt = "e";
                    } else {
                        DictionarySearchMaskView.this.suchArt = "u";
                    }
                    if (DictionarySearchMaskView.this.textLimit.getText() != "") {
                        LIMIT = DictionarySearchMaskView.this.textLimit.getText();
                    }
                    DictionarySearchMaskView.this.labelSearchStatus.setForeground(new Color((Device)Display.getCurrent(), 0, 0, 255));
                    DictionarySearchMaskView.this.labelSearchStatus.setText(SEARCH_PROCESSING);
                    Cursor waitCursor = new Cursor((Device)Display.getCurrent(), 1);
                    parent.setCursor(waitCursor);
                    if (DictionarySearchMaskView.this.withWBLE) {
                        if (DictionarySearchMaskView.this.buttonLinkedLemma.getSelection()) {
                            LINKEDLEMMAS = "true";
                            DictionarySearchMaskView.this.textLimit.setText("1000");
                        } else {
                            LINKEDLEMMAS = "false";
                            DictionarySearchMaskView.this.textLimit.setText(LIMIT);
                        }
                    }
                    if ((dsv = (DictionarySearchView)DictionarySearchMaskView.this.getSite().getPage().findView(DictionarySearchView.ID)) == null) {
                        dsv = (DictionarySearchView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(DictionarySearchView.ID);
                    }
                    if (dsv == null) {
                        try {
                            dsv = (DictionarySearchView)DictionarySearchMaskView.this.getSite().getPage().showView(DictionarySearchView.ID);
                        }
                        catch (PartInitException partInitException) {
                            DictionarySearchMaskView.this.showMessage("Exception!!!!!");
                        }
                    }
                    if (dsv == null) {
                        DictionarySearchMaskView.this.showMessage("dsv immer noch = null :-(");
                    }
                    DSLemma newLemma = new DSLemma(DictionarySearchMaskView.this.lemma.getText());
                    dsv.setOffset("0");
                    dsv.setLimit(DictionarySearchMaskView.this.textLimit.getText());
                    dsv.setSearchType(DictionarySearchMaskView.this.suchArt);
                    dsv.setWbbList(DictionarySearchMaskView.this.getCheckedDictionariesString());
                    dsv.setPageNo(1);
                    dsv.setSearchFromOutside(Boolean.valueOf(true));
                    dsv.getTreeViewer().setInput((Object)newLemma);
                    dsv.getTreeViewer().expandAll();
                    dsv.setNewLabelText(DictionarySearchMaskView.this.lemma.getText());
                    DictionarySearchMaskView.this.labelSearchStatus.setText(" ");
                    Cursor normalCursor = new Cursor((Device)Display.getCurrent(), 0);
                    parent.setCursor(normalCursor);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.buttonSearchStart.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (DictionarySearchMaskView.this.checkAllNecessary()) {
                    if (DictionarySearchMaskView.this.buttonSearchFormExact.getSelection()) {
                        DictionarySearchMaskView.this.suchArt = "e";
                    } else {
                        DictionarySearchMaskView.this.suchArt = "u";
                    }
                    if (DictionarySearchMaskView.this.textLimit.getText() != "") {
                        LIMIT = DictionarySearchMaskView.this.textLimit.getText();
                    }
                    if (DictionarySearchMaskView.this.withWBLE) {
                        if (DictionarySearchMaskView.this.buttonLinkedLemma.getSelection()) {
                            LINKEDLEMMAS = "true";
                            DictionarySearchMaskView.this.textLimit.setText("1000");
                        } else {
                            LINKEDLEMMAS = "false";
                            DictionarySearchMaskView.this.textLimit.setText(LIMIT);
                        }
                    }
                    DictionarySearchMaskView.this.labelSearchStatus.setForeground(new Color((Device)Display.getCurrent(), 0, 0, 255));
                    DictionarySearchMaskView.this.labelSearchStatus.setText(SEARCH_PROCESSING);
                    Cursor waitCursor = new Cursor((Device)Display.getCurrent(), 1);
                    parent.setCursor(waitCursor);
                    DictionarySearchView dsv = (DictionarySearchView)DictionarySearchMaskView.this.getSite().getPage().findView(DictionarySearchView.ID);
                    if (dsv == null) {
                        dsv = (DictionarySearchView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(DictionarySearchView.ID);
                    }
                    if (dsv == null) {
                        try {
                            dsv = (DictionarySearchView)DictionarySearchMaskView.this.getSite().getPage().showView(DictionarySearchView.ID);
                        }
                        catch (PartInitException partInitException) {
                            DictionarySearchMaskView.this.showMessage("Exception!!!!!");
                        }
                    }
                    if (dsv == null) {
                        DictionarySearchMaskView.this.showMessage("dsv immer noch = null :-(");
                    }
                    DSLemma newLemma = new DSLemma(DictionarySearchMaskView.this.lemma.getText());
                    dsv.setOffset("0");
                    dsv.setLimit(DictionarySearchMaskView.this.textLimit.getText());
                    dsv.setSearchType(DictionarySearchMaskView.this.suchArt);
                    dsv.setWbbList(DictionarySearchMaskView.this.getCheckedDictionariesString());
                    dsv.setPageNo(1);
                    dsv.setSearchFromOutside(Boolean.valueOf(true));
                    DictionarySearchMaskView.this.labelSearchStatus.setText(SEARCH_PROCESSING);
                    dsv.getTreeViewer().setInput((Object)newLemma);
                    dsv.getTreeViewer().expandAll();
                    dsv.setNewLabelText(DictionarySearchMaskView.this.lemma.getText());
                    DictionarySearchMaskView.this.labelSearchStatus.setText(" ");
                    Cursor normalCursor = new Cursor((Device)Display.getCurrent(), 0);
                    parent.setCursor(normalCursor);
                }
            }
        });
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.initializeToolBar();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "info.textgrid.lab.dictionarysearch.DictionarySearchView");
    }

    protected String getResultDictionaries(String lemma, String wbbList, String suchArt, String limit) throws RemoteException {
        return null;
    }

    private String getCheckedDictionariesString() {
        Object[] objects = this.treeViewer.getCheckedElements();
        String result = "";
        int i = 0;
        while (i < objects.length) {
            if (objects[i].getClass().getName() == "info.textgrid.lab.woerterbuchsearchmask.view.DictionarySearchMaskView$Library") {
                Library cfr_ignored_0 = (Library)objects[i];
            }
            if (objects[i].getClass().getName() == "info.textgrid.lab.woerterbuchsearchmask.view.DictionarySearchMaskView$DictionaryGroup") {
                DictionaryGroup cfr_ignored_1 = (DictionaryGroup)objects[i];
            }
            if (objects[i].getClass().getName() == "info.textgrid.lab.woerterbuchsearchmask.view.DictionarySearchMaskView$DictionaryW") {
                DictionaryW dict = (DictionaryW)objects[i];
                result = String.valueOf(result) + dict.getKurz() + ",";
            }
            ++i;
        }
        String result2 = "";
        result2 = result.substring(0, result.length() - 1);
        return result2;
    }

    private ArrayList getCheckedDictionaries() {
        ArrayList<Object> result = new ArrayList<Object>();
        Library lib = null;
        DictionaryGroup dicgr = null;
        DictionaryW dict = null;
        Object[] objects = this.treeViewer.getCheckedElements();
        int i = 0;
        while (i < objects.length) {
            result.add(objects[i]);
            if (objects[i].getClass().getName() == "info.textgrid.lab.woerterbuchsearchmask.view.DictionarySearchView$Library") {
                lib = (Library)objects[i];
                lib.printName();
            }
            if (objects[i].getClass().getName() == "info.textgrid.lab.woerterbuchsearchmask.view.DictionarySearchView$DictionaryGroup") {
                dicgr = (DictionaryGroup)objects[i];
                dicgr.printName();
            }
            if (objects[i].getClass().getName() == "info.textgrid.lab.woerterbuchsearchmask.view.DictionarySearchView$Dictionary") {
                dict = (DictionaryW)objects[i];
                dict.printName();
            }
            ++i;
        }
        return result;
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Test Search View", (String)message);
    }

    private Object initModel() throws SAXException, IOException, ParserConfigurationException {
        if (!this.checkWebService()) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Service Error", (String)Messages.DictionarySearchMaskView_Service_Not_Available);
            this.closePerspective();
            return null;
        }
        Wbb_WebService_Impl wbservice = new Wbb_WebService_Impl();
        String response = wbservice.getWbb_WebServiceSoap().wbb_getAllDictionarys("1");
        DocumentBuilder parser = this.factory.newDocumentBuilder();
        ErrorHandler handler = new ErrorHandler(){

            @Override
            public void warning(SAXParseException e) throws SAXException {
                System.err.println("[warning] " + e.getMessage());
            }

            @Override
            public void error(SAXParseException e) throws SAXException {
                System.err.println("[error] " + e.getMessage());
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                System.err.println("[fatal error] " + e.getMessage() + " || " + "Column: " + e.getColumnNumber() + "; Line: " + e.getLineNumber());
                new Date();
                new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                long time = System.currentTimeMillis();
                new File("c:/textgrid_errors/" + time + ".txt");
                new File("c:/textgrid_errors/" + time + ".xml");
            }
        };
        parser.setErrorHandler(handler);
        Document document = parser.parse(new InputSource(new StringReader(response)));
        NodeList groupNodeList = document.getElementsByTagName("group");
        ArrayList<Library> libraries = new ArrayList<Library>();
        Library library = new Library("Dictionaries");
        libraries.add(library);
        int i = 0;
        while (i < groupNodeList.getLength()) {
            Element group = (Element)groupNodeList.item(i);
            String name = group.getAttribute("name");
            DictionaryGroup dg = new DictionaryGroup(name, library);
            library.addDictionaryGroup(dg);
            ++i;
        }
        NodeList dictNodeList = document.getElementsByTagName("dict");
        int i2 = 0;
        while (i2 < dictNodeList.getLength()) {
            Element dictionary = (Element)dictNodeList.item(i2);
            Element parentNode = (Element)dictionary.getParentNode();
            String name = dictionary.getElementsByTagName("name").item(0).getFirstChild().getNodeValue();
            String kurz = dictionary.getElementsByTagName("kurz").item(0).getFirstChild().getNodeValue();
            String color = dictionary.getAttribute("color");
            String bgcolor = dictionary.getAttribute("bgcolor");
            int index = 1000;
            DictionaryGroup tempgroup = null;
            int j = 0;
            while (j < library.getDictionaryGroups().size()) {
                tempgroup = (DictionaryGroup)library.getDictionaryGroups().get(j);
                if (tempgroup.getName().equals(parentNode.getAttribute("name"))) {
                    index = j;
                    break;
                }
                ++j;
            }
            tempgroup = (DictionaryGroup)library.getDictionaryGroups().get(index);
            DictionaryW tempDict = new DictionaryW(name, kurz, color, bgcolor, tempgroup);
            tempgroup.addDictionary(tempDict);
            ++i2;
        }
        return libraries;
    }

    public void setFocus() {
        if (this.top != null) {
            this.top.setFocus();
        }
    }

    private boolean checkAllNecessary() {
        if (this.lemma.getText().equals("")) {
            this.showMessage(Messages.DictionarySearchMaskView_Specify_Keyword);
            return false;
        }
        if (Integer.parseInt(this.textLimit.getText()) > 1000) {
            this.showMessage(Messages.DictionarySearchMaskView_Max_Limit_Value);
            this.textLimit.setText("1000");
            return false;
        }
        if (this.getCheckedDictionaries().isEmpty()) {
            this.showMessage(Messages.DictionarySearchMaskView_Select_Dict);
            return false;
        }
        return true;
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    private void closePerspective() {
        IWorkbench wb = PlatformUI.getWorkbench();
        wb.getActiveWorkbenchWindow().getActivePage().closePerspective(wb.getPerspectiveRegistry().findPerspectiveWithId("info.textgrid.lab.woerterbuchsearchmask.perspectives.RelEngPerspective"), false, true);
    }

    public boolean checkWebService() {
        String URL2 = TG_WOERTERBUCH_WEBSERVICE_UNI_TRIER;
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection con = (HttpURLConnection)new URL(URL2).openConnection();
            con.setRequestMethod("GET");
            con.setReadTimeout(8000);
            return con.getResponseCode() == 200;
        }
        catch (IOException iOException) {
            System.out.println("FEHLER!!!!!!!!!!!");
            return false;
        }
    }

    private class DictionaryGroup {
        private String name;
        private Library associatedLibrary;
        private List dictionaries;

        public DictionaryGroup(String name, Library associatedLibrary) {
            this.associatedLibrary = associatedLibrary;
            this.name = name;
            this.dictionaries = new ArrayList();
        }

        public boolean addDictionary(DictionaryW o) {
            return this.dictionaries.add(o);
        }

        public Library getAssociatedLibrary() {
            return this.associatedLibrary;
        }

        public List getDictionaries() {
            return this.dictionaries;
        }

        public String getName() {
            return this.name;
        }

        public void printName() {
            System.out.println(this.name);
        }
    }

    private class DictionaryW {
        private String name;
        private String kurz;
        private String color;
        private String bgcolor;
        private DictionaryGroup associatedDictionaryGroup;

        public DictionaryW(String name, String kurz, String color, String bgcolor, DictionaryGroup associatedDictionaryGroup) {
            this.associatedDictionaryGroup = associatedDictionaryGroup;
            this.color = color;
            this.bgcolor = bgcolor;
            this.name = name;
            this.kurz = kurz;
        }

        public DictionaryGroup getAssociatedDictionaryGroup() {
            return this.associatedDictionaryGroup;
        }

        public String getName() {
            return this.name;
        }

        public String getKurz() {
            return this.kurz;
        }

        public String getColor() {
            return this.color;
        }

        public String getBgColor() {
            return this.bgcolor;
        }

        public void printName() {
            System.out.println(this.name);
        }

        public boolean getBlockedBackground() {
            return false;
        }

        public void setBlockedBackground() {
        }

        public boolean getBlockedForeground() {
            return false;
        }

        public void setBlockedForeground() {
        }
    }

    private class Library {
        String name;
        List dictionaryGroups;

        public Library(String name) {
            this.name = name;
            this.dictionaryGroups = new ArrayList();
        }

        public boolean addDictionaryGroup(DictionaryGroup o) {
            return this.dictionaryGroups.add(o);
        }

        public List getDictionaryGroups() {
            return this.dictionaryGroups;
        }

        public String getName() {
            return this.name;
        }

        public void printName() {
            System.out.println(this.name);
        }
    }

    class TestLabelProvider
    extends LabelProvider
    implements IFontProvider,
    IColorProvider {
        TestLabelProvider() {
        }

        public Color getBackground(Object element) {
            if (element instanceof DictionaryW) {
                DictionaryW dictionary = (DictionaryW)element;
                if (!dictionary.getBlockedBackground()) {
                    Color color = this.calculateColor(dictionary.getBgColor());
                    dictionary.setBlockedBackground();
                    return color;
                }
                Color color = new Color(null, 238, 238, 238);
                return color;
            }
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof DictionaryW) {
                DictionaryW dictionary = (DictionaryW)element;
                if (!dictionary.getBlockedForeground()) {
                    Color color = this.calculateColor(dictionary.getColor());
                    dictionary.setBlockedForeground();
                    return color;
                }
                Color color = new Color(null, 0, 0, 0);
                return color;
            }
            return null;
        }

        public Color calculateColor(String colorString) {
            String stringColor = colorString;
            String substring1 = stringColor.substring(1, 3);
            String substring2 = stringColor.substring(3, 5);
            String substring3 = stringColor.substring(5, 7);
            int redValue = Integer.parseInt(substring1, 16);
            int greenValue = Integer.parseInt(substring2, 16);
            int blueValue = Integer.parseInt(substring3, 16);
            Color color = new Color(null, redValue, greenValue, blueValue);
            return color;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Library) {
                Library library = (Library)element;
                return library.getName();
            }
            if (element instanceof DictionaryGroup) {
                DictionaryGroup dictionaryGroup = (DictionaryGroup)element;
                return dictionaryGroup.getName();
            }
            if (element instanceof DictionaryW) {
                DictionaryW dictionary = (DictionaryW)element;
                return dictionary.getName();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Font getFont(Object element) {
            if (element instanceof DictionaryW) {
                DictionaryW cfr_ignored_0 = (DictionaryW)element;
                Font returnValue = null;
                Font defaultFont = JFaceResources.getDefaultFont();
                FontData[] data = defaultFont.getFontData();
                int i = 0;
                while (i < data.length) {
                    data[i].setStyle(1);
                    ++i;
                }
                returnValue = new Font((Device)Display.getDefault(), data);
                return returnValue;
            }
            return null;
        }
    }
}

