/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.debug.views;

import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.core.swtutils.annotations.ActiveEditorAnnotationViewerController;
import info.textgrid.lab.core.swtutils.annotations.AnnotationContentProvider;
import net.sf.vex.layout.VexAnnotationSupport;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.IAnnotationImageProvider;

public class AnnotationView
extends ViewPart {
    private TableViewer viewer;
    private ActiveEditorAnnotationViewerController controller;

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 65536);
        TableViewerColumn textColumn = new TableViewerColumn(this.viewer, 16384, 0);
        textColumn.getColumn().setText("Text");
        textColumn.getColumn().setWidth(200);
        textColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Annotation) {
                    Annotation annotation = (Annotation)element;
                    return annotation.getText();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn typeColumn = new TableViewerColumn(this.viewer, 16384, 1);
        typeColumn.getColumn().setText("Type");
        typeColumn.getColumn().setWidth(200);
        typeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Annotation) {
                    Annotation annotation = (Annotation)element;
                    return annotation.getType();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn prefsColumn = new TableViewerColumn(this.viewer, 16384);
        prefsColumn.getColumn().setText("Preferences");
        prefsColumn.getColumn().setWidth(400);
        prefsColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new AnnotationPrefsLabelProvider()));
        AnnotationContentProvider contentProvider = new AnnotationContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                this.reveal(selection);
            }

            private void reveal(ISelection selection) {
                Annotation annotation;
                if (selection != null && selection instanceof IStructuredSelection && (annotation = (Annotation)AdapterUtils.getAdapter((Object)((IStructuredSelection)selection).getFirstElement(), Annotation.class)) != null) {
                    Position position = AnnotationView.this.controller.getAnnotationModel().getPosition(annotation);
                    AnnotationView.this.controller.getTextEditor().selectAndReveal(position.offset, position.length);
                }
            }
        });
        this.controller = new ActiveEditorAnnotationViewerController((AbstractTableViewer)this.viewer);
        this.getSite().getPage().addPartListener((IPartListener)this.controller);
        IEditorPart activeEditor = this.getSite().getPage().getActiveEditor();
        if (activeEditor != null) {
            this.controller.partActivated((IWorkbenchPart)activeEditor);
        }
    }

    public void dispose() {
        if (this.controller != null) {
            this.getSite().getPage().removePartListener((IPartListener)this.controller);
        }
        super.dispose();
    }

    public void setFocus() {
    }

    private final class AnnotationPrefsLabelProvider
    extends BaseLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private VexAnnotationSupport annotationSupport = new VexAnnotationSupport();

        public AnnotationPreference getPreference(Object element) {
            if (element instanceof Annotation) {
                return this.annotationSupport.getPreference((Object)((Annotation)element).getType());
            }
            if (element instanceof String) {
                return this.annotationSupport.getPreference((Object)((String)element));
            }
            return null;
        }

        public Image getImage(Object element) {
            IAnnotationImageProvider provider;
            AnnotationPreference preference = this.getPreference(element);
            if (preference != null && (provider = preference.getAnnotationImageProvider()) != null) {
                return provider.getManagedImage((Annotation)element);
            }
            return null;
        }

        public StyledString getStyledText(Object element) {
            AnnotationPreference preference = this.annotationSupport.getPreference((Annotation)element);
            String label = this.annotationSupport.getAccess().getTypeLabel((Annotation)element);
            if (preference != null) {
                final RGB rgb = preference.getColorPreferenceValue();
                String textStyleValue = this.annotationSupport.getAnnotationDecorationType(((Annotation)element).getType());
                StyledString styledString = new StyledString(label == null ? "null" : label, new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        if (rgb != null) {
                            textStyle.background = new Color((Device)Display.getDefault(), rgb);
                        }
                    }
                });
                if (textStyleValue != null) {
                    styledString.append(": ").append(textStyleValue);
                }
                return styledString;
            }
            return new StyledString(label != null ? label : element.toString());
        }
    }
}

