/*
 * Decompiled with CFR 0.152.
 */
package com.logabit.xlayout;

import com.logabit.xlayout.ControlHandlerConfig;
import com.logabit.xlayout.ParseException;
import com.logabit.xlayout.XLayout;
import com.logabit.xlayout.XLayoutFactoryException;
import com.logabit.xlayout.handlers.IControlHandler;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;

public class XLayoutFactory {
    private static final String DEFAULT_HANDLERS_CONFIG_NAME = "handler-config-default.xml";
    private static final String USER_HANDLERS_CONFIG_NAME = "handler-config.xml";
    private Map<String, ControlHandlerConfig> controlHandlerConfigs = new HashMap<String, ControlHandlerConfig>();
    private static ClassLoader resourceClassLoader;
    private static XLayoutFactory factory;

    static {
        factory = null;
    }

    public static XLayoutFactory getFactory(ClassLoader resourceClassLoader) {
        XLayoutFactory.resourceClassLoader = resourceClassLoader;
        return XLayoutFactory.getFactory();
    }

    public static XLayoutFactory getFactory() {
        if (factory == null) {
            factory = new XLayoutFactory();
        }
        return factory;
    }

    private XLayoutFactory() {
        this.findAndRegisterDefaultControlHandlers();
        this.findAndRegisterCustomControlHandlers();
    }

    private void findAndRegisterDefaultControlHandlers() {
        URL resource = IControlHandler.class.getResource(DEFAULT_HANDLERS_CONFIG_NAME);
        InputStream is = IControlHandler.class.getResourceAsStream(DEFAULT_HANDLERS_CONFIG_NAME);
        this.registerControlHandlers(is, resource.getFile(), false);
    }

    private void findAndRegisterCustomControlHandlers() {
        URL resource = this.getResourceClassLoader().getResource(USER_HANDLERS_CONFIG_NAME);
        if (resource != null) {
            InputStream is = this.getResourceClassLoader().getResourceAsStream(USER_HANDLERS_CONFIG_NAME);
            this.registerControlHandlers(is, resource.getFile(), true);
        }
    }

    public void destroy() {
        factory = null;
    }

    public XLayout createXLayout() {
        XLayout layout = new XLayout(this.controlHandlerConfigs, this.getResourceClassLoader());
        return layout;
    }

    private ClassLoader getResourceClassLoader() {
        if (resourceClassLoader == null) {
            return IControlHandler.class.getClassLoader();
        }
        return resourceClassLoader;
    }

    public void registerControlHandler(String name, IControlHandler handler, boolean overwrite) {
        if (!overwrite && this.controlHandlerConfigs.containsKey(name)) {
            return;
        }
        ControlHandlerConfig config = new ControlHandlerConfig(name, handler);
        this.registerControlHandler(config, overwrite);
    }

    public void removeControlHandler(String name) {
        this.controlHandlerConfigs.remove(name);
    }

    public void registerControlHandler(ControlHandlerConfig handlerConfig, boolean overwrite) {
        if (!overwrite && this.controlHandlerConfigs.containsKey(handlerConfig.getName())) {
            return;
        }
        try {
            this.controlHandlerConfigs.put(handlerConfig.getName(), handlerConfig);
        }
        catch (Exception e) {
            throw new XLayoutFactoryException(NLS.bind((String)"Could not register control handler '{0}'!", (Object)handlerConfig.getName()), e);
        }
    }

    public void registerControlHandlers(List<ControlHandlerConfig> handlerConfigs, boolean overwrite) {
        for (ControlHandlerConfig config : handlerConfigs) {
            this.registerControlHandler(config, overwrite);
        }
    }

    public void registerControlHandlers(File file, boolean overwrite) {
        Document doc;
        SAXReader reader = new SAXReader();
        try {
            doc = reader.read(file);
        }
        catch (DocumentException e) {
            throw new ParseException(NLS.bind((String)"Error parsing control handler config '{0}': {1}", (Object)file.getPath(), (Object)e.getMessage()), e);
        }
        this.parseControlHandlerDocument(doc, overwrite);
    }

    public void registerControlHandlers(InputStream is, String hint, boolean overwrite) {
        Document doc;
        SAXReader reader = new SAXReader();
        InputSource inputSource = new InputSource(hint);
        inputSource.setByteStream(is);
        try {
            doc = reader.read(inputSource);
        }
        catch (DocumentException e) {
            throw new ParseException(NLS.bind((String)"Error parsing control handler config from input stream '{0}': {1}", (Object)hint, (Object)e.getMessage()), e);
        }
        this.parseControlHandlerDocument(doc, overwrite);
    }

    private void parseControlHandlerDocument(Document doc, boolean overwrite) {
        Element root = doc.getRootElement();
        List controlHandlers = root.selectNodes("control-handler");
        ArrayList<ControlHandlerConfig> handlerConfigs = new ArrayList<ControlHandlerConfig>();
        for (Element elemControlHandler : controlHandlers) {
            String name = elemControlHandler.valueOf("@name");
            String className = elemControlHandler.valueOf("@class");
            String defaultStyle = elemControlHandler.valueOf("@default-style");
            ControlHandlerConfig config = new ControlHandlerConfig(name, className, defaultStyle);
            handlerConfigs.add(config);
        }
        this.registerControlHandlers(handlerConfigs, overwrite);
    }

    public ControlHandlerConfig getControlHandlerConfig(String name) {
        return this.controlHandlerConfigs.get(name);
    }

    public boolean containsControlHandler(String name) {
        return this.controlHandlerConfigs.containsKey(name);
    }
}

