/*
 * Decompiled with CFR 0.152.
 */
package com.logabit.xlayout.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import org.xml.sax.InputSource;

public class XLayoutSource {
    private String hint;
    private InputStream is;
    private Object cachingKey;
    private File file;

    public XLayoutSource(String hint, InputStream is) {
        this.hint = hint;
        this.is = is;
        this.setCachingKey(hint);
    }

    public XLayoutSource(URL url) {
        this.hint = url.getFile();
        try {
            this.file = new File(this.hint);
            this.is = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.setCachingKey(this.file.getAbsolutePath());
    }

    public XLayoutSource(File file) {
        this.file = file;
        this.hint = file.getAbsolutePath();
        try {
            this.is = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.setCachingKey(file.getAbsolutePath());
    }

    public InputSource toSAXInputSource() {
        InputSource source = new InputSource(this.hint);
        source.setByteStream(this.is);
        return source;
    }

    public String getHint() {
        return this.hint;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public long lastModified() {
        if (this.file != null) {
            return this.file.lastModified();
        }
        return -1L;
    }

    public Object getCachingKey() {
        return this.cachingKey;
    }

    private void setCachingKey(Object cachingKey) {
        this.cachingKey = cachingKey;
    }
}

