/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.navigator;

import info.textgrid.lab.core.model.Activator;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.navigator.Messages;
import info.textgrid.lab.navigator.NaviView;
import java.text.Collator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class NavigatorSorter
extends ViewerSorter {
    Collator col = Collator.getInstance();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int compare(Viewer viewer, Object e1, Object e2) {
        NaviView.NavigatorSortModi sortModus = NaviView.sortModus;
        NaviView.NavigatorSortSequence sortSequence = NaviView.sortSequence;
        int level1 = 0;
        TextGridObject e1Tgo = (TextGridObject)AdapterUtils.getAdapter((Object)e1, TextGridObject.class);
        TextGridObject e2Tgo = (TextGridObject)AdapterUtils.getAdapter((Object)e2, TextGridObject.class);
        try {
            String string2;
            String string1;
            switch (sortModus) {
                case MODIFICATION_DATE: {
                    if (e1Tgo == null) return 0;
                    if (e2Tgo == null) return 0;
                    if (e1Tgo.getLastModified().before(e2Tgo.getLastModified())) {
                        if (!sortSequence.equals((Object)NaviView.NavigatorSortSequence.ASCENDING)) return 1;
                        return -1;
                    }
                    if (e1Tgo.getLastModified().equals(e2Tgo.getLastModified())) {
                        level1 = 0;
                        break;
                    }
                    if (!sortSequence.equals((Object)NaviView.NavigatorSortSequence.ASCENDING)) return -1;
                    return 1;
                }
                case TITLE: {
                    string1 = e1Tgo != null ? e1Tgo.getTitle() : e1.toString();
                    string2 = e2Tgo != null ? e2Tgo.getTitle() : e2.toString();
                    level1 = this.col.compare(string1, string2);
                    if (!sortSequence.equals((Object)NaviView.NavigatorSortSequence.DESCENDING)) break;
                    level1 *= -1;
                    break;
                }
                case TYPE: {
                    string1 = e1Tgo != null ? e1Tgo.getContentType(false).toString() : e1.toString();
                    string2 = e2Tgo != null ? e2Tgo.getContentType(false).toString() : e2.toString();
                    level1 = this.col.compare(string1, string2);
                    if (!sortSequence.equals((Object)NaviView.NavigatorSortSequence.DESCENDING)) break;
                    level1 *= -1;
                    break;
                }
                default: {
                    return 0;
                }
            }
            if (level1 != 0) return level1;
            if (sortModus == NaviView.NavigatorSortModi.TITLE) {
                return level1;
            }
            string1 = e1Tgo != null ? e1Tgo.getTitle() : e1.toString();
            string2 = e2Tgo != null ? e2Tgo.getTitle() : e2.toString();
            int level2 = this.col.compare(string1, string2);
            if (!sortSequence.equals((Object)NaviView.NavigatorSortSequence.DESCENDING)) return level2;
            level2 *= -1;
            return level2;
        }
        catch (CoreException e) {
            Activator.handleProblem((int)4, (Throwable)e, (String)Messages.NavigatorSorter_EM_NoTGO, (Object[])new Object[0]);
            return 0;
        }
    }
}

