/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.model.graphics;

import com.google.common.collect.HashBiMap;
import info.textgrid.lab.linkeditor.model.graphics.TGLayer;
import java.util.Collection;
import java.util.Iterator;

public class TGLayerManager {
    private String ImageUri = "";
    private HashBiMap<Integer, TGLayer> allTGLayer = HashBiMap.create();

    public TGLayerManager(String uri) {
        this.ImageUri = uri;
    }

    public TGLayerManager(Integer layNum, TGLayer newLayer, String uri) {
        this.add(layNum, newLayer);
        this.ImageUri = uri;
    }

    public String getImageUri() {
        return this.ImageUri;
    }

    public int getNextNumber() {
        int nextNumber = 1;
        if (this.allTGLayer.size() == 0) {
            return nextNumber;
        }
        nextNumber = this.allTGLayer.size();
        return ++nextNumber;
    }

    public void setImageUri(String imageUri) {
        this.ImageUri = imageUri;
    }

    public TGLayer add(Integer keyNumber, TGLayer newLayer) {
        return (TGLayer)this.allTGLayer.put((Object)keyNumber, (Object)newLayer);
    }

    public void remove(int keyNum) {
        this.allTGLayer.remove((Object)keyNum);
    }

    public boolean equals(TGLayer obj) {
        return this.equals(obj);
    }

    public int getSize() {
        return this.allTGLayer.size();
    }

    public Iterator getIterator() {
        Iterator iterator = this.allTGLayer.values().iterator();
        return iterator;
    }

    public Collection keySet() {
        return this.allTGLayer.keySet();
    }

    public Collection values() {
        return this.allTGLayer.values();
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        Iterator iterator = this.getIterator();
        while (iterator.hasNext()) {
            TGLayer type = (TGLayer)iterator.next();
            strBuf.append(String.valueOf(type.toString()) + "\n");
        }
        return strBuf.toString();
    }

    public static void main(String[] args) {
        String uri = "textgrid:Maynooth+4+5+10:Lore+Ipsum+2:20100502T115658:image%2Fjpeg:1";
        TGLayer lay1 = new TGLayer("TestLayer 1", 1, true, true);
        TGLayer lay2 = new TGLayer("TestLayer 2", 2, true, false);
        TGLayer lay3 = new TGLayer("TestLayer 3", 3, true, false);
        TGLayerManager layMgr = new TGLayerManager(uri);
        System.out.println(layMgr.add(1, lay1));
        System.out.println(layMgr.add(2, lay2));
        System.out.println(layMgr.add(3, lay3));
        System.out.println(layMgr.toString());
    }
}

