/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.swtutils;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class MessageDialogWithCheckbuttons
extends MessageDialog {
    ArrayList<Button> checkButtons = new ArrayList();
    boolean[] buttonValues;
    String[] messages;

    public MessageDialogWithCheckbuttons(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String[] messages) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.buttonValues = new boolean[messages.length];
        this.messages = messages;
        this.setButtonLabels(dialogButtonLabels);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        this.createCheckButtons(dialogAreaComposite);
        return dialogAreaComposite;
    }

    protected void createCheckButtons(Composite parent) {
        int i = 0;
        while (i < this.messages.length) {
            Button button = new Button(parent, 16416);
            button.setText(this.messages[i]);
            this.checkButtons.add(button);
            this.buttonValues[i] = false;
            button.setFont(parent.getFont());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int i = MessageDialogWithCheckbuttons.this.checkButtons.indexOf(e.getSource());
                    MessageDialogWithCheckbuttons.this.buttonValues[i] = ((Button)e.getSource()).getSelection();
                }
            });
            ++i;
        }
    }

    public boolean getCheckButtonState(int index) {
        return this.buttonValues[index];
    }
}

