/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.swtutils.annotations;

import java.util.Iterator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class AnnotationViewerController
implements ISelectionChangedListener {
    private AbstractTableViewer viewer;
    private ITextEditor textEditor;
    private IAnnotationModel annotationModel;
    private boolean synchronizingSelection = true;

    public AnnotationViewerController(AbstractTableViewer viewer) {
        this.setViewer(viewer);
    }

    protected void setViewer(AbstractTableViewer viewer) {
        this.viewer = viewer;
    }

    public AbstractTableViewer getViewer() {
        return this.viewer;
    }

    public ITextEditor getTextEditor() {
        return this.textEditor;
    }

    public IAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    protected void associateWith(ITextEditor textEditor) {
        this.removeEditorSelectionListener();
        this.textEditor = textEditor;
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider != null) {
            this.annotationModel = documentProvider.getAnnotationModel((Object)textEditor.getEditorInput());
            this.getViewer().setInput((Object)this.annotationModel);
        }
        if (this.synchronizingSelection) {
            this.registerEditorSelectionListener();
        }
    }

    private void registerEditorSelectionListener() {
        if (this.textEditor != null && this.textEditor.getSelectionProvider() != null) {
            ISelectionProvider selectionProvider = this.textEditor.getSelectionProvider();
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    private void removeEditorSelectionListener() {
        if (this.textEditor != null && this.textEditor.getSelectionProvider() != null) {
            ISelectionProvider selectionProvider = this.textEditor.getSelectionProvider();
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    public IDocument getCurrentDocument() {
        IDocumentProvider documentProvider;
        if (this.textEditor != null && (documentProvider = this.textEditor.getDocumentProvider()) != null) {
            return documentProvider.getDocument((Object)this.textEditor.getEditorInput());
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.synchronizingSelection && event.getSelection() instanceof ITextSelection) {
            Iterator iterator;
            ITextSelection textSelection = (ITextSelection)event.getSelection();
            if (this.annotationModel instanceof IAnnotationModelExtension2 && (iterator = ((IAnnotationModelExtension2)this.annotationModel).getAnnotationIterator(textSelection.getOffset(), textSelection.getLength(), true, true)).hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)annotation), true);
            }
        }
    }
}

