/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search.ui.newsearch;

import info.textgrid.lab.core.model.ProjectFileException;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectFile;
import info.textgrid.lab.search.ui.Activator;
import info.textgrid.lab.search.ui.newsearch.Messages;
import info.textgrid.lab.search.ui.newsearch.MetadataMainAreaLine;
import info.textgrid.lab.templateeditor.config.ConfigCreator;
import info.textgrid.lab.templateeditor.config.ConfigCustomElement;
import info.textgrid.namespaces.metadata.projectfile._2008_11_27.TgProjectFile;
import java.util.ArrayList;
import org.apache.axiom.om.OMElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MetadataMainArea {
    private Composite comMainArea;
    private ScrolledComposite scrolledComposite;
    private ArrayList<MetadataMainAreaLine> metadataMainAreaLines = new ArrayList();
    private ArrayList<Label> metadataMainAreaLabels = new ArrayList();
    public ArrayList<ConfigCustomElement> metadataElements = null;
    private TextGridProject metadataProject;

    public MetadataMainArea(Composite comMainAra, ScrolledComposite scrolledComposite) {
        this.comMainArea = comMainAra;
        this.scrolledComposite = scrolledComposite;
        this.metadataMainAreaLines.add(this.addControlLine(true));
        this.metadataMainAreaLabels.add(this.addLabelLine());
        this.metadataMainAreaLines.add(this.addControlLine(false));
        this.setRemoveIconsVisible(false);
    }

    private MetadataMainAreaLine addControlLine(Boolean firstLine) {
        Composite composite = new Composite(this.comMainArea, 0);
        return new MetadataMainAreaLine(this, composite, this.scrolledComposite, firstLine);
    }

    private Label addLabelLine() {
        Composite composite = new Composite(this.comMainArea, 0);
        RowLayout rl = new RowLayout();
        rl.marginLeft = 10;
        composite.setLayout((Layout)rl);
        Label label = new Label(composite, 0);
        label.setText(Messages.MetadataMainArea_AndLabel);
        return label;
    }

    public MetadataMainAreaLine addLine() {
        if (this.metadataMainAreaLines.size() == 2) {
            this.setRemoveIconsVisible(true);
        }
        this.metadataMainAreaLabels.add(this.addLabelLine());
        MetadataMainAreaLine newLine = this.addControlLine(false);
        this.metadataMainAreaLines.add(newLine);
        return newLine;
    }

    public void removeLine(MetadataMainAreaLine line) {
        if (this.metadataMainAreaLines.size() <= 2) {
            return;
        }
        int index = this.metadataMainAreaLines.indexOf(line);
        this.metadataMainAreaLines.remove(line);
        line.getMainComposite().dispose();
        if (index != -1) {
            if (index <= this.metadataMainAreaLabels.size() - 1) {
                Label label = this.metadataMainAreaLabels.get(index);
                label.getParent().dispose();
                this.metadataMainAreaLabels.remove(index);
            } else {
                Label label = this.metadataMainAreaLabels.get(this.metadataMainAreaLabels.size() - 1);
                label.getParent().dispose();
                this.metadataMainAreaLabels.remove(this.metadataMainAreaLabels.size() - 1);
            }
        }
        this.comMainArea.layout();
        this.scrolledComposite.setMinSize(this.scrolledComposite.getContent().computeSize(-1, -1));
        if (this.metadataMainAreaLines.size() == 2) {
            this.setRemoveIconsVisible(false);
        }
    }

    public MetadataMainAreaLine getNextLine(MetadataMainAreaLine line) {
        int index = this.metadataMainAreaLines.indexOf(line);
        if (index != -1) {
            try {
                return this.metadataMainAreaLines.get(index + 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
        return null;
    }

    public Boolean isFirstLine(MetadataMainAreaLine line) {
        int index = this.metadataMainAreaLines.indexOf(line);
        if (index == 1) {
            return true;
        }
        return false;
    }

    private void setRemoveIconsVisible(Boolean state) {
        for (MetadataMainAreaLine line : this.metadataMainAreaLines) {
            line.getDeleteImage().setVisible(state.booleanValue());
        }
    }

    public String getMetadataMainSearchString() {
        String metadataString = "";
        String comboString = "";
        boolean setAND = false;
        for (MetadataMainAreaLine metaLine : this.metadataMainAreaLines) {
            ISelection sel = metaLine.getComboViewer().getSelection();
            Object obj = ((IStructuredSelection)sel).getFirstElement();
            if (obj == null) continue;
            comboString = MetadataMainAreaLine.standardMetadataMap.get(obj);
            if (comboString == null && obj.toString().matches(".*\\[.*\\]")) {
                obj.toString().indexOf("[");
                comboString = obj.toString().substring(0, obj.toString().indexOf("[")).trim();
                comboString = "cns|" + comboString;
            }
            boolean firstRun = true;
            for (Text text : metaLine.getTextList()) {
                if (text.getText().trim().equals("")) continue;
                if (setAND && firstRun) {
                    metadataString = String.valueOf(metadataString) + "AND ";
                }
                if (!firstRun) {
                    metadataString = String.valueOf(metadataString) + "OR ";
                }
                metadataString = String.valueOf(metadataString) + comboString + ":\"" + text.getText().trim() + "\" ";
                firstRun = false;
            }
            setAND = true;
        }
        return metadataString;
    }

    public void setProjectSpecificSearchTags(ArrayList<TextGridProject> projectList) {
        MetadataMainAreaLine.initDynamicLists();
        for (TextGridProject project : projectList) {
            RetieveProjectMetadata metadataJob = new RetieveProjectMetadata("Retrieve project metadata...", project);
            try {
                metadataJob.schedule();
                metadataJob.join();
                if (this.metadataElements == null) continue;
                for (ConfigCustomElement element : this.metadataElements) {
                    MetadataMainAreaLine.addMetadataItem(element.getName(), element.getType(), project.getName());
                }
            }
            catch (InterruptedException e) {
                Status status = new Status(4, "info.textgrid.lab.search.ui", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        for (MetadataMainAreaLine line : this.metadataMainAreaLines) {
            line.initMetadataViewer();
        }
    }

    private final class RetieveProjectMetadata
    extends Job {
        private TgProjectFile projectFileData;
        private final TextGridProjectFile projectFile;

        public RetieveProjectMetadata(String name, TextGridProject project) {
            TextGridProjectFile projectFile;
            super(name);
            this.projectFileData = null;
            MetadataMainArea.this.metadataProject = project;
            this.projectFile = projectFile = new TextGridProjectFile(project);
            MetadataMainArea.this.metadataElements = null;
        }

        protected IStatus run(IProgressMonitor monitor) {
            OMElement config;
            try {
                this.projectFileData = this.projectFile.getProjectFileData(false, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ProjectFileException e) {
                Status status = new Status(4, "info.textgrid.lab.search.ui", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
            OMElement[] appDataChildren = TextGridProjectFile.extractAppDataChildren((TgProjectFile)this.projectFileData);
            OMElement metaSection = null;
            if (appDataChildren != null && appDataChildren.length > 0) {
                OMElement[] oMElementArray = appDataChildren;
                int n = appDataChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    OMElement child = oMElementArray[n2];
                    if (child.getQName().equals(TextGridProjectFile.metadataSectionQName)) {
                        metaSection = child;
                        break;
                    }
                    ++n2;
                }
            }
            if (metaSection != null && (config = metaSection.getFirstChildWithName(ConfigCreator.templateConfQname)) != null) {
                MetadataMainArea.this.metadataElements = ConfigCreator.getConfigCustomElements((OMElement)config);
            }
            return Status.OK_STATUS;
        }
    }
}

